/*
 * Copyright (c) 2006 by National Research Council of Canada.
 *
 * This software is the confidential and proprietary information of
 * the National Research Council of Canada ("Confidential Information").
 * You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into
 * with the National Research Council of Canada.
 *
 * THE NATIONAL RESEARCH COUNCIL OF CANADA MAKES NO REPRESENTATIONS OR
 * WARRANTIES ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * THE NATIONAL RESEARCH COUNCIL OF CANADA SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 *
 */

package ec.app.gep.production;

import ec.*;
import ec.gep.*;
import ec.simple.*;
import ec.util.*;

/**
 * @author Bob Orchard
 *
 * Real-world production data of 446 firms. The goal is to explain the Production as a function of Labor, 
 * Material, and Capital.
 */

public class production extends GEPProblem implements SimpleProblemForm 
{
	public double labour[] = { 0.578928573332564, 0.647836500889114, 0.751665090563535, 0.960084967742947, 0.590346406152308, 0.949712217960872, 0.830716934318144, 0.858494633570545, 0.771959606281942, 0.858937856157285, 0.835518869991531, 0.639122123029562, 0.542228376455329, 0.684544934557461, 0.773413054362067, 0.886034034311026, 0.774799254818792, 0.912609691666404, 0.691221863614187, 0.661515263720882, 0.678215691706821, 0.639241535815504, 0.742030368043443, 0.676347549645521, 0.682359068780067, 0.754057729214324, 0.688635322968081, 0.707742864436003, 0.682178009648318, 0.91930553982298, 0.734231917365668, 0.92381294154418, 0.654373137231336, 0.740573212060986, 0.808358105064245, 0.62976884959802, 0.769342876506036, 0.644435699821978, 0.796546609709984, 0.955225035572909, 0.84464531770265, 0.702505918119535, 0.755871622859062, 0.964554560847409, 0.661517885973207, 0.671889958890958, 0.659918689374877, 0.938095964469223, 0.630380632898429, 0.793077996069546, 0.704289532950892, 0.833520762865799, 0.701894097532656, 0.815511312353268, 0.768657023656379, 0.608138365679104, 0.740887325341902, 0.786467572851391, 0.675388047687345, 0.860878272013083, 0.77029699745421, 0.716405370429208, 0.846008941934189, 0.843187379844654, 0.680004566319577, 0.803763671223428, 0.568862579035375, 0.868948506576537, 0.822916416151603, 0.691763087429749, 0.698467139813523, 0.685807202237266, 0.597019961423727, 0.673167119702763, 0.59805375976777, 0.821341762336014, 0.738454121986208, 0.742556281587133, 0.421407758963006, 0.73487223468036, 0.680675827717829, 0.679772642613675, 0.653769812996165, 0.613826603424124, 0.691918672594998, 0.768096664251092, 0.719596280044565, 0.70723039042673, 0.769557997108816, 0.705303289604223, 0.829954109909855, 0.865265705423295, 0.792442802194219, 0.598709565946868, 0.578648781090413, 0.651547983627203, 0.62976884959802, 0.770140670145102, 0.621282405716995, 0.724775064380197, 0.896645393680985, 0.698912689553372, 0.879617223689046, 0.709652325061896, 0.679906481827108, 0.83273243478882, 0.566757519522423, 0.709244207542164, 0.657047150724621, 0.619586829764196, 0.83241153026727, 0.665374162005654, 0.826608459488753, 0.730520295510373, 0.686261954710734, 0.72004095272816, 0.779787895034269, 0.76598265158389, 0.705127801966444, 0.763448093634462, 0.729049841542991, 0.652962102405583, 0.824260336424283, 0.827597108788192, 0.669329842227975, 0.804963662316224, 0.798238518417368, 0.821251541384366, 0.7468106434897, 0.861877959908456, 0.766307031854493, 0.783936412605159, 0.778169530520682, 0.826823374120409, 0.78562863004191, 0.725777663002906, 0.699684806919703, 0.71331842877223, 0.692606212925964, 0.666036801480589, 0.678083407624821, 0.677068280455278, 0.801009711193536, 0.689858212051942, 0.791992949256483, 0.826048391298302, 0.619551691074288, 0.701048936754984, 0.715994499572347, 0.791776835584104, 0.685408221929952, 0.911397251575951, 0.710553115118371, 0.630687406782856, 0.868603028197537, 0.768281003194215, 0.949409975819402, 0.648830375504696, 0.742221073452916, 0.662340635015756, 0.784418015864952, 0.642859267581314, 0.62747377018334, 0.672587425376084, 0.718054286029673, 0.690586579738269, 0.732457956428188, 0.569250758716027, 0.731083810269026, 0.564395760946783, 0.68796815592773, 0.628677286597313, 0.766457426623339, 0.550712695110503, 0.696282152744489, 0.729986318946832, 0.663649684467576, 0.727607701422068, 0.727956808365481, 0.6292545093746, 0.710066589360341, 0.76400603213758, 0.818597092481414, 0.721472259065024, 0.698784263632783, 0.726913504548573, 0.899752141161488, 0.797810219961818, 0.603146282126827, 0.735223829829133, 0.757227321577232, 0.682424663243585, 0.644114181198039, 0.665496553126287, 0.673942740854614, 0.750482048304061, 0.754168312797093, 0.753917438678178, 0.808262553458626, 0.684670461086626, 0.577126288440242, 0.848621902821816, 0.645963492317147, 0.837283692599636, 0.756374057767587, 0.86497098953182, 0.755459746084417, 0.752972541087816, 0.721111514001264, 0.639364684498696, 0.560834136344891, 0.895763879637721, 0.963434727233092, 0.922310540633397, 0.634748907036629, 0.701082435751125, 0.614585531680283, 0.708623094318535, 0.790781745508491, 0.774062683698111, 0.770415707213091, 0.810503320492345, 0.721219367574699, 0.879727937480938, 0.623947371495855, 0.878523265741169, 0.865177124913511, 0.787910911452616, 0.735646373914996, 0.767564348865675, 0.631503366716096, 0.733133777912717, 0.873235229875002, 0.678214501453395, 0.670133313067004, 0.762047652559915, 0.685739027696765, 0.809653840164648, 0.791461750640124, 0.715402374770146, 0.765834613818029, 0.752229366562156, 0.704847346877328, 0.817972095091972, 0.80101551023861, 0.727086719251527, 0.711603266263215, 0.758591962927571, 0.774634728545672, 0.70621259053824, 0.913275738166747, 0.80837721999029, 0.656497939354776, 0.770735160895059, 0.769985904925316, 0.7468106434897, 0.809394953608444, 0.782696516730402, 0.705164537832974, 0.751337197361122, 0.834280202769077, 0.681218693376227, 0.725423068428311, 0.762868137562726, 0.650684705908474, 0.694876190754547, 0.609818273176747, 0.797026804073028, 0.82872306419886, 0.781367083989621, 0.71409592269372, 0.772920704497183, 0.903825445237361, 0.854296784467984, 0.787729708843828, 0.655551730361683, 0.58537072769417, 0.634279641368861, 0.716123237227133, 0.695396933570915, 0.603523432377034, 0.691009531786472, 0.707197813133697, 0.773873876995714, 0.628210372361271, 0.869096237955741, 0.741945463981591, 0.506906547747597, 0.754249266205667, 0.774489376714702, 0.752498821686478, 0.677002172369102, 0.701216370414555, 0.832449521644299, 0.797570803007284, 0.901179577735378, 0.90332631877842, 0.667966142632217, 0.670369002453295, 0.722879586307572};	
	public double material[] = { 0.470125024289125, 0.491222969960797, 0.579945774920862, 0.822088973338404, 0.423514468498947, 0.801202726363614, 0.686512214915851, 0.674119700802944, 0.567622737125332, 0.7254089891426, 0.753258670184334, 0.45425049373833, 0.337519500366186, 0.494791757634886, 0.584620774362969, 0.736604080124324, 0.594810180637186, 0.743033779281394, 0.488785181029396, 0.439905912538928, 0.502620701793819, 0.636493792511147, 0.542248984541018, 0.551328975429606, 0.536098574911056, 0.58932790564627, 0.492953705527863, 0.558734980291397, 0.509460642483129, 0.760607485211411, 0.552834446384063, 0.793129433095689, 0.492538886738383, 0.593982818806787, 0.650059219660959, 0.265990204918561, 0.617714792942558, 0.46183986024373, 0.625932934748653, 0.83828966035106, 0.695862109284045, 0.537907976769466, 0.596139409683081, 0.820925410214962, 0.473979826031068, 0.505144818033147, 0.457660345627524, 0.799849735908534, 0.465777795176287, 0.643722774648507, 0.563769452327452, 0.690792008500139, 0.501145995805066, 0.649485421834638, 0.625974328384896, 0.483839704994048, 0.549876806947279, 0.600359742031573, 0.525474273268726, 0.728271457475924, 0.615935020508134, 0.537658971190361, 0.711175878496709, 0.711492757636142, 0.498864991518462, 0.676002398661165, 0.387339596777706, 0.747291747971928, 0.630140504051853, 0.485667365596607, 0.518628463221194, 0.501362844135825, 0.389160881044509, 0.500349458582363, 0.443674361391085, 0.652288679024653, 0.575259525609822, 0.616497502995757, 0.587520102872017, 0.509083422724831, 0.534606078926259, 0.490019748319468, 0.457548920121502, 0.43080352973704, 0.473414416795683, 0.587350756615803, 0.514861202009075, 0.544621667066364, 0.578560479577369, 0.559230454565536, 0.645461144357652, 0.693171276087759, 0.637660704873695, 0.483185853864901, 0.465666379535441, 0.566260763669648, 0.441419239498762, 0.613049313490886, 0.517054903884425, 0.588740631180768, 0.718668702186265, 0.566174791810759, 0.814624123940312, 0.613539048256799, 0.517747266720341, 0.653907660479494, 0.71857937913365, 0.519145147517552, 0.529603300387911, 0.517556665200529, 0.651047883211736, 0.500194749056489, 0.671384478572343, 0.559906731545945, 0.491362626551103, 0.599344263894643, 0.654321173118585, 0.593607110386151, 0.529202085992758, 0.622919029962192, 0.552521689943705, 0.487078953007535, 0.712115997452169, 0.617638600113181, 0.522188044887271, 0.74524598169035, 0.627616267985331, 0.680427394574453, 0.524576392339083, 0.703997789195021, 0.666253635123115, 0.761930403956314, 0.574913009633059, 0.669879645413791, 0.653604452301013, 0.548393332131694, 0.508848969860538, 0.486955104559213, 0.530948589470568, 0.784955101347454, 0.465664076204062, 0.44766550811768, 0.621562841954233, 0.534273397332305, 0.866811660478692, 0.640445423731508, 0.592840588248056, 0.578789120462689, 0.537865032225328, 0.65658912029032, 0.584329502842284, 0.70410328467573, 0.586548144950154, 0.474640070932215, 0.679944440049192, 0.598466253647559, 0.822594369533865, 0.476106768952288, 0.630541335484409, 0.49293702522328, 0.614007336357284, 0.494794194651485, 0.462788765740215, 0.516655165912555, 0.569384257911572, 0.486501585131025, 0.53200817304666, 0.338289039567694, 0.555106561968028, 0.408046389459442, 0.494685016632551, 0.429485788922736, 0.715302997121678, 0.353903247142441, 0.519935965288192, 0.538586028803428, 0.450149772482502, 0.569769247673378, 0.626638719941159, 0.543815973024444, 0.575202427637907, 0.590894222679104, 0.647251073777606, 0.559058345234758, 0.564577581014486, 0.613476080924553, 0.742449965006724, 0.642780637263977, 0.427616127856578, 0.659198477703983, 0.574798627960748, 0.538123477740913, 0.462127243597861, 0.53995007678163, 0.53914806867877, 0.600203104976788, 0.644593541643194, 0.559728929647946, 0.636250197026545, 0.486473387116063, 0.521780434378799, 0.660973676084317, 0.472251108996147, 0.674092972961721, 0.595415023897688, 0.759718367015875, 0.599164307485201, 0.619868765188061, 0.574751466338956, 0.472980298395411, 0.428679954651832, 0.777710463412127, 0.822400007698797, 0.78611558624216, 0.432585085386753, 0.524985706205774, 0.446834202148257, 0.565305736114967, 0.674137781593861, 0.618312086857641, 0.617938748955798, 0.641820966813034, 0.522352007226535, 0.699758836341267, 0.417875239070111, 0.796253425054253, 0.75553742713939, 0.626456259210534, 0.700970003162099, 0.552049053813434, 0.439551338173223, 0.590456091476254, 0.74675852272976, 0.499888549888454, 0.462814941015296, 0.607853063067928, 0.478226434827443, 0.637958515641232, 0.597766453831909, 0.526656071996779, 0.609668125387965, 0.537501232319252, 0.567855838311031, 0.686512214915851, 0.656769067285355, 0.559485522961176, 0.571498592195877, 0.589038208037826, 0.658412973206484, 0.616578242851649, 0.763579524741268, 0.707240821790274, 0.509660106351258, 0.619615417400466, 0.617653483057821, 0.524575014825526, 0.690718661249957, 0.605013621027159, 0.548462587507012, 0.571116951323557, 0.653829370187796, 0.528547754024542, 0.55113884406093, 0.613401686022201, 0.505642661629178, 0.523835028623587, 0.434820104800795, 0.646461721571811, 0.706953741367293, 0.556971845191028, 0.553983834988877, 0.648879143830496, 0.786508099135473, 0.674113622696059, 0.64124926341856, 0.476773209427997, 0.400982261164134, 0.472826937198431, 0.606835637004632, 0.545043019663762, 0.420422193840617, 0.600898812447234, 0.54417164945593, 0.588559779812866, 0.223133150662363, 0.716107862482645, 0.525116368447691, 0.234988413554459, 0.5878096624086, 0.590989641545518, 0.53408158713353, 0.48226671126609, 0.463829288067, 0.683495734433642, 0.715126844090946, 0.71099075551815, 0.788025494919296, 0.54802035432549, 0.491713850445125, 0.514938313582929 };
	public double capital[] = { 0.522796849311373, 0.486811507020207, 0.605814643870949, 0.849743372568444, 0.490367396235958, 0.712519333195494, 0.656759860245515, 0.678908982754438, 0.57841209196643, 0.74541853044143, 0.771113855418226, 0.553632459394059, 0.405527109223744, 0.413807467499011, 0.571474420589752, 0.745671760523, 0.592174031138849, 0.725288289428478, 0.513851630110696, 0.450373279852307, 0.57391092895696, 0.533342379226447, 0.569245144445479, 0.536569555517493, 0.53708829095991, 0.59143080998216, 0.423604218262322, 0.56233741652365, 0.548636770744742, 0.754696921836455, 0.605017872838062, 0.780642714495088, 0.564293417920487, 0.572951673100255, 0.626169317406723, 0.506057718429966, 0.590610076874381, 0.505797530017846, 0.621120307992338, 0.79353645719132, 0.710855629164291, 0.451861887033266, 0.662899758989757, 0.989733402598766, 0.561510187932177, 0.511476298655784, 0.553891598809927, 0.845631339062352, 0.485511873500227, 0.627735948379581, 0.518980760411848, 0.701679684888323, 0.56280637296457, 0.640389180979121, 0.613849205804265, 0.473091028643331, 0.624971328794823, 0.65867428731317, 0.540828965554826, 0.73976596600728, 0.689798761417464, 0.600028325136786, 0.689516737685752, 0.719251572380082, 0.472087811528125, 0.67163191823983, 0.468578913566361, 0.704552996356884, 0.710101457812382, 0.560754188938174, 0.619300423887075, 0.605082043270546, 0.484382669547262, 0.53349760886296, 0.465882857234536, 0.660769711073136, 0.570332451862867, 0.663321759796496, 0.600747618940958, 0.513062125323099, 0.564421431178115, 0.595572291859579, 0.477163584988068, 0.498956592312475, 0.497554576209374, 0.609451024538595, 0.520303232843393, 0.584730062449938, 0.589732879911047, 0.544822166220689, 0.621409586173255, 0.711214814958092, 0.709760918261298, 0.447696536825825, 0.455501998580715, 0.60802122517822, 0.50155433796079, 0.607142237976059, 0.455792051677547, 0.551006414162362, 0.745499381892219, 0.650095381880897, 0.756510660753587, 0.601577228770403, 0.5603242500501, 0.537425882627109, 0.433809912426578, 0.543002441165132, 0.551636392269535, 0.439947509601247, 0.65953495978786, 0.506715752235258, 0.671960889812196, 0.634646734628634, 0.501666985820321, 0.566709140220155, 0.665558272250455, 0.626862635431877, 0.550556228794476, 0.687747841731445, 0.612578920795518, 0.518329491971503, 0.698261407284005, 0.64971888079408, 0.518099379697172, 0.715614403002509, 0.613267917960883, 0.710544052368216, 0.574314755169767, 0.714175358740155, 0.697557771867918, 0.818997712229677, 0.605452338915628, 0.693027439923812, 0.671121286808613, 0.631875497533099, 0.598055025471551, 0.539123362274152, 0.524075661409043, 0.647835940722586, 0.529349976624369, 0.496164130157592, 0.67073711977766, 0.574806945671476, 0.786951360964306, 0.704837854202068, 0.48025325110413, 0.59517953238768, 0.574281692645168, 0.652256899561793, 0.530835019193509, 0.768829371426235, 0.640712223621897, 0.430832102846377, 0.721593107951326, 0.634322225027787, 0.807026167012837, 0.527087459849945, 0.581383195410611, 0.506144578393925, 0.622735558142098, 0.526008537867739, 0.509233062440296, 0.557049467001425, 0.593482370993168, 0.550946082744667, 0.569178504463493, 0.365868929185221, 0.562147742023566, 0.388336678509026, 0.537082000198412, 0.503126126951221, 0.572700865390362, 0.372609462981578, 0.493575420949518, 0.558042810297851, 0.505394414799296, 0.640933368469984, 0.629074882072744, 0.526145105475052, 0.533036251334778, 0.651302382048791, 0.655848780704837, 0.575019743583531, 0.564976903166573, 0.626850898280989, 0.70842865002423, 0.723597590686207, 0.407926920885159, 0.716457710453654, 0.589454636201091, 0.537715518513112, 0.467013030788435, 0.549866736087681, 0.463616448448966, 0.635983913506684, 0.665135703022644, 0.572628557538097, 0.637925834086841, 0.602220172354181, 0.345814909298341, 0.704996819184385, 0.548063443392747, 0.675905734256994, 0.574332562792871, 0.758714528647014, 0.690942493184347, 0.623838194262436, 0.552918819406934, 0.513983771633166, 0.48228620903017, 0.713960544398668, 0.86591379366678, 0.819597591954335, 0.563674661835333, 0.620412382942249, 0.497461998230913, 0.584242017418263, 0.737942938440577, 0.601905178955954, 0.661266859689935, 0.643762788886078, 0.522374883698901, 0.744232316852443, 0.443362751217103, 0.822474171696231, 0.774515416205755, 0.634209218102483, 0.64341613005061, 0.583804229357512, 0.508351189564081, 0.591543671507153, 0.728923950844765, 0.452982666942693, 0.462597620698789, 0.587378417899891, 0.514845586438396, 0.659332463796211, 0.584060347954123, 0.560672365829537, 0.567842362868676, 0.556821928860132, 0.517058190042722, 0.680910593007158, 0.683712801625261, 0.569441266432741, 0.533681938109976, 0.594350182382379, 0.631093141719513, 0.670949912017888, 0.750758436387552, 0.704758388831397, 0.517437443810189, 0.658870794792417, 0.647308396833821, 0.568434774913868, 0.677854624541413, 0.610664824182287, 0.5594752357964, 0.581452361031115, 0.683969927586062, 0.581649487701763, 0.628582583368815, 0.606943910056324, 0.535019785058418, 0.48461467750352, 0.491356183827693, 0.526003264604286, 0.667870759782271, 0.591736374021087, 0.558866339423748, 0.578369004320572, 0.829854071132324, 0.688556198859948, 0.621947637354715, 0.585845763047886, 0.445283960971166, 0.406783189308799, 0.653833450785858, 0.508457295014677, 0.438485034028854, 0.470057308963182, 0.556772409376834, 0.605806383063608, 0.525293700928123, 0.736924939001662, 0.438026153251899, 0.429681112498074, 0.586847152143809, 0.669117950501328, 0.56007307357197, 0.500784218582555, 0.519595567214181, 0.648291254340763, 0.785177715439623, 0.782769118884311, 0.793512943789095, 0.519790390986631, 0.513401743777068, 0.516702425681773 };
	public double production[] = { 0.4961250444213, 0.526579154009204, 0.620510191062684, 0.851393105681035, 0.478801001966376, 0.83712319774504, 0.715460444146009, 0.717836604378821, 0.626643645841639, 0.76077306624057, 0.766155210594182, 0.520592799652013, 0.400102626024947, 0.545155654887444, 0.636832478164902, 0.763181710770693, 0.642490864214073, 0.79044066470399, 0.548400414897071, 0.493781608727865, 0.564381277704338, 0.639403319867315, 0.601291364210056, 0.579298206557368, 0.572724574649018, 0.623348305675738, 0.546844655175264, 0.584651377804678, 0.587279195284057, 0.796489381599776, 0.61479533537168, 0.821393459098762, 0.536377710153039, 0.612674458490519, 0.683850851874038, 0.283304320650259, 0.651106805182076, 0.53825327361849, 0.668741057480015, 0.866614448587671, 0.733410987911881, 0.556781159407905, 0.652491677782128, 0.863247086045711, 0.537540848266548, 0.541532592941503, 0.523860011851661, 0.837262376818637, 0.505713590623823, 0.675059456106997, 0.589079169669045, 0.731343513466078, 0.569712035170853, 0.684263077989784, 0.651837277744729, 0.508988690352773, 0.612441825083443, 0.651239807450511, 0.563080787307219, 0.759301573895591, 0.67517294581865, 0.587799795213968, 0.741451991100163, 0.738631570843594, 0.554773831996352, 0.696639802030163, 0.443566612405276, 0.776259344142323, 0.699687336924164, 0.546718856182595, 0.58430525559642, 0.572110003973979, 0.44432641649177, 0.55010100574308, 0.501215175859695, 0.697097956254748, 0.614780336917929, 0.64173666715934, 0.625288842487899, 0.550466749922649, 0.559637245735928, 0.55686912658512, 0.524212893647639, 0.502292156665802, 0.545999038398465, 0.631889837915772, 0.578043569106272, 0.590236643968504, 0.631815795173503, 0.583137430472325, 0.696499828817384, 0.743363379844, 0.682708222753263, 0.500554287951034, 0.497085447836988, 0.604612723254444, 0.458732706085808, 0.649722607467474, 0.528531511563782, 0.611007953194609, 0.759479744313407, 0.587182390779969, 0.830999690465124, 0.646132135400778, 0.555295102570778, 0.676402779685864, 0.729448684395365, 0.565004464969923, 0.569736608672711, 0.532346024628364, 0.690640662862335, 0.538526320301682, 0.711037731939567, 0.627248507373382, 0.543108130182607, 0.616850842497022, 0.685717320862701, 0.649240320224883, 0.571843970697001, 0.669964982371927, 0.614775125159951, 0.541477976310227, 0.738322592216337, 0.685185775328458, 0.550887659645422, 0.760701377576071, 0.666458513700695, 0.712625964558827, 0.596419905038584, 0.741898088575331, 0.693639239761197, 0.771606847080538, 0.634003589790088, 0.707741832728309, 0.679487208345642, 0.608117142887867, 0.590841387057052, 0.564024959842195, 0.58513186942839, 0.791482148209511, 0.521106956125677, 0.529169711306396, 0.657906467490789, 0.583996428772213, 0.880267610267729, 0.692385782770542, 0.610070012442873, 0.597560698923298, 0.586308430920095, 0.687358817103346, 0.606896306348773, 0.764637675177947, 0.624083244940474, 0.518304644541966, 0.731970280613119, 0.631471283820867, 0.853222697211465, 0.530093613380695, 0.659309275310691, 0.531080138639599, 0.660800551738165, 0.548894190000748, 0.520568519009928, 0.559270018369077, 0.60388843285453, 0.535076603649548, 0.58807712054068, 0.402785641966963, 0.625058839722584, 0.44485118256869, 0.549674600823625, 0.473821377874578, 0.719280605082552, 0.419090630608036, 0.550554210615382, 0.60090138751255, 0.510897491655937, 0.623377523281417, 0.671891870747181, 0.550429508908502, 0.597421396885373, 0.665863567455014, 0.702986176801319, 0.587785438377445, 0.581179614400387, 0.641548919744834, 0.767962666313837, 0.691700417174758, 0.454544109607604, 0.671076218920541, 0.630731222484567, 0.575969397427409, 0.52006826083937, 0.564875078500245, 0.561002061147489, 0.636126399101982, 0.668876545791993, 0.617711982520409, 0.687845829856929, 0.5573264247021, 0.535392126446602, 0.731388371556626, 0.52533366697817, 0.714003900542335, 0.634417631212473, 0.791829771029016, 0.652060303748899, 0.651072784436511, 0.601094375314277, 0.513409239713046, 0.458262375774543, 0.803228048365817, 0.859099763787899, 0.819949821802212, 0.510842144324364, 0.583633691159011, 0.49430108539997, 0.598263799779971, 0.70657264809506, 0.659461379929506, 0.670451360389146, 0.675762571298961, 0.581287966622967, 0.741112567425053, 0.496195331020084, 0.815439131190039, 0.779885909079041, 0.667146169613449, 0.705803399281041, 0.608553584569926, 0.513920581526704, 0.617915840033344, 0.774082773728961, 0.543117075710377, 0.523389049566408, 0.629858929520568, 0.53352683788735, 0.691330360986269, 0.658116812794597, 0.576228993499991, 0.64705414051351, 0.610328281830971, 0.584370220350466, 0.715460431899435, 0.690885995530873, 0.598960088330575, 0.593325622531997, 0.620018396773708, 0.675937036072811, 0.63324191448035, 0.800651147604717, 0.734422535860992, 0.541315405111601, 0.677391781780581, 0.661372854789741, 0.596419619894023, 0.716492899809315, 0.651965881951133, 0.575649297537445, 0.602383224537198, 0.704114928826363, 0.551903451776029, 0.604890584625681, 0.64664366838185, 0.531106428668767, 0.57759208442571, 0.476207133563692, 0.685480632464789, 0.72737965582806, 0.630638488355678, 0.596737771729922, 0.684997091692679, 0.812325156457849, 0.726846264565199, 0.667870624830831, 0.553435532488287, 0.461267061981277, 0.511329148782557, 0.636648379312882, 0.59348976085993, 0.470274507472525, 0.625533272885326, 0.599515809644878, 0.629291173855132, 0.28570242492579, 0.761210840564194, 0.58695910126319, 0.364931438485764, 0.625963186425375, 0.636306543602013, 0.594456118577807, 0.52471823955462, 0.550631353864992, 0.717690774908692, 0.739087809208882, 0.739870142496043, 0.814870629582725, 0.57718504779793, 0.533924518670262, 0.579026378198939 }; 
	
	public static final double IDEAL_FITNESS_MINIMUM = 999.99999999;
	
    public void setup(final EvolutionState state,
            final Parameter base)
    {
        super.setup(state, base);
    }

    public double[] getDataValues( String label )
    {
    	if (label.equals("labour"))
    		return (labour);
    	else if (label.equals("material"))
    		return (material);
    	else if (label.equals("capital"))
    		return (capital);
    	else if (label.equals("dependentVariable")) // always called 'dependentVariable'
    		return (production);
    	else
    		return null;   		
    }

	
	public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) 
	{
        if (!ind.evaluated)  // don't bother reevaluating
        {
            // fitness is normalized between 0 and 1000  (1000 * (1/(1+RRSE))
            double fitness = GEPFitnessFunction.RRSEfitness(true, (GEPIndividual)ind);
                      
            // the fitness better be SimpleFitness!
            SimpleFitness f = ((SimpleFitness)ind.fitness);
            f.setFitness(state,(float)fitness, fitness >= IDEAL_FITNESS_MINIMUM);
            ind.evaluated = true;
           
			if (fitness >= IDEAL_FITNESS_MINIMUM)
			   {	
			        ((GEPIndividual)ind).printIndividualForHumans(state, 1, 1);
			   }
        }
        
	}

}
