package ec;
import ec.util.Parameter;

/* 
 * Exchanger.java
 * 
 * Created: Tue Aug 10 21:59:17 1999
 * By: Sean Luke
 */

/**
 * The Exchanger is a singleton object whose job is to (optionally)
 * perform individual exchanges between subpopulations in the run,
 * or exchange individuals with other concurrent evolutionary run processes,
 * using sockets or whatever.  Keep in mind that other processes may go down,
 * or be started up from checkpoints, etc.
 *
 * @author Sean Luke
 * @version 1.0 
 */

public abstract class Exchanger implements Singleton
    {
    /** Initializes contacts with other processes, if that's what you're doing. Called at the beginning of an evolutionary run, before a population is set up. */
    public abstract void initializeContacts(EvolutionState state);

    /** Initializes contacts with other processes, if that's what you're doing.  Called after restarting from a checkpoint. */
    public abstract void reinitializeContacts(EvolutionState state);

    /** Performs exchanges after the population has been evaluated but before it has been bred. */
    public abstract Population preBreedingExchangePopulation(EvolutionState state);

    /** Performs exchanges after the population has been bred but before it has been evaluated. */
    public abstract Population postBreedingExchangePopulation(EvolutionState state);

    /** Closes contacts with other processes, if that's what you're doing.  Called at the end of an evolutionary run. */
    public abstract void closeContacts(EvolutionState state);
    }
