package ec;
import ec.util.Parameter;

/* 
 * Statistics.java
 * 
 * Created: Tue Aug 10 21:10:48 1999
 * By: Sean Luke
 */

/**
 * Statistics is a singleton which generates statistics during the run.
 * There are lots of places where statistics might be nice to print out.
 * Most of this class's
 * methods aren't abstract, because you don't want to have to
 * implement <i>every</i> possible statistics function, now do you?
 *
 * <p>Statistics objects should set up their statistics logs etc. during 
 * <tt>setupStatistics(...)</tt>.  Remember to make the log restartable in
 * case of restarting from a checkpoint.
 *
 * @author Sean Luke
 * @version 1.0 
 */

public abstract class Statistics implements Singleton
    {
    /** Called immediately before population initialization occurs. */
    public void preInitializationStatistics(final EvolutionState state) { }
    /** Called immediately after population initialization occurs. */
    public void postInitializationStatistics(final EvolutionState state) { }

    /** Called immediately before checkpointing occurs. */
    public void preCheckpointStatistics(final EvolutionState state) { }
    /** Called immediately after checkpointing occurs. */
    public void postCheckpointStatistics(final EvolutionState state) { }

    /** Called immediately before evaluation occurs. */
    public void preEvaluationStatistics(final EvolutionState state) { }
    /** Called immediately after evaluation occurs. */
    public void postEvaluationStatistics(final EvolutionState state) { }

    /** Called immediately before the pre-breeding exchange occurs. */
    public void prePreBreedingExchangeStatistics(final EvolutionState state) { }
    /** Called immediately after the pre-breeding exchange occurs. */
    public void postPreBreedingExchangeStatistics(final EvolutionState state) { }

    /** Called immediately before breeding occurs. */
    public void preBreedingStatistics(final EvolutionState state) { }
    /** Called immediately after breeding occurs. */
    public void postBreedingStatistics(final EvolutionState state) { }

    /** Called immediately before the post-breeding exchange occurs. */
    public void prePostBreedingExchangeStatistics(final EvolutionState state) { }
    /** Called immediately after the post-breeding exchange occurs. */
    public void postPostBreedingExchangeStatistics(final EvolutionState state) { }

    /** Called immediately after the run has completed.  <i>result</i>
	is either <tt>state.R_FAILURE</tt>, indicating that an ideal individual
	was not found, or <tt>state.R_SUCCESS</tt>, indicating that an ideal
	individual <i>was</i> found. */
    public void finalStatistics(final EvolutionState state, final int result) { }
    }
