package ec.steadystate;

/* 
 * SteadyStateBreedingSourceForm.java
 * 
 * Created: Sat Nov 20 17:00:18 1999
 * By: Sean Luke
 */

/**
 * @author Sean Luke
 * @version 1.0 
 */

public interface SteadyStateBreedingSourceForm
    {
    /** Called whenever an individual has been replaced by another
	in the population. */
    public void individualReplaced(final SteadyStateEvolutionState state,
				   final int subpopulation,
				   final int thread,
				   final int individual);
    
    /** Issue an error (not a fatal -- we guarantee that callers
	of this method will also call exitIfErrors) if any
	of your sources, or their sources, etc., are not
	of SteadyStateBreedingSourceForm.*/
    public void sourcesAreProperForm(final SteadyStateEvolutionState state);
    }
