package ec.util;

/* 
 * ParameterClassNotFoundException.java
 * 
 * Created: Tue Aug 10 21:22:08 1999
 * By: Sean Luke
 */

/**
 * This is a wrapper for ClassNotFoundException, so that it can be
 * thrown by ParameterDatabase and you don't *have* to catch it.
 * When it gets thrown all the way out, it unwraps and prints the enclosed
 * ClassNotFoundException instead of itself.  This gets thrown typically
 * when you requested an instance or a class from the Parameter database,
 * and it was unable to find it.
 *
 * @author Sean Luke
 * @version 1.0 
 */

public class ParameterClassNotFoundException extends RuntimeException
    {
    public ParameterClassNotFoundException(String s)
	{ super("\n"+s); }
    }
