package ec;

/* 
 * Problem.java
 * 
 * Created: Fri Oct 15 14:16:17 1999
 * By: Sean Luke
 */

/**
 * Problem is a prototype which defines the problem against which we will
 * evaluate individuals in a population. 
 *
 * <p>Since Problems are Prototypes, you should expect a new Problem class to be
 * cloned and used, on a per-thread basis, for the evolution of each
 * chunk of individuals in a new population.  If you for some reason
 * need global Problem information, you will have to provide it
 * statically, or copy pointers over during the protoClone() process
 * (there is likely only one Problem prototype, depending on the
 * Evaluator class used).
 *
 * @author Sean Luke
 * @version 1.0 
 */

public interface Problem extends Prototype
    {
    /** Evaluates the individuals in ind, if necessary (perhaps
	not evaluating them if their evaluated flags are true),
	and sets their fitness appropriately. 

	In a single-evolution system, ind[] is probably of size 1,
	with a single individual to evaluate.  In a coevolutionary
	mechanism, ind[] may consist of more than 1 individual,
	which must be evaluated in a manner consistent to the
	coevolutionary mechanism involved.  Further, the order
	of these individuals may be significant, indicating
	their role in the coevolutionary problem evaluation.
	For this reason, the
	particular Problem class chosen must be carefully associated with
	the particular Evaluator class chosen.
    */

    public void evaluate(final EvolutionState state,
			 final Individual[] ind,
			 final int threadnum);

    /** "Reevaluates" a set of individuals together,
	for the purpose of printing out
	interesting facts about the individuals in the context of the
	Problem, and logs the results.  This might be called to print out 
	facts about the best individuals in the population, for example. */
    
    public void describe(final Individual[] ind, 
			 final EvolutionState state, 
			 final int threadnum, final int log,
			 final int verbosity);
    }
