package ec.app.sum;
import ec.vector.*;
import ec.*;
import ec.simple.*;
import ec.util.*;

/* 
 * Sum.java
 * 
 * Created on Sat Jun 16 23:26:38 EDT 2001
 * By Sean Luke
 */

/**
 * Sum is a simple example of the ec.Vector package, implementing the
 * very simple sum problem (fitness = sum over vector).
 * This is a generalization of the common MaxOnes problem
 * (fitness = number of 1's in vector).
 *
 <p><b>Default Base</b><br>
 gp.node

 *
 * @author Sean Luke
 * @version 1.0 
 */



public class Sum extends Problem implements SimpleProblemForm
    {
    public static final String P_SUM = "sum";
    
    public Parameter defaultBase()
	{
	return super.defaultBase().push(P_SUM);
	}

    public void evaluate(final EvolutionState state,
			 final Individual ind,
			 final int threadnum)
        {
        if (ind.evaluated) return;

            if (!(ind instanceof IntegerVectorIndividual))
                state.output.fatal("Whoa!  It's not an IntegerVectorIndividual!!!",null);
        
            int sum=0;
            IntegerVectorIndividual ind2 = (IntegerVectorIndividual)ind;
            for(int x=0; x<ind2.genome.length; x++)
            sum += ind2.genome[x];
        
        // assume we're using SimpleFitness
        ((SimpleFitness)ind2.fitness).setFitness(state,
		/// ...the fitness...
		(float)(((double)sum)/(ind2.maxgene*ind2.genome.length)),
		///... our definition of the ideal individual
        	sum == ind2.maxgene * ind2.genome.length);
        ind2.evaluated = true;
        }
    
    public void describe(final Individual ind, 
			 final EvolutionState state, 
			 final int threadnum, final int log,
			 final int verbosity) { }
    }
