package ec.vector;

import ec.util.*;
import java.io.*;
import ec.*;

/* 
 * VectorSpecies.java
 * 
 * Created: Thu Mar 22 17:44:00 2001
 * By: Liviu Panait
 */

/**
 * VectorSpecies is a species which can create VectorIndividuals.
 * 
 
 <p><b>Default Base</b><br>
 vector.species

 * @author Liviu Panait
 * @version 1.0 
 */

public class VectorSpecies extends Species
    {

    public static final String P_VECTORSPECIES = "species";

    public Parameter defaultBase()
	{
	return VectorDefaults.base().push(P_VECTORSPECIES);
	}

    public Individual newIndividual(final EvolutionState state,
				    final Subpopulation _population, 
				    final Fitness _fitness) 
	throws CloneNotSupportedException
	{
	VectorIndividual newind = (VectorIndividual)(i_prototype.protoClone());

	// what is my thread????
	newind.reset( state, 0);

	// Set the fitness
	newind.fitness = _fitness;
	newind.evaluated = false;

	// ...and we're ready!
	return newind;
	}
    
    public Individual newIndividual(final EvolutionState state,
				    final Subpopulation _population,
				    final Fitness _fitness,
				    final LineNumberReader reader)
	throws IOException, CloneNotSupportedException
	{
	VectorIndividual newind = (VectorIndividual)(i_prototype.protoClone());
	// Set the fitness -- must be done BEFORE loading!
	newind.fitness = _fitness;
	newind.evaluated = false; // for sanity's sake, though it's a useless line

	// load that sucker
	newind.readIndividual(state,reader);

	// and we're ready!
	return newind;	
	}

    }


