package ec.vector.breed;
import ec.vector.*;
import ec.*;
import ec.util.*;

/* 
 * VectorReproductionPipeline.java
 * 
 * Created: Tue Mar 13 15:03:12 EST 2001
 * By: Sean Luke
 */


/**
 *
 VectorReproductionPipeline is a BreedingPipeline which implements a simple default reproduction
 for VectorIndividuals.  Normally it takes an individual and returns a copy of the individual.
 
 <p><b>Typical Number of Individuals Produced Per <tt>produce(...)</tt> call</b><br>
 (however many its source produces)

 <p><b>Number of Sources</b><br>
 1

 <p><b>Default Base</b><br>
 vector.reproduce (not that it matters)

 * @author Sean Luke
 * @version 1.0
 */

public class VectorReproductionPipeline extends BreedingPipeline
    {
    public static final String P_REPRODUCTION = "reproduce";
    public static final int NUM_SOURCES = 1;

    public Parameter defaultBase() { return VectorDefaults.base().push(P_REPRODUCTION); }
    
    /** Returns 1 */
    public int numSources() { return NUM_SOURCES; }

    public int produce(final int min, 
		       final int max, 
		       final int start,
		       final int subpopulation,
		       final Individual[] inds,
		       final EvolutionState state,
		       final int thread) throws CloneNotSupportedException

        {
        // grab individuals from our source and stick 'em right into inds.
        // we'll modify them from there
        int n = sources[0].produce(min,max,start,subpopulation,inds,state,thread);

        // clone the individuals if necessary
        if (!(sources[0] instanceof BreedingPipeline))
            for(int q=start;q<n+start;q++)
                inds[q] = (Individual)(inds[q].protoClone());

        return n;
        }
    }
    
    
