package ec.es;
import ec.*;
import ec.simple.*;
import java.io.*;
import ec.util.*;

/* 
 * MuPlusLambdaBreeder.java
 * 
 * Created: Thu Sep  7 18:49:42 2000
 * By: Sean Luke
 */

/**
 * MuPlusLambdaBreeder is a Breeder which, together with ESEvolutionState
 * and ESSelection, implements the (mu + lambda) breeding strategy and gathers
 * the comparison data you can use to implement a 1/5-rule mutation mechanism.
 * Note that MuPlusLambdaBreeder increases subpopulation sizes by their mu
 * values in the second generation and keep them at that size thereafter.
 *
 * @author Sean Luke
 * @version 1.0 
 */

public class MuPlusLambdaBreeder extends MuCommaLambdaBreeder
    {
    public Population postProcess(Population newpop, Population oldpop, ESEvolutionState state)
	{

	// we need to concatenate newpop and oldpop
	for(int x=0;x<newpop.subpops.length;x++)
	    {
	    // check to see if the array's big enough
	    if (newpop.subpops[x].individuals.length == state.lambda[x])
		// need to increase
		{
		Individual[] newinds = new Individual[state.lambda[x]+state.mu[x]];
		System.arraycopy(newpop.subpops[x].individuals,0,newinds,0,state.lambda[x]);
		newpop.subpops[x].individuals = newinds;
		}
	    else if (newpop.subpops[x].individuals.length != 
		     state.lambda[x] + state.mu[x])
		state.output.fatal("Subpopulation " + x + " is not of size lambda nor lambda + mu.... it's of size " + newpop.subpops[x].individuals.length + ", something's wrong");

	    // next we do the concatenation.  The lambda children will
	    // be first, followed by the mu parents
	    
	    System.arraycopy(oldpop.subpops[x].individuals,0,
			     newpop.subpops[x].individuals,state.lambda[x],
			     state.mu[x]);
	    }
	return newpop;
	}
    }
