/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.chol;

import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.CommonOps;

public abstract class CholeskyDecompositionCommon_D64
implements CholeskyDecomposition<DenseMatrix64F> {
    protected int maxWidth = -1;
    protected int n;
    protected DenseMatrix64F T;
    protected double[] t;
    protected double[] vv;
    protected boolean lower;
    protected Complex64F det = new Complex64F();

    public CholeskyDecompositionCommon_D64(boolean lower) {
        this.lower = lower;
    }

    public void setExpectedMaxSize(int numRows, int numCols) {
        if (numRows != numCols) {
            throw new IllegalArgumentException("Can only decompose square matrices");
        }
        this.maxWidth = numCols;
        this.vv = new double[this.maxWidth];
    }

    public boolean isLower() {
        return this.lower;
    }

    public boolean decompose(DenseMatrix64F mat) {
        if (mat.numRows > this.maxWidth) {
            this.setExpectedMaxSize(mat.numRows, mat.numCols);
        } else if (mat.numRows != mat.numCols) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        this.n = mat.numRows;
        this.T = mat;
        this.t = this.T.data;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    public boolean inputModified() {
        return true;
    }

    protected abstract boolean decomposeLower();

    protected abstract boolean decomposeUpper();

    public DenseMatrix64F getT(DenseMatrix64F T) {
        if (T == null) {
            T = new DenseMatrix64F(this.n, this.n);
        } else {
            if (T.numRows != this.n || T.numCols != this.n) {
                throw new IllegalArgumentException("Unexpected matrix dimension for T.");
            }
            CommonOps.fill((D1Matrix64F)T, 0.0);
        }
        if (this.lower) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    T.unsafe_set(i, j, this.T.unsafe_get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = i; j < this.n; ++j) {
                    T.unsafe_set(i, j, this.T.unsafe_get(i, j));
                }
            }
        }
        return T;
    }

    public DenseMatrix64F getT() {
        return this.T;
    }

    public double[] _getVV() {
        return this.vv;
    }

    public Complex64F computeDeterminant() {
        double prod = 1.0;
        int total = this.n * this.n;
        for (int i = 0; i < total; i += this.n + 1) {
            prod *= this.t[i];
        }
        this.det.real = prod * prod;
        this.det.imaginary = 0.0;
        return this.det;
    }
}

