/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig;

import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.ops.MatrixFeatures;

public class SwitchingEigenDecomposition
implements EigenDecomposition<DenseMatrix64F> {
    private double tol;
    EigenDecomposition<DenseMatrix64F> symmetricAlg;
    EigenDecomposition<DenseMatrix64F> generalAlg;
    boolean symmetric;
    boolean computeVectors;
    DenseMatrix64F A = new DenseMatrix64F(1, 1);

    public SwitchingEigenDecomposition(int matrixSize, boolean computeVectors, double tol) {
        this.symmetricAlg = DecompositionFactory.eig(matrixSize, computeVectors, true);
        this.generalAlg = DecompositionFactory.eig(matrixSize, computeVectors, false);
        this.computeVectors = computeVectors;
        this.tol = tol;
    }

    public SwitchingEigenDecomposition(int matrixSize) {
        this(matrixSize, true, 1.0E-8);
    }

    public int getNumberOfEigenvalues() {
        return this.symmetric ? this.symmetricAlg.getNumberOfEigenvalues() : this.generalAlg.getNumberOfEigenvalues();
    }

    public Complex64F getEigenvalue(int index) {
        return this.symmetric ? this.symmetricAlg.getEigenvalue(index) : this.generalAlg.getEigenvalue(index);
    }

    public DenseMatrix64F getEigenVector(int index) {
        if (!this.computeVectors) {
            throw new IllegalArgumentException("Configured to not compute eignevectors");
        }
        return this.symmetric ? (DenseMatrix64F)this.symmetricAlg.getEigenVector(index) : (DenseMatrix64F)this.generalAlg.getEigenVector(index);
    }

    public boolean decompose(DenseMatrix64F orig) {
        this.A.set((D1Matrix64F)orig);
        this.symmetric = MatrixFeatures.isSymmetric(this.A, this.tol);
        return this.symmetric ? this.symmetricAlg.decompose((Matrix)this.A) : this.generalAlg.decompose((Matrix)this.A);
    }

    public boolean inputModified() {
        return false;
    }
}

