/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfNewPage;
import java.io.IOException;
import java.io.OutputStream;

public class RtfWriter2
extends DocWriter
implements DocListener {
    RtfDocument rtfDoc = null;

    protected RtfWriter2(Document doc, OutputStream os) {
        super(doc, os);
        doc.addDocListener(this);
        this.rtfDoc = new RtfDocument();
    }

    public static RtfWriter2 getInstance(Document doc, OutputStream os) {
        return new RtfWriter2(doc, os);
    }

    public void setHeader(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setHeader(hf);
    }

    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    public void setFooter(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setFooter(hf);
    }

    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    public void setPageCount(int i) {
    }

    public void resetPageCount() {
    }

    public boolean add(Watermark wm) {
        return false;
    }

    public void removeWatermark() {
    }

    public void clearTextWrap() {
    }

    public void open() {
    }

    public void close() {
        try {
            this.os.write(this.rtfDoc.writeDocument());
            this.os.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        RtfBasicElement rtfElement = this.rtfDoc.getMapper().mapElement(element);
        if (rtfElement != null) {
            this.rtfDoc.add(rtfElement);
            return true;
        }
        return false;
    }

    public boolean newPage() {
        this.rtfDoc.add(new RtfNewPage(this.rtfDoc));
        return true;
    }

    public boolean setMargins(float left, float right, float top, float bottom) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)left * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)right * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)top * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)bottom * 20.0));
        return true;
    }

    public boolean setPageSize(Rectangle rect) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rect);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.rtfDoc.setAutogenerateTOCEntries(autogenerate);
    }
}

