/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Cell;
import com.lowagie.text.Row;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.table.RtfCell;
import com.lowagie.text.rtf.table.RtfTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfRow
extends RtfElement {
    private static final byte[] ROW_BEGIN = "\\trowd".getBytes();
    private static final byte[] ROW_WIDTH_STYLE = "\\trftsWidth3".getBytes();
    private static final byte[] ROW_WIDTH = "\\trwWidth".getBytes();
    private static final byte[] ROW_KEEP_TOGETHER = "\\trkeep".getBytes();
    private static final byte[] ROW_HEADER_ROW = "\\trhdr".getBytes();
    private static final byte[] ROW_ALIGN_LEFT = "\\trql".getBytes();
    private static final byte[] ROW_ALIGN_RIGHT = "\\trqr".getBytes();
    private static final byte[] ROW_ALIGN_CENTER = "\\trql".getBytes();
    private static final byte[] ROW_ALIGN_JUSTIFIED = "\\trqj".getBytes();
    private static final byte[] ROW_GRAPH = "\\trgaph10".getBytes();
    private static final byte[] ROW_CELL_SPACING_LEFT = "\\trspdl".getBytes();
    private static final byte[] ROW_CELL_SPACING_TOP = "\\trspdt".getBytes();
    private static final byte[] ROW_CELL_SPACING_RIGHT = "\\trspdr".getBytes();
    private static final byte[] ROW_CELL_SPACING_BOTTOM = "\\trspdb".getBytes();
    private static final byte[] ROW_CELL_SPACING_LEFT_STYLE = "\\trspdfl3".getBytes();
    private static final byte[] ROW_CELL_SPACING_TOP_STYLE = "\\trspdft3".getBytes();
    private static final byte[] ROW_CELL_SPACING_RIGHT_STYLE = "\\trspdfr3".getBytes();
    private static final byte[] ROW_CELL_SPACING_BOTTOM_STYLE = "\\trspdfb3".getBytes();
    private static final byte[] ROW_CELL_PADDING_LEFT = "\\trpaddl".getBytes();
    private static final byte[] ROW_CELL_PADDING_RIGHT = "\\trpaddr".getBytes();
    private static final byte[] ROW_CELL_PADDING_LEFT_STYLE = "\\trpaddfl3".getBytes();
    private static final byte[] ROW_CELL_PADDING_RIGHT_STYLE = "\\trpaddfr3".getBytes();
    private static final byte[] ROW_END = "\\row".getBytes();
    private RtfTable parentTable = null;
    private ArrayList cells = null;
    private int width = 0;
    private int rowNumber = 0;

    protected RtfRow(RtfDocument doc, RtfTable rtfTable, Row row, int rowNumber) {
        super(doc);
        this.parentTable = rtfTable;
        this.rowNumber = rowNumber;
        this.importRow(row);
    }

    private void importRow(Row row) {
        this.cells = new ArrayList();
        this.width = (int)((float)(this.document.getDocumentHeader().getPageSetting().getPageWidth() / 100) * this.parentTable.getTableWidthPercent());
        int cellRight = 0;
        int cellWidth = 0;
        int i = 0;
        while (i < row.columns()) {
            cellWidth = (int)((float)(this.width / 100) * this.parentTable.getProportionalWidths()[i]);
            Cell cell = (Cell)row.getCell(i);
            RtfCell rtfCell = new RtfCell(this.document, this, cell);
            rtfCell.setCellRight(cellRight += cellWidth);
            rtfCell.setCellWidth(cellWidth);
            this.cells.add(rtfCell);
            ++i;
        }
    }

    protected void handleCellSpanning() {
        int i = 0;
        while (i < this.cells.size()) {
            RtfCell rtfCell = (RtfCell)this.cells.get(i);
            if (rtfCell.getColspan() > 1) {
                int j = rtfCell.getColspan();
                while (j > 1) {
                    if (i + 1 >= this.cells.size()) continue;
                    RtfCell rtfCellMerge = (RtfCell)this.cells.get(i + 1);
                    rtfCell.setCellRight(rtfCell.getCellRight() + rtfCellMerge.getCellWidth());
                    rtfCell.setCellWidth(rtfCell.getCellWidth() + rtfCellMerge.getCellWidth());
                    this.cells.remove(i + 1);
                    --j;
                }
            }
            if (rtfCell.getRowspan() > 1) {
                ArrayList rows = this.parentTable.getRows();
                int j = 1;
                while (j < rtfCell.getRowspan()) {
                    RtfRow mergeRow = (RtfRow)rows.get(this.rowNumber + j);
                    if (this.rowNumber + j < rows.size()) {
                        RtfCell rtfCellMerge = (RtfCell)mergeRow.getCells().get(i);
                        rtfCellMerge.setCellMergeChild(rtfCell);
                    }
                    if (rtfCell.getColspan() > 1) {
                        int k = rtfCell.getColspan();
                        while (k > 1) {
                            mergeRow.getCells().remove(i + 1);
                            --k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            RtfCell rtfCell;
            result.write(ROW_BEGIN);
            result.write(10);
            result.write(ROW_WIDTH_STYLE);
            result.write(ROW_WIDTH);
            result.write(this.intToByteArray(this.width));
            if (this.parentTable.getFitToPage()) {
                result.write(ROW_KEEP_TOGETHER);
            }
            if (this.rowNumber <= this.parentTable.getHeaderRows()) {
                result.write(ROW_HEADER_ROW);
            }
            switch (this.parentTable.getAlignment()) {
                case 0: {
                    result.write(ROW_ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(ROW_ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(ROW_ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    result.write(ROW_ALIGN_JUSTIFIED);
                }
            }
            result.write(ROW_GRAPH);
            result.write(this.parentTable.getBorders().write());
            if (this.parentTable.getCellSpacing() > 0.0f) {
                result.write(ROW_CELL_SPACING_LEFT);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_LEFT_STYLE);
                result.write(ROW_CELL_SPACING_TOP);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_TOP_STYLE);
                result.write(ROW_CELL_SPACING_RIGHT);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_RIGHT_STYLE);
                result.write(ROW_CELL_SPACING_BOTTOM);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_BOTTOM_STYLE);
            }
            result.write(ROW_CELL_PADDING_LEFT);
            result.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
            result.write(ROW_CELL_PADDING_RIGHT);
            result.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
            result.write(ROW_CELL_PADDING_LEFT_STYLE);
            result.write(ROW_CELL_PADDING_RIGHT_STYLE);
            result.write(10);
            int i = 0;
            while (i < this.cells.size()) {
                rtfCell = (RtfCell)this.cells.get(i);
                result.write(rtfCell.writeDefinition());
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                rtfCell = (RtfCell)this.cells.get(i);
                result.write(rtfCell.write());
                ++i;
            }
            result.write(RtfBasicElement.DELIMITER);
            result.write(ROW_END);
            result.write("\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    protected RtfTable getParentTable() {
        return this.parentTable;
    }

    protected ArrayList getCells() {
        return this.cells;
    }
}

