/**
 ** Tile.java
 **
 ** Copyright 2011 by Andrew Crooks, Sarah Wise, Mark Coletti, and
 ** George Mason University.
 **
 ** Licensed under the Academic Free License version 3.0
 **
 ** See the file "LICENSE" for more information
 **
 ** $Id: Tile.java 687 2012-06-25 04:14:18Z mcoletti $
 **/
package sim.app.geo.sleuth;


/**
 * Stores information about the underlying qualities of the raster grid cells
 */
public class Tile
{

    // position in landscape
    int x;
    int y;


    /**
     * In range [1,51].  I have no idea why.
     */
    int slope;

    /**
     * One of four values to indicate how this tile is used.
     */
    int landuse;

    boolean excluded;

    int transport;

    int hillshade;

    boolean urbanOriginally;

    boolean urbanized;


    public Tile(int x, int y)
    {
        this.x = x;
        this.y = y;
    }

}