/*
 * Decompiled with CFR 0.152.
 */
package sim.app.inspectednetwork;

import java.awt.Color;
import java.awt.Paint;
import javax.swing.JFrame;
import sim.app.tutorial5.BandPortrayal2D;
import sim.app.tutorial5.Tutorial5;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.field.SparseField2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Inspector;
import sim.portrayal.Portrayal;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.network.NetworkPortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.portrayal.network.stats.SocialNetworkInspector;

public class InspectedNetworkWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    NetworkPortrayal2D edgePortrayal = new NetworkPortrayal2D();
    ContinuousPortrayal2D nodePortrayal = new ContinuousPortrayal2D();
    SocialNetworkInspector inspector = new SocialNetworkInspector();

    public static void main(String[] args) {
        InspectedNetworkWithUI vid = new InspectedNetworkWithUI();
        Console c = new Console((GUIState)vid);
        c.setVisible(true);
    }

    public InspectedNetworkWithUI() {
        super((SimState)new Tutorial5(System.currentTimeMillis()));
    }

    public InspectedNetworkWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "Inspected Network";
    }

    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public void start() {
        super.start();
        this.setupPortrayals();
    }

    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Tutorial5 tut = (Tutorial5)this.state;
        this.edgePortrayal.setField((Object)new SpatialNetwork2D((SparseField2D)tut.balls, tut.bands));
        this.edgePortrayal.setPortrayalForAll((Portrayal)new BandPortrayal2D());
        this.nodePortrayal.setField((Object)tut.balls);
        this.inspector.setField(tut.bands, this);
        this.display.reset();
        this.display.setBackdrop((Paint)Color.white);
        this.display.repaint();
    }

    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(600.0, 600.0, (GUIState)this);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Tutorial 5 Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach((FieldPortrayal2D)this.edgePortrayal, "Bands");
        this.display.attach((FieldPortrayal2D)this.nodePortrayal, "Balls");
        this.display.attach((Inspector)this.inspector, "Inspector");
    }

    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

