/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import sim.field.network.Network;
import sim.field.network.stats.NetworkStatistics;
import sim.field.network.stats.UnitEdgeMetric;
import sim.field.network.stats.actorcentrality.FreemanNodeIndex;
import sim.field.network.stats.actorcentrality.NodeIndex;
import sim.util.Bag;

public class CentralizationStatistics {
    final double[] centralityIndices;
    final double[] stdCentralityIndices;
    final double avgCentrality;
    final double stdAvgCentrality;
    final double maxCentrality;
    final double stdMaxCentrality;
    final int n;
    double freemanDenominator;
    boolean isFreeman = false;

    public CentralizationStatistics(Network network, NodeIndex metric) {
        this.n = network.allNodes.numObjs;
        this.centralityIndices = new double[this.n];
        this.stdCentralityIndices = new double[this.n];
        double maxPossibleValue = metric.getMaxValue();
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        double oneOverMax = 1.0 / maxPossibleValue;
        int i = 0;
        while (i < network.allNodes.numObjs) {
            double value;
            this.centralityIndices[i] = value = metric.getValue(network.allNodes.objs[i]);
            this.stdCentralityIndices[i] = value * oneOverMax;
            sum += value;
            if (max < value) {
                max = value;
            }
            ++i;
        }
        this.avgCentrality = sum / (double)this.n;
        this.stdAvgCentrality = this.avgCentrality * oneOverMax;
        this.maxCentrality = max;
        this.stdMaxCentrality = max * oneOverMax;
    }

    public double getCentralizationIndexMean(boolean useNormalization) {
        return useNormalization ? this.stdAvgCentrality : this.avgCentrality;
    }

    public double getCentralizationIndexVariance(boolean useNormalization, boolean unbiased) {
        double avg;
        double[] values;
        double sum = 0.0;
        if (useNormalization) {
            values = this.stdCentralityIndices;
            avg = this.stdAvgCentrality;
        } else {
            values = this.centralityIndices;
            avg = this.avgCentrality;
        }
        int i = 0;
        while (i < this.n) {
            double dif = avg - values[i];
            sum += dif * dif;
            ++i;
        }
        return sum / (double)(unbiased ? this.n - 1 : this.n);
    }

    public static Bag getGraphTheoreticCenter(Network network) {
        double[][] distances = NetworkStatistics.getShortestPathsMatrix(network, UnitEdgeMetric.defaultInstance);
        int n = network.allNodes.numObjs;
        int[] maxGeodesics = new int[n];
        int count = 0;
        int min = n;
        int i = 0;
        while (i < n) {
            double[] distances_i = distances[i];
            int maxG_i = 0;
            int j = 0;
            while (j < n) {
                int dist_ij = (int)distances_i[j];
                if (dist_ij > maxG_i) {
                    maxG_i = dist_ij;
                }
                ++j;
            }
            maxGeodesics[i] = maxG_i;
            if (maxG_i > 0 && maxG_i < min) {
                min = maxG_i;
                count = 1;
            } else if (maxG_i == min) {
                ++count;
            }
            ++i;
        }
        if (min == n) {
            return new Bag(network.allNodes);
        }
        Bag b = new Bag(count);
        int i2 = 0;
        while (i2 < n) {
            if (maxGeodesics[i2] == min) {
                b.add(network.allNodes.objs[i2]);
            }
            ++i2;
        }
        return b;
    }

    public CentralizationStatistics(Network network, FreemanNodeIndex metric) {
        this(network, (NodeIndex)metric);
        this.freemanDenominator = metric.getMaxCummulativeDifference();
        this.isFreeman = true;
    }

    public double getGeneralCentralizationIndex() {
        if (!this.isFreeman) {
            throw new RuntimeException("Computable only for FreemanCentralityMeasures");
        }
        return (this.maxCentrality - this.avgCentrality) * (double)this.n / this.freemanDenominator;
    }
}

