/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.DegreeStatistics;
import sim.field.network.stats.NetworkStatistics;
import sim.util.Bag;
import sim.util.DoubleHeap;
import sim.util.IntBag;

public class ConnectivityStatistics {
    public static boolean isStronglyConnected(Network network) {
        if (network.isDirected()) {
            Bag bag = ConnectivityStatistics.getStronglyConnectedComponents(network);
            return bag.numObjs == 1;
        }
        return false;
    }

    public static Bag getStronglyConnectedComponents(Network network) {
        if (!network.isDirected()) {
            throw new RuntimeException("Connect.getStronglyConnectedComponents should be called only with directed graphs");
        }
        Bag result = new Bag();
        int N = NetworkStatistics.getNumberNodes(network);
        double[] finishingTime = new double[N];
        int[] color = new int[N];
        int time = 0;
        int i = 0;
        while (i < N) {
            color[i] = 0;
            ++i;
        }
        i = 0;
        while (i < N) {
            if (color[i] == 0) {
                IntBag myStack = new IntBag();
                myStack.push(i);
                while (!myStack.isEmpty()) {
                    int j = myStack.pop();
                    if (color[j] == 0) {
                        color[j] = 1;
                        myStack.push(j);
                        ++time;
                        Bag edgesOut = network.getEdgesOut(network.allNodes.objs[j]);
                        int k = 0;
                        while (k < edgesOut.numObjs) {
                            Edge edge = (Edge)edgesOut.objs[k];
                            int toNode = network.getNodeIndex(edge.to());
                            if (color[toNode] == 0) {
                                myStack.push(toNode);
                            }
                            ++k;
                        }
                        continue;
                    }
                    color[j] = 2;
                    finishingTime[j] = -(++time);
                }
            }
            ++i;
        }
        Object[] indexes = new Integer[N];
        int i2 = 0;
        while (i2 < N) {
            indexes[i2] = new Integer(i2);
            ++i2;
        }
        DoubleHeap heap = new DoubleHeap(finishingTime, indexes, N);
        int i3 = 0;
        while (i3 < N) {
            color[i3] = 0;
            ++i3;
        }
        while (!heap.isEmpty()) {
            i3 = (Integer)heap.extractMin();
            if (color[i3] != 0) continue;
            Bag component = new Bag();
            IntBag myStack = new IntBag();
            myStack.push(i3);
            while (!myStack.isEmpty()) {
                int j = myStack.pop();
                if (color[j] != 0) continue;
                color[j] = 1;
                component.add(network.allNodes.objs[j]);
                Bag edgesOut = network.getEdgesIn(network.allNodes.objs[j]);
                int k = 0;
                while (k < edgesOut.numObjs) {
                    Edge edge = (Edge)edgesOut.objs[k];
                    int toNode = network.getNodeIndex(edge.from());
                    if (color[toNode] == 0) {
                        myStack.push(toNode);
                    }
                    ++k;
                }
            }
            result.add((Object)component);
        }
        return result;
    }

    public static Bag getConnectedComponents(Network network) {
        return new ConnectedComponentFactory(network).getComponents();
    }

    public static boolean isConnected(Network network) {
        return new ConnectedComponentFactory(network).isConnected();
    }

    static Network createFlowNetwork(Network network) {
        Network flow = new Network(true);
        flow.allNodes = new Bag(network.allNodes);
        int N = NetworkStatistics.getNumberNodes(network);
        if (network.isDirected()) {
            int i = 0;
            while (i < N) {
                Object node = network.allNodes.objs[i];
                Bag edgesIn = network.getEdgesIn(node);
                int j = 0;
                while (j < edgesIn.numObjs) {
                    flow.addEdge(((Edge)edgesIn.objs[j]).from(), node, (Object)new FlowData(0, 1));
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < N) {
                Object node = network.allNodes.objs[i];
                Bag edges = network.getEdgesIn(node);
                int j = 0;
                while (j < edges.numObjs) {
                    flow.addEdge(((Edge)edges.objs[j]).getOtherNode(node), node, (Object)new FlowData(0, 1));
                    ++j;
                }
                ++i;
            }
        }
        return flow;
    }

    static int maxFlow(Network network, Object startNode, Object endNode) {
        int N = NetworkStatistics.getNumberNodes(network);
        int startIndex = network.getNodeIndex(startNode);
        int endIndex = network.getNodeIndex(endNode);
        int i = 0;
        while (i < N) {
            Object node = network.allNodes.objs[i];
            Bag edgesOut = network.getEdgesOut(node);
            int j = 0;
            while (j < edgesOut.numObjs) {
                Edge edge = (Edge)edgesOut.objs[j];
                ((FlowData)edge.info).flow = 0;
                ++j;
            }
            ++i;
        }
        Edge[] parent = new Edge[N];
        IntBag stack = new IntBag();
        boolean foundPath = true;
        block2: while (foundPath) {
            foundPath = false;
            int i2 = 0;
            while (i2 < N) {
                parent[i2] = null;
                ++i2;
            }
            stack.clear();
            stack.push(startIndex);
            while (!stack.isEmpty()) {
                int nodeIndex = stack.pop();
                Object node = network.allNodes.objs[nodeIndex];
                if (nodeIndex == endIndex) {
                    FlowData temp;
                    int maxAmount = -1;
                    Edge edge = parent[endIndex];
                    while (edge != null) {
                        temp = (FlowData)edge.info;
                        if (temp.capacity - temp.flow > maxAmount) {
                            maxAmount = temp.capacity - temp.flow;
                        }
                        edge = parent[network.getNodeIndex(edge.from())];
                    }
                    edge = parent[endIndex];
                    while (edge != null) {
                        temp = (FlowData)edge.info;
                        temp.flow += maxAmount;
                        edge = parent[network.getNodeIndex(edge.from())];
                    }
                    foundPath = true;
                    continue block2;
                }
                Bag edgesOut = network.getEdgesOut(node);
                int i3 = 0;
                while (i3 < edgesOut.numObjs) {
                    Object toNode;
                    int toIndex;
                    Edge edge = (Edge)edgesOut.objs[i3];
                    FlowData flowData = (FlowData)edge.info;
                    if (flowData.flow < flowData.capacity && parent[toIndex = network.getNodeIndex(toNode = edge.to())] == null && toIndex != startIndex) {
                        parent[toIndex] = edge;
                        stack.push(toIndex);
                    }
                    ++i3;
                }
            }
        }
        int totalFlow = 0;
        Bag bag = network.getEdgesOut(startNode);
        int i4 = 0;
        while (i4 < bag.numObjs) {
            Edge e = (Edge)bag.objs[i4];
            FlowData data = (FlowData)e.info;
            totalFlow += data.flow;
            ++i4;
        }
        return totalFlow;
    }

    public static int getEdgeConnectivity(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0) {
            throw new RuntimeException("The graph has no nodes at all.");
        }
        if (N == 1) {
            return NetworkStatistics.getNumberActualEdges(network);
        }
        if (!ConnectivityStatistics.isConnected(network)) {
            return 0;
        }
        if (network.isDirected()) {
            return ConnectivityStatistics.getDigraphEdgeConnectivity(network);
        }
        return ConnectivityStatistics.getGraphEdgeConnectivity(network);
    }

    public static int getDigraphEdgeConnectivity(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        Network flowNet = ConnectivityStatistics.createFlowNetwork(network);
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < N) {
            int flow = ConnectivityStatistics.maxFlow(flowNet, network.allNodes.objs[i], network.allNodes.objs[(i + 1) % N]);
            if (min > flow) {
                min = flow;
            }
            ++i;
        }
        return min;
    }

    public static int getGraphEdgeConnectivity(Network network) {
        Bag D = ConnectivityStatistics.getDominatingSet(network);
        int min = Integer.MAX_VALUE;
        Network flowNet = ConnectivityStatistics.createFlowNetwork(network);
        int i = 1;
        while (i < D.numObjs) {
            int flow = ConnectivityStatistics.maxFlow(flowNet, D.objs[0], D.objs[i]);
            if (min > flow) {
                min = flow;
            }
            ++i;
        }
        int minDegree = DegreeStatistics.getMinInDegree(network);
        if (min > minDegree) {
            min = minDegree;
        }
        return min;
    }

    static Bag getDominatingSet(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        boolean[] adjacent = new boolean[N];
        Bag result = new Bag();
        int i = 0;
        while (i < N) {
            adjacent[i] = false;
            ++i;
        }
        int numAdjacent = 0;
        int i2 = 0;
        while (i2 < N) {
            if (!adjacent[i2]) {
                adjacent[i2] = true;
                ++numAdjacent;
                Object node = network.allNodes.objs[i2];
                result.add(node);
                Bag edges = network.getEdgesIn(node);
                int j = 0;
                while (j < edges.numObjs) {
                    Edge edge = (Edge)edges.objs[j];
                    int index = network.getNodeIndex(edge.getOtherNode(node));
                    if (!adjacent[index]) {
                        adjacent[index] = true;
                        ++numAdjacent;
                    }
                    ++j;
                }
                if (numAdjacent == N) break;
            }
            ++i2;
        }
        return result;
    }

    public static int getNodeConnectivity(Network network) {
        int n1;
        int i;
        int j;
        Object node;
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0) {
            throw new RuntimeException("The graph has no nodes at all.");
        }
        if (N == 1) {
            return 0;
        }
        if (!ConnectivityStatistics.isConnected(network)) {
            return 0;
        }
        int result = N - 1;
        Network flow = new Network(true);
        Object[] w1s = new Object[N];
        Object[] w2s = new Object[N];
        Edge[] edgeW12 = new Edge[N];
        int i2 = 0;
        while (i2 < N) {
            w1s[i2] = new Object();
            flow.addNode(w1s[i2]);
            w2s[i2] = new Object();
            flow.addNode(w2s[i2]);
            edgeW12[i2] = new Edge(w1s[i2], w2s[i2], (Object)new FlowData(0, 1));
            flow.addEdge(edgeW12[i2]);
            ++i2;
        }
        if (network.isDirected()) {
            i2 = 0;
            while (i2 < N) {
                node = network.allNodes.objs[i2];
                Bag edgesIn = network.getEdgesIn(node);
                j = 0;
                while (j < edgesIn.numObjs) {
                    flow.addEdge(w2s[network.getNodeIndex(((Edge)edgesIn.objs[j]).from())], w1s[network.getNodeIndex(node)], (Object)new FlowData(0, 1));
                    ++j;
                }
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < N) {
                node = network.allNodes.objs[i2];
                Bag edges = network.getEdgesIn(node);
                j = 0;
                while (j < edges.numObjs) {
                    flow.addEdge(w2s[network.getNodeIndex(((Edge)edges.objs[j]).getOtherNode(node))], w1s[network.getNodeIndex(node)], (Object)new FlowData(0, 1));
                    ++j;
                }
                ++i2;
            }
        }
        int uIndex = 0;
        int minDegree = Integer.MAX_VALUE;
        int i3 = 0;
        while (i3 < N) {
            int deg = network.getEdgesOut((Object)network.allNodes.objs[i3]).numObjs + network.getEdgesIn((Object)network.allNodes.objs[i3]).numObjs;
            if (minDegree > deg) {
                uIndex = i3;
                minDegree = deg;
            }
            ++i3;
        }
        Object u = network.allNodes.objs[uIndex];
        Bag uIn = network.getEdgesIn(u);
        Bag uOut = network.getEdgesOut(u);
        boolean[] adjacent = new boolean[N];
        if (network.isDirected()) {
            Object toNode;
            i = 0;
            while (i < N) {
                adjacent[i] = false;
                ++i;
            }
            adjacent[uIndex] = true;
            i = 0;
            while (i < uOut.numObjs) {
                toNode = ((Edge)uOut.objs[i]).to();
                adjacent[network.getNodeIndex((Object)toNode)] = true;
                ++i;
            }
            i = 0;
            while (i < N) {
                int res;
                if (!adjacent[i] && result > (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, u, uIndex, network.allNodes.objs[i], i, w1s, w2s, edgeW12))) {
                    result = res;
                }
                ++i;
            }
            i = 0;
            while (i < N) {
                adjacent[i] = false;
                ++i;
            }
            adjacent[uIndex] = true;
            i = 0;
            while (i < uIn.numObjs) {
                toNode = ((Edge)uIn.objs[i]).from();
                adjacent[network.getNodeIndex((Object)toNode)] = true;
                ++i;
            }
            i = 0;
            while (i < N) {
                int res;
                if (!adjacent[i] && result > (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, network.allNodes.objs[i], i, u, uIndex, w1s, w2s, edgeW12))) {
                    result = res;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < N) {
                adjacent[i] = false;
                ++i;
            }
            adjacent[uIndex] = true;
            i = 0;
            while (i < uOut.numObjs) {
                Object toNode = ((Edge)uOut.objs[i]).getOtherNode(u);
                adjacent[network.getNodeIndex((Object)toNode)] = true;
                ++i;
            }
            i = 0;
            while (i < N) {
                int res;
                if (!adjacent[i] && result > (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, u, uIndex, network.allNodes.objs[i], i, w1s, w2s, edgeW12))) {
                    result = res;
                }
                ++i;
            }
        }
        if (network.isDirected()) {
            n1 = 0;
            while (n1 < uIn.numObjs + uOut.numObjs) {
                Object fromNode = n1 < uIn.numObjs ? ((Edge)uIn.objs[n1]).getOtherNode(u) : ((Edge)uOut.objs[n1 - uIn.numObjs]).getOtherNode(u);
                int fromNodeIndex = network.getNodeIndex(fromNode);
                int i4 = 0;
                while (i4 < N) {
                    adjacent[i4] = false;
                    ++i4;
                }
                adjacent[uIndex] = true;
                adjacent[fromNodeIndex] = true;
                i4 = 0;
                while (i4 < uIn.numObjs + uOut.numObjs) {
                    Object toNode = i4 < uIn.numObjs ? ((Edge)uIn.objs[i4]).getOtherNode(u) : ((Edge)uOut.objs[i4 - uIn.numObjs]).getOtherNode(u);
                    adjacent[network.getNodeIndex((Object)toNode)] = true;
                    ++i4;
                }
                i4 = 0;
                while (i4 < N) {
                    int res;
                    if (!adjacent[i4] && result > (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, fromNode, fromNodeIndex, network.allNodes.objs[i4], i4, w1s, w2s, edgeW12))) {
                        result = res;
                    }
                    ++i4;
                }
                ++n1;
            }
        } else {
            n1 = 0;
            while (n1 < uIn.numObjs) {
                Object fromNode = ((Edge)uIn.objs[n1]).getOtherNode(u);
                int fromNodeIndex = network.getNodeIndex(fromNode);
                int i5 = 0;
                while (i5 < N) {
                    adjacent[i5] = false;
                    ++i5;
                }
                adjacent[uIndex] = true;
                adjacent[fromNodeIndex] = true;
                i5 = 0;
                while (i5 < uOut.numObjs) {
                    Object toNode = ((Edge)uOut.objs[i5]).getOtherNode(u);
                    adjacent[network.getNodeIndex((Object)toNode)] = true;
                    ++i5;
                }
                i5 = 0;
                while (i5 < N) {
                    int res;
                    if (!adjacent[i5] && result > (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, fromNode, fromNodeIndex, network.allNodes.objs[i5], i5, w1s, w2s, edgeW12))) {
                        result = res;
                    }
                    ++i5;
                }
                ++n1;
            }
        }
        return result;
    }

    static int maxFlowNodeConnectivity(Network flow, Object source, int sourceIndex, Object sink, int sinkIndex, Object[] w1s, Object[] w2s, Edge[] edgeW12) {
        flow.removeEdge(edgeW12[sourceIndex]);
        flow.removeEdge(edgeW12[sinkIndex]);
        int result = ConnectivityStatistics.maxFlow(flow, w2s[sourceIndex], w1s[sinkIndex]);
        flow.addEdge(edgeW12[sinkIndex]);
        flow.addEdge(edgeW12[sourceIndex]);
        return result;
    }

    static class ConnectedComponentFactory {
        final Network network;
        final int n;
        final Bag components;
        final boolean[] visited;
        int countVisited;

        public ConnectedComponentFactory(Network network) {
            this.network = network;
            this.n = network.allNodes.numObjs;
            this.visited = new boolean[this.n];
            int i = 0;
            while (i < this.n) {
                this.visited[i] = false;
                ++i;
            }
            this.countVisited = 0;
            this.components = new Bag(this.n);
        }

        public Bag getComponents() {
            boolean directed = this.network.isDirected();
            int i = 0;
            while (i < this.n) {
                if (!this.visited[i]) {
                    Bag component = new Bag();
                    this.components.add((Object)component);
                    if (directed) {
                        this.exploreWD(this.network.allNodes.objs[i], i, component);
                    } else {
                        this.exploreU(this.network.allNodes.objs[i], i, component);
                    }
                }
                ++i;
            }
            return this.components;
        }

        public boolean isConnected() {
            if (this.network.isDirected()) {
                this.exploreWD(this.network.allNodes.objs[0], 0, null);
            } else {
                this.exploreU(this.network.allNodes.objs[0], 0, null);
            }
            return this.countVisited == this.n;
        }

        private void exploreWD(Object nodeObj, int nodeIndex, Bag component) {
            int node2Index;
            Object node2;
            this.visited[nodeIndex] = true;
            ++this.countVisited;
            if (component != null) {
                component.add(nodeObj);
            }
            Bag temp = this.network.getEdgesOut(nodeObj);
            int i = 0;
            while (i < temp.numObjs) {
                node2 = ((Edge)temp.objs[i]).getOtherNode(nodeObj);
                node2Index = this.network.getNodeIndex(node2);
                if (!this.visited[node2Index]) {
                    this.exploreWD(node2, node2Index, component);
                }
                ++i;
            }
            temp = this.network.getEdgesIn(nodeObj);
            i = 0;
            while (i < temp.numObjs) {
                node2 = ((Edge)temp.objs[i]).getOtherNode(nodeObj);
                node2Index = this.network.getNodeIndex(node2);
                if (!this.visited[node2Index]) {
                    this.exploreWD(node2, node2Index, component);
                }
                ++i;
            }
        }

        private void exploreU(Object nodeObj, int nodeIndex, Bag component) {
            this.visited[nodeIndex] = true;
            ++this.countVisited;
            if (component != null) {
                component.add(nodeObj);
            }
            Bag temp = this.network.getEdgesOut(nodeObj);
            int i = 0;
            while (i < temp.numObjs) {
                Object node2 = ((Edge)temp.objs[i]).getOtherNode(nodeObj);
                int node2Index = this.network.getNodeIndex(node2);
                if (!this.visited[node2Index]) {
                    this.exploreU(node2, node2Index, component);
                }
                ++i;
            }
        }
    }

    static class FlowData {
        public int flow;
        public int capacity;

        public FlowData(int flow, int capacity) {
            this.flow = flow;
            this.capacity = capacity;
        }

        public FlowData(FlowData md) {
            this.flow = md.flow;
            this.capacity = md.capacity;
        }
    }
}

