/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import java.util.Iterator;
import sim.field.network.Network;
import sim.field.network.stats.NetworkStatistics;
import sim.util.Bag;

public class DegreeStatistics {
    public static int getSumOfDegrees(Network network) {
        return 2 * NetworkStatistics.getNumberActualEdges(network);
    }

    public static int getMinInDegree(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesIn(network.allNodes.objs[i]);
            if (min > temp.numObjs) {
                min = temp.numObjs;
            }
            ++i;
        }
        return min;
    }

    public static int getMinOutDegree(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesOut(network.allNodes.objs[i]);
            if (min > temp.numObjs) {
                min = temp.numObjs;
            }
            ++i;
        }
        return min;
    }

    public static int getMaxInDegree(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesIn(network.allNodes.objs[i]);
            if (max < temp.numObjs) {
                max = temp.numObjs;
            }
            ++i;
        }
        return max;
    }

    public static int getMaxOutDegree(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesOut(network.allNodes.objs[i]);
            if (max < temp.numObjs) {
                max = temp.numObjs;
            }
            ++i;
        }
        return max;
    }

    public static double getMeanInDegree(Network network) {
        int groupSize = NetworkStatistics.getNumberNodes(network);
        if (groupSize == 0) {
            return 0.0;
        }
        return (double)NetworkStatistics.getNumberActualEdges(network) / (double)groupSize;
    }

    public static double getMeanOutDegree(Network network) {
        int groupSize = NetworkStatistics.getNumberNodes(network);
        if (groupSize == 0) {
            return 0.0;
        }
        return (double)NetworkStatistics.getNumberActualEdges(network) / (double)groupSize;
    }

    public static double getVarInDegree(Network network) {
        int sumSq = 0;
        int sum = NetworkStatistics.getNumberActualEdges(network);
        int N = NetworkStatistics.getNumberNodes(network);
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesIn(network.allNodes.objs[i]);
            int inD = temp.numObjs;
            sumSq += inD * inD;
            ++i;
        }
        return (double)(sumSq * N - sum * sum) / (double)(N * (N - 1));
    }

    public static double getVarOutDegree(Network network) {
        int sumSq = 0;
        int sum = NetworkStatistics.getNumberActualEdges(network);
        int N = NetworkStatistics.getNumberNodes(network);
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesOut(network.allNodes.objs[i]);
            int outD = temp.numObjs;
            sumSq += outD * outD;
            ++i;
        }
        return (double)(sumSq * N - sum * sum) / (double)(N * (N - 1));
    }

    public static int[] getDegreeHistogram(Network network, boolean out) {
        int n = network.allNodes.numObjs;
        int[] histogram = new int[n];
        Iterator i = network.indexOutInHash.values().iterator();
        int k = 0;
        while (k < n) {
            int degree;
            Network.IndexOutIn ioi = (Network.IndexOutIn)i.next();
            Bag b = out ? ioi.out : ioi.in;
            int n2 = degree = b == null ? 0 : b.numObjs;
            if (degree >= histogram.length) {
                int[] newhistogram = new int[degree + 1];
                System.arraycopy(histogram, 0, newhistogram, 0, histogram.length);
                histogram = newhistogram;
            }
            int n3 = degree;
            histogram[n3] = histogram[n3] + 1;
            ++k;
        }
        return histogram;
    }

    public static double[] getDegreeCCDF(Network network, boolean out) {
        int[] histogram = DegreeStatistics.getDegreeHistogram(network, out);
        int len = histogram.length;
        double[] ccdf = new double[len];
        int i = 1;
        while (i < len) {
            int n = i;
            histogram[n] = histogram[n] + histogram[i - 1];
            ++i;
        }
        int sum = histogram[len - 1];
        int i2 = 0;
        while (i2 < len) {
            ccdf[i2] = 1.0 - (double)histogram[i2] / (double)sum;
            ++i2;
        }
        return ccdf;
    }
}

