/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import java.util.HashSet;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.util.Bag;

public class DyadTriadStatistics {
    public static final int TRIAD_003 = 0;
    public static final int TRIAD_012 = 1;
    public static final int TRIAD_102 = 2;
    public static final int TRIAD_021D = 3;
    public static final int TRIAD_021U = 4;
    public static final int TRIAD_021C = 5;
    public static final int TRIAD_111D = 6;
    public static final int TRIAD_111U = 7;
    public static final int TRIAD_030T = 8;
    public static final int TRIAD_030C = 9;
    public static final int TRIAD_201 = 10;
    public static final int TRIAD_120D = 11;
    public static final int TRIAD_120U = 12;
    public static final int TRIAD_120C = 13;
    public static final int TRIAD_210 = 14;
    public static final int TRIAD_300 = 15;
    public static final String[] MAN_TRIAD_CLASSES = new String[]{"003", "012", "102", "021D", "021U", "021C", "111D", "111U", "030T", "030C", "201", "120D", "120U", "120C", "210", "300"};
    public static final int DYAD_MUTUAL = 0;
    public static final int DYAD_ASYMMETRIC = 1;
    public static final int DYAD_NULL = 2;
    public static final String[] DYAD_CLASSES = new String[]{"M", "A", "N"};

    public static int[] triadCensus(Network network) {
        int[] census = new int[16];
        int i = 0;
        while (i < 16) {
            census[i] = 0;
            ++i;
        }
        int n = network.allNodes.numObjs;
        if (n < 3) {
            return census;
        }
        Edge[][] adjMatrix = network.getAdjacencyMatrix();
        int i2 = 0;
        while (i2 < n) {
            Edge[] adj_i = adjMatrix[i2];
            int j = i2 + 1;
            while (j < n) {
                Edge[] adj_j = adjMatrix[j];
                int e_ij = adj_i[j] == null ? 0 : 1;
                int e_ji = adj_j[i2] == null ? 0 : 1;
                int m_ij = 0;
                int c_ij = e_ij + e_ji;
                if (c_ij == 2) {
                    ++m_ij;
                }
                int k = j + 1;
                while (k < n) {
                    int c_jk;
                    int md = m_ij;
                    int c = c_ij = e_ij + e_ji;
                    Edge[] adj_k = adjMatrix[k];
                    int e_ik = adj_i[k] == null ? 0 : 1;
                    int e_jk = adj_j[k] == null ? 0 : 1;
                    int e_ki = adj_k[i2] == null ? 0 : 1;
                    int e_kj = adj_k[j] == null ? 0 : 1;
                    int c_ik = e_ik + e_ki;
                    if (c_ik == 2) {
                        ++md;
                    }
                    if ((c_jk = e_jk + e_kj) == 2) {
                        ++md;
                    }
                    switch (c += c_ik + c_jk) {
                        case 0: {
                            census[0] = census[0] + 1;
                            break;
                        }
                        case 1: {
                            census[1] = census[1] + 1;
                            break;
                        }
                        case 2: {
                            if (md == 1) {
                                census[2] = census[2] + 1;
                                break;
                            }
                            int f = c_ij == 0 ? e_jk + e_ik : (c_ik == 0 ? e_ij + e_kj : e_ji + e_ki);
                            switch (f) {
                                case 0: {
                                    census[3] = census[3] + 1;
                                    break;
                                }
                                case 1: {
                                    census[5] = census[5] + 1;
                                    break;
                                }
                                case 2: {
                                    census[4] = census[4] + 1;
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (md == 1) {
                                if (c_ij == 2) {
                                    int n2 = e_ki + e_ki == 0 ? 7 : 6;
                                    census[n2] = census[n2] + 1;
                                    break;
                                }
                                if (c_ik == 2) {
                                    int n3 = e_ji + e_jk == 0 ? 7 : 6;
                                    census[n3] = census[n3] + 1;
                                    break;
                                }
                                int n4 = e_ij + e_ik == 0 ? 7 : 6;
                                census[n4] = census[n4] + 1;
                                break;
                            }
                            int n5 = e_ij + e_ik == 1 && e_ji + e_ki == 1 && e_ji + e_jk == 1 && e_ij + e_kj == 1 ? 9 : 8;
                            census[n5] = census[n5] + 1;
                            break;
                        }
                        case 4: {
                            if (md == 2) {
                                census[10] = census[10] + 1;
                                break;
                            }
                            int in = e_ji + e_ki;
                            int out = e_ij + e_ik;
                            if (in + out == 2) {
                                switch (out) {
                                    case 0: {
                                        census[12] = census[12] + 1;
                                        break;
                                    }
                                    case 1: {
                                        census[13] = census[13] + 1;
                                        break;
                                    }
                                    case 2: {
                                        census[11] = census[11] + 1;
                                    }
                                }
                                break;
                            }
                            in = e_ij + e_kj;
                            out = e_ji + e_jk;
                            if (in + out == 2) {
                                switch (out) {
                                    case 0: {
                                        census[12] = census[12] + 1;
                                        break;
                                    }
                                    case 1: {
                                        census[13] = census[13] + 1;
                                        break;
                                    }
                                    case 2: {
                                        census[11] = census[11] + 1;
                                    }
                                }
                                break;
                            }
                            in = e_ik + e_jk;
                            out = e_ki + e_kj;
                            if (in + out != 2) break;
                            switch (out) {
                                case 0: {
                                    census[12] = census[12] + 1;
                                    break;
                                }
                                case 1: {
                                    census[13] = census[13] + 1;
                                    break;
                                }
                                case 2: {
                                    census[11] = census[11] + 1;
                                }
                            }
                            break;
                        }
                        case 5: {
                            census[14] = census[14] + 1;
                            break;
                        }
                        case 6: {
                            census[15] = census[15] + 1;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return census;
    }

    public static int getNumberDirectTriads(Network network, Object node1, Object node2) {
        if (!network.isDirected()) {
            throw new RuntimeException("NetworkStatistics.getNumberDirectTriads should be called only with directed graphs");
        }
        int result = 0;
        HashSet<Object> hash = new HashSet<Object>();
        Bag out1 = network.getEdgesIn(node1);
        int i = 0;
        while (i < out1.numObjs) {
            hash.add(((Edge)out1.objs[i]).from());
            ++i;
        }
        Bag out2 = network.getEdgesIn(node2);
        int i2 = 0;
        while (i2 < out2.numObjs) {
            if (hash.contains(((Edge)out2.objs[i2]).from())) {
                ++result;
            }
            ++i2;
        }
        return result;
    }

    public static int[] dyadCensus(Network network) {
        int[] census = new int[3];
        int n = network.allNodes.numObjs;
        Edge[][] adjacencyMatrix = network.getAdjacencyMatrix();
        int i = 1;
        while (i < n) {
            Edge[] adj_i = adjacencyMatrix[i];
            int j = 0;
            while (j < i) {
                int k = (adjacencyMatrix[j][i] == null ? 0 : 1) + (adj_i[j] == null ? 0 : 1);
                int n2 = 2 - k;
                census[n2] = census[n2] + 1;
                ++j;
            }
            ++i;
        }
        return census;
    }
}

