/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import java.util.HashSet;
import java.util.Iterator;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.EdgeMetric;
import sim.util.Bag;
import sim.util.DoubleHeap;

public class NetworkStatistics {
    public static int getNumberNodes(Network network) {
        return network.allNodes.numObjs;
    }

    public static int getNumberPotentialEdges(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (network.isDirected()) {
            return N * (N - 1);
        }
        return N * (N - 1) / 2;
    }

    public static int getNumberActualEdges(Network network) {
        int actualTies = 0;
        int N = NetworkStatistics.getNumberNodes(network);
        int i = 0;
        while (i < N) {
            Bag temp = network.getEdgesOut(network.allNodes.objs[i]);
            actualTies += temp.numObjs;
            ++i;
        }
        if (network.isDirected()) {
            return actualTies;
        }
        return actualTies / 2;
    }

    public static double getDensity(Network network) {
        if (NetworkStatistics.getNumberNodes(network) == 0) {
            return 0.0;
        }
        return (double)NetworkStatistics.getNumberActualEdges(network) / (double)NetworkStatistics.getNumberPotentialEdges(network);
    }

    public static Bag getIsolatedNodes(Network network) {
        Bag result = new Bag();
        int N = NetworkStatistics.getNumberNodes(network);
        Iterator i = network.indexOutInHash.values().iterator();
        int k = 0;
        while (k < N) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)i.next();
            if (!(ioi.in != null && ioi.in.numObjs != 0 || ioi.out != null && ioi.out.numObjs != 0)) {
                result.add(network.allNodes.objs[ioi.index]);
            }
            ++k;
        }
        return result;
    }

    public static double getInclusiveness(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        int count = 0;
        Iterator i = network.indexOutInHash.values().iterator();
        int k = 0;
        while (k < N) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)i.next();
            if (!(ioi.in != null && ioi.in.numObjs != 0 || ioi.out != null && ioi.out.numObjs != 0)) {
                ++count;
            }
            ++k;
        }
        return (double)(N - count) / (double)N;
    }

    public static double[] getShortestPaths(Network network, Object startNode, EdgeMetric computer) {
        double[] result = new double[network.allNodes.numObjs];
        int i = 0;
        while (i < result.length) {
            result[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        DoubleHeap heap = new DoubleHeap();
        heap.add(startNode, 0.0);
        while (!heap.isEmpty()) {
            double dist = heap.getMinKey();
            Object node = heap.extractMin();
            int nodeIndex = network.getNodeIndex(node);
            if (result[nodeIndex] <= dist) continue;
            result[nodeIndex] = dist;
            Bag edgesOut = network.getEdgesOut(node);
            int i2 = 0;
            while (i2 < edgesOut.numObjs) {
                double newDist;
                Edge edge = (Edge)edgesOut.objs[i2];
                int toNode = network.getNodeIndex(((Edge)edgesOut.objs[i2]).getOtherNode(node));
                if (result[toNode] > (newDist = dist + computer.getWeight(edge))) {
                    heap.add(network.allNodes.objs[toNode], newDist);
                }
                ++i2;
            }
        }
        return result;
    }

    public static double getShortestPath(Network network, Object startNode, Object endNode, EdgeMetric computer) {
        if (startNode.equals(endNode)) {
            return 0.0;
        }
        double[] result = new double[network.allNodes.numObjs];
        int i = 0;
        while (i < result.length) {
            result[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        DoubleHeap heap = new DoubleHeap();
        heap.add(startNode, 0.0);
        while (!heap.isEmpty()) {
            double dist = heap.getMinKey();
            Object node = heap.extractMin();
            int nodeIndex = network.getNodeIndex(node);
            if (result[nodeIndex] <= dist) continue;
            result[nodeIndex] = dist;
            if (node.equals(endNode)) {
                return dist;
            }
            Bag edgesOut = network.getEdgesOut(node);
            int i2 = 0;
            while (i2 < edgesOut.numObjs) {
                double newDist;
                Edge edge = (Edge)edgesOut.objs[i2];
                int toNode = network.getNodeIndex(((Edge)edgesOut.objs[i2]).getOtherNode(node));
                if (result[toNode] > (newDist = dist + computer.getWeight(edge))) {
                    heap.add(network.allNodes.objs[toNode], newDist);
                }
                ++i2;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double getClusteringCoefficient(Network network) {
        double clusteringCoefficient = 0.0;
        int N = NetworkStatistics.getNumberNodes(network);
        boolean[] allFalse = new boolean[N];
        HashSet<Object> neighbors = new HashSet<Object>();
        int i = 0;
        while (i < N) {
            neighbors.clear();
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            int j = 0;
            while (j < edgesOut.numObjs) {
                Object toNode = ((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]);
                if (!toNode.equals(network.allNodes.objs[i])) {
                    neighbors.add(toNode);
                }
                ++j;
            }
            int pairs = 0;
            for (Object e : neighbors) {
                Bag edgesOutOfNeigh = network.getEdgesOut(e);
                int j2 = 0;
                while (j2 < edgesOutOfNeigh.numObjs) {
                    Object toNode = ((Edge)edgesOutOfNeigh.objs[j2]).getOtherNode(e);
                    if (!toNode.equals(network.allNodes.objs[i]) && !toNode.equals(e) && neighbors.contains(toNode)) {
                        ++pairs;
                    }
                    ++j2;
                }
            }
            if (edgesOut.numObjs >= 2) {
                clusteringCoefficient += (double)pairs / (double)(edgesOut.numObjs * (edgesOut.numObjs - 1));
            }
            ++i;
        }
        return clusteringCoefficient / (double)N;
    }

    public static boolean isMultigraphNetwork(Network network) {
        HashSet<Object> hashSet = new HashSet<Object>();
        int i = 0;
        while (i < network.allNodes.numObjs) {
            hashSet.clear();
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            int j = 0;
            while (j < edgesOut.numObjs) {
                Object toNode = ((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]);
                if (hashSet.contains(toNode)) {
                    return true;
                }
                hashSet.add(toNode);
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean getHasSelfLoops(Network network) {
        int i = 0;
        while (i < network.allNodes.numObjs) {
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            int j = 0;
            while (j < edgesOut.numObjs) {
                Object toNode = ((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]);
                if (network.allNodes.objs[i].equals(((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static double getSymmetryCoefficient(Network network) {
        if (!network.isDirected()) {
            return 1.0;
        }
        int totalNumberEdges = 0;
        int symmetricEdges = 0;
        HashSet<Object> hashSet = new HashSet<Object>();
        int i = 0;
        while (i < network.allNodes.numObjs) {
            hashSet.clear();
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            int j = 0;
            while (j < edgesOut.numObjs) {
                hashSet.add(((Edge)edgesOut.objs[j]).to());
                ++j;
            }
            Bag edgesIn = network.getEdgesIn(network.allNodes.objs[i]);
            int j2 = 0;
            while (j2 < edgesIn.numObjs) {
                if (hashSet.contains(((Edge)edgesIn.objs[j2]).to())) {
                    ++symmetricEdges;
                }
                ++j2;
            }
            totalNumberEdges += edgesIn.numObjs;
            ++i;
        }
        if (totalNumberEdges > 0) {
            return (double)symmetricEdges / (double)totalNumberEdges;
        }
        return 1.0;
    }

    public static double[][] getShortestPathsMatrix(Network network, EdgeMetric computer) {
        int numNodes = NetworkStatistics.getNumberNodes(network);
        int numEdges = NetworkStatistics.getNumberActualEdges(network);
        if ((double)numEdges > (double)numNodes * Math.sqrt(numNodes)) {
            return NetworkStatistics.floydWarshallShortestPathsMatrix(network, computer);
        }
        return NetworkStatistics.johnsonShortestPathsMatrix(network, computer);
    }

    public static double[][] floydWarshallShortestPathsMatrix(Network network, EdgeMetric computer) {
        int j;
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        int i = 0;
        while (i < N) {
            int j2 = 0;
            while (j2 < N) {
                result[i][j2] = Double.POSITIVE_INFINITY;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            Bag bag = network.getEdgesOut(network.allNodes.objs[i]);
            j = 0;
            while (j < bag.numObjs) {
                Edge edge = (Edge)bag.objs[j];
                result[i][network.getNodeIndex((Object)edge.getOtherNode((Object)network.allNodes.objs[i]))] = computer.getWeight(edge);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            result[i][i] = 0.0;
            ++i;
        }
        int k = 0;
        while (k < N) {
            int i2 = 0;
            while (i2 < N) {
                j = 0;
                while (j < N) {
                    if (result[i2][j] > result[i2][k] + result[k][j]) {
                        result[i2][j] = result[i2][k] + result[k][j];
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        return result;
    }

    public static double[][] johnsonShortestPathsMatrix(Network network, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        DoubleHeap heap = new DoubleHeap();
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < result.length) {
                result[i][j] = Double.POSITIVE_INFINITY;
                ++j;
            }
            heap.clear();
            heap.add(network.allNodes.objs[i], 0.0);
            while (!heap.isEmpty()) {
                double dist = heap.getMinKey();
                Object node = heap.extractMin();
                int nodeIndex = network.getNodeIndex(node);
                if (result[i][nodeIndex] > -1.0 && result[i][nodeIndex] <= dist) continue;
                result[i][nodeIndex] = dist;
                Bag edgesOut = network.getEdgesOut(node);
                int j2 = 0;
                while (j2 < edgesOut.numObjs) {
                    double newDist;
                    Edge edge = (Edge)edgesOut.objs[j2];
                    int toNode = network.getNodeIndex(((Edge)edgesOut.objs[j2]).getOtherNode(node));
                    if (result[i][toNode] > (newDist = dist + computer.getWeight(edge))) {
                        heap.add(network.allNodes.objs[toNode], newDist);
                    }
                    ++j2;
                }
            }
            result[i][i] = 0.0;
            ++i;
        }
        return result;
    }

    public static double getMeanShortestPath(Network network, EdgeMetric computer) {
        try {
            double result = 0.0;
            double[][] paths = NetworkStatistics.getShortestPathsMatrix(network, computer);
            int N = paths.length;
            int i = 0;
            while (i < N) {
                int j = 0;
                while (j < N) {
                    if (i != j) {
                        result += paths[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            return result / (double)(N * (N - 1));
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("You ran out of memory!  getMeanShortestPath(...) has large memory requirements and may not be appropriate for big networks.  You should try getLargeNetworkMeanShortestPath(...) instead.", e);
        }
    }

    public static double getLargeNetworkMeanShortestPath(Network network, EdgeMetric computer) {
        double result = 0.0;
        Bag nodes = network.getAllNodes();
        int N = nodes.numObjs;
        if (!network.isDirected()) {
            int i = 0;
            while (i < N - 1) {
                Object node = nodes.get(i);
                double[] paths = NetworkStatistics.getShortestPaths(network, node, computer);
                int j = i + 1;
                while (j < N) {
                    result += paths[j];
                    ++j;
                }
                ++i;
            }
            return result / ((double)(N * (N - 1)) / 2.0);
        }
        int i = 0;
        while (i < N) {
            Object node = nodes.get(i);
            double[] paths = NetworkStatistics.getShortestPaths(network, node, computer);
            int j = 0;
            while (j < N) {
                if (i != j) {
                    result += paths[j];
                }
                ++j;
            }
            ++i;
        }
        return result / (double)(N * (N - 1));
    }

    public static double getNodeEccentricity(Network network, Object node, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0) {
            return 0.0;
        }
        double[] dist = NetworkStatistics.getShortestPaths(network, node, computer);
        double max = dist[0];
        int i = 1;
        while (i < dist.length) {
            if (max < dist[i]) {
                max = dist[i];
            }
            ++i;
        }
        return max;
    }

    public static double getRadius(Network network, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0 || N == 1) {
            return 0.0;
        }
        double min = Double.POSITIVE_INFINITY;
        int nn = 0;
        while (nn < N) {
            double dist = NetworkStatistics.getNodeEccentricity(network, network.allNodes.objs[nn], computer);
            if (min > dist) {
                min = dist;
            }
            ++nn;
        }
        return min;
    }

    public static double getDiameter(Network network, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0 || N == 1) {
            return 0.0;
        }
        double max = -1.0;
        int nn = 0;
        while (nn < N) {
            double dist = NetworkStatistics.getNodeEccentricity(network, network.allNodes.objs[nn], computer);
            if (max < dist) {
                max = dist;
            }
            ++nn;
        }
        return max;
    }

    public static long[][] johnsonNumberShortestPathsMatrix(Network network, EdgeMetric computer, double precision) {
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        long[][] number = new long[N][N];
        DoubleHeap heap = new DoubleHeap();
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < N) {
                result[i][j] = Double.POSITIVE_INFINITY;
                number[i][j] = 0L;
                ++j;
            }
            heap.clear();
            heap.add(new Pair(network.allNodes.objs[i], -1), 0.0);
            while (!heap.isEmpty()) {
                boolean shouldExpand = true;
                double dist = heap.getMinKey();
                Pair node = (Pair)heap.extractMin();
                int nodeIndex = network.getNodeIndex(node.object);
                if (result[i][nodeIndex] < dist - precision) continue;
                if (result[i][nodeIndex] > dist + precision) {
                    result[i][nodeIndex] = dist;
                    number[i][nodeIndex] = node.index < 0 ? 1L : number[i][node.index];
                } else {
                    if (node.index < 0) {
                        long[] lArray = number[i];
                        int n = nodeIndex;
                        lArray[n] = lArray[n] + 1L;
                    } else {
                        long[] lArray = number[i];
                        int n = nodeIndex;
                        lArray[n] = lArray[n] + number[i][node.index];
                    }
                    shouldExpand = false;
                }
                if (!shouldExpand) continue;
                Bag edgesOut = network.getEdgesOut(node.object);
                int j2 = 0;
                while (j2 < edgesOut.numObjs) {
                    double newDist;
                    Edge edge = (Edge)edgesOut.objs[j2];
                    int toNode = network.getNodeIndex(((Edge)edgesOut.objs[j2]).getOtherNode(node.object));
                    if (result[i][toNode] >= (newDist = dist + computer.getWeight(edge)) + precision) {
                        heap.add(new Pair(network.allNodes.objs[toNode], nodeIndex), newDist);
                    }
                    ++j2;
                }
            }
            result[i][i] = 0.0;
            ++i;
        }
        return number;
    }

    public static long[][] floydWarshallNumberShortestPathsMatrix(Network network, EdgeMetric computer, double precision) {
        int j;
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        long[][] number = new long[N][N];
        int i = 0;
        while (i < N) {
            int j2 = 0;
            while (j2 < N) {
                result[i][j2] = Double.POSITIVE_INFINITY;
                number[i][j2] = 0L;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            Bag bag = network.getEdgesOut(network.allNodes.objs[i]);
            j = 0;
            while (j < bag.numObjs) {
                Edge edge = (Edge)bag.objs[j];
                int k = network.getNodeIndex(edge.getOtherNode(network.allNodes.objs[i]));
                result[i][k] = computer.getWeight(edge);
                long[] lArray = number[i];
                int n = k;
                lArray[n] = lArray[n] + 1L;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            result[i][i] = 0.0;
            ++i;
        }
        int k = 0;
        while (k < N) {
            int i2 = 0;
            while (i2 < N) {
                j = 0;
                while (j < N) {
                    if (result[i2][j] > result[i2][k] + result[k][j] + precision) {
                        result[i2][j] = result[i2][k] + result[k][j];
                        number[i2][j] = number[i2][k] * number[k][j];
                    } else if (NetworkStatistics.abs(result[i2][j] - (result[i2][k] + result[k][j])) <= precision) {
                        long[] lArray = number[i2];
                        int n = j;
                        lArray[n] = lArray[n] + number[i2][k] * number[k][j];
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        return number;
    }

    public static long[][][] floydWarshallNumberShortestPathsWithIntermediatesMatrix(Network network, EdgeMetric computer, double precision) {
        int j;
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        long[][] number = new long[N][N];
        int i = 0;
        while (i < N) {
            int j2 = 0;
            while (j2 < N) {
                result[i][j2] = Double.POSITIVE_INFINITY;
                number[i][j2] = 0L;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            Bag bag = network.getEdgesOut(network.allNodes.objs[i]);
            j = 0;
            while (j < bag.numObjs) {
                Edge edge = (Edge)bag.objs[j];
                int k = network.getNodeIndex(edge.getOtherNode(network.allNodes.objs[i]));
                result[i][k] = computer.getWeight(edge);
                long[] lArray = number[i];
                int n = k;
                lArray[n] = lArray[n] + 1L;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            result[i][i] = 0.0;
            ++i;
        }
        int k = 0;
        while (k < N) {
            int i2 = 0;
            while (i2 < N) {
                j = 0;
                while (j < N) {
                    if (result[i2][j] > result[i2][k] + result[k][j] + precision) {
                        result[i2][j] = result[i2][k] + result[k][j];
                        number[i2][j] = number[i2][k] * number[k][j];
                    } else if (NetworkStatistics.abs(result[i2][j] - (result[i2][k] + result[k][j])) <= precision) {
                        long[] lArray = number[i2];
                        int n = j;
                        lArray[n] = lArray[n] + number[i2][k] * number[k][j];
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        long[][][] theResult = new long[N][N][N];
        int i3 = 0;
        while (i3 < N) {
            j = 0;
            while (j < N) {
                int k2 = 0;
                while (k2 < N) {
                    theResult[i3][j][k2] = NetworkStatistics.abs(result[i3][j] + result[j][k2] - result[i3][k2]) <= precision ? number[i3][j] * number[j][k2] : 0L;
                    ++k2;
                }
                ++j;
            }
            ++i3;
        }
        return theResult;
    }

    public static long[][] getNumberShortestPathsMatrix(Network network, EdgeMetric computer, double precision) {
        int numNodes = NetworkStatistics.getNumberNodes(network);
        int numEdges = NetworkStatistics.getNumberActualEdges(network);
        if ((double)numEdges > (double)numNodes * Math.sqrt(numNodes)) {
            return NetworkStatistics.floydWarshallNumberShortestPathsMatrix(network, computer, precision);
        }
        return NetworkStatistics.johnsonNumberShortestPathsMatrix(network, computer, precision);
    }

    public static long[][][] getNumberShortestPathsWithIntermediatesMatrix(Network network, EdgeMetric computer, double precision) {
        return NetworkStatistics.floydWarshallNumberShortestPathsWithIntermediatesMatrix(network, computer, precision);
    }

    static final double abs(double x) {
        return x > 0.0 ? x : -x;
    }

    static class Pair {
        Object object;
        int index;

        public Pair(Object o, int i) {
            this.object = o;
            this.index = i;
        }
    }
}

