/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import java.util.Iterator;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.EdgeMetric;
import sim.field.network.stats.actorcentrality.NodeIndex;
import sim.util.mantissa.linalg.GeneralSquareMatrix;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;

public class InformationCentrality
extends NodeIndex {
    final double normalizationDenominator;
    final double[] ci;

    public InformationCentrality(Network network, EdgeMetric weightFn) {
        super(network);
        int n = network.allNodes.numObjs;
        int[] indirect = new int[n];
        int i = 0;
        while (i < n) {
            indirect[i] = i;
            ++i;
        }
        int isolated = 0;
        Iterator nodeIO = network.indexOutInHash.values().iterator();
        int k = 0;
        while (k < n) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)nodeIO.next();
            int index = ioi.index;
            if (ioi.out == null) {
                indirect[n - ++isolated] = indirect[index];
                indirect[index] = n - isolated;
            }
            ++k;
        }
        int nonIsolatedN = n - isolated;
        GeneralSquareMatrix a = new GeneralSquareMatrix(nonIsolatedN);
        int i2 = 0;
        while (i2 < nonIsolatedN) {
            int j = 0;
            while (j < nonIsolatedN) {
                a.setElement(i2, j, 1.0);
                ++j;
            }
            ++i2;
        }
        nodeIO = network.indexOutInHash.values().iterator();
        int k2 = 0;
        while (k2 < n) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)nodeIO.next();
            int index = ioi.index;
            if (ioi.out != null) {
                int outDegree = ioi.out.numObjs;
                int indirectIndex = indirect[index];
                Object nodeObj = network.allNodes.objs[ioi.index];
                int i3 = 0;
                while (i3 < outDegree) {
                    Edge e = (Edge)ioi.out.objs[i3];
                    int j = ((Network.IndexOutIn)network.indexOutInHash.get((Object)e.getOtherNode((Object)nodeObj))).index;
                    a.setElement(indirectIndex, indirect[j], 1.0 - weightFn.getWeight(e));
                    ++i3;
                }
                a.setElement(indirectIndex, indirectIndex, 1 + outDegree);
            }
            ++k2;
        }
        double R = 0.0;
        double T = 0.0;
        this.ci = new double[n];
        try {
            SquareMatrix c = a.getInverse(0.0);
            int i4 = 0;
            while (i4 < nonIsolatedN) {
                T += c.getElement(i4, i4);
                R += c.getElement(0, i4);
                ++i4;
            }
            i4 = 0;
            while (i4 < n) {
                int indirectI = indirect[i4];
                this.ci[i4] = indirectI >= nonIsolatedN ? Double.POSITIVE_INFINITY : c.getElement(indirectI, indirectI);
                ++i4;
            }
        }
        catch (SingularMatrixException ex) {
            throw new RuntimeException("Singular Matrix");
        }
        double k3 = (T - 2.0 * R) / (double)nonIsolatedN;
        double sum = 0.0;
        int i5 = 0;
        while (i5 < n) {
            this.ci[i5] = 1.0 / (this.ci[i5] + k3);
            sum += this.ci[i5];
            ++i5;
        }
        this.normalizationDenominator = sum;
    }

    @Override
    public double getValue(Object node) {
        return this.ci[this.network.getNodeIndex(node)];
    }

    @Override
    public double getValue(int nodeIndex) {
        return this.ci[nodeIndex];
    }

    @Override
    public double getMaxValue() {
        return this.normalizationDenominator;
    }
}

