/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.EdgeMetric;
import sim.field.network.stats.actorcentrality.NodeIndex;
import sim.util.mantissa.linalg.GeneralSquareMatrix;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;

public class PowerPrestige
extends NodeIndex {
    final double[] prestige;
    final double scalingDenominator;

    public PowerPrestige(Network network, EdgeMetric metric) {
        this(network, 1.0, metric);
    }

    public PowerPrestige(Network network, double beta, EdgeMetric metric) {
        super(network);
        int n = network.allNodes.numObjs;
        this.prestige = new double[n];
        Edge[][] adjM = network.getAdjacencyMatrix();
        GeneralSquareMatrix I_bR = new GeneralSquareMatrix(n);
        double[] Rsum = new double[n];
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            Edge[] adjMi = adjM[i];
            int j = 0;
            while (j < n) {
                Edge e = adjMi[j];
                double val = e == null ? 0.0 : metric.getWeight(e);
                sum += val;
                I_bR.setElement(i, j, (double)(i == j ? 1 : 0) - beta * val);
                ++j;
            }
            Rsum[i] = sum;
            ++i;
        }
        try {
            SquareMatrix I_bR_1 = I_bR.getInverse(0.0);
            double sumsq = 0.0;
            int i2 = 0;
            while (i2 < n) {
                double sum = 0.0;
                int k = 0;
                while (k < n) {
                    sum += I_bR_1.getElement(i2, k) * Rsum[k];
                    ++k;
                }
                this.prestige[i2] = sum;
                sumsq += sum * sum;
                ++i2;
            }
            this.scalingDenominator = Math.sqrt(sumsq / (double)n);
        }
        catch (SingularMatrixException ex) {
            throw new RuntimeException("Singular Matrix");
        }
    }

    @Override
    public double getValue(Object node) {
        Network.IndexOutIn inout = (Network.IndexOutIn)this.network.indexOutInHash.get(node);
        return this.prestige[inout.index];
    }

    @Override
    public double getValue(int nodeIndex) {
        return this.prestige[nodeIndex];
    }

    @Override
    public double getMaxValue() {
        return this.scalingDenominator;
    }
}

