/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import sim.field.network.Network;
import sim.field.network.stats.NetworkStatistics;
import sim.field.network.stats.UnitEdgeMetric;
import sim.field.network.stats.actorcentrality.NodeIndex;

public class ProximityPrestige
extends NodeIndex {
    final double[][] allDistances;

    public ProximityPrestige(Network network) {
        super(network);
        this.allDistances = NetworkStatistics.getShortestPathsMatrix(network, UnitEdgeMetric.defaultInstance);
    }

    @Override
    public double getValue(Object node) {
        int i = this.network.getNodeIndex(node);
        int Ii = 0;
        double sum = 0.0;
        int n = this.network.allNodes.numObjs;
        int j = 0;
        while (j < n) {
            double dji = this.allDistances[j][i];
            if (dji != Double.POSITIVE_INFINITY) {
                ++Ii;
            }
            sum += dji;
            ++j;
        }
        return (double)(Ii * Ii) / sum / (double)(n - 1);
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }
}

