/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;

public class DoubleHeap
implements Serializable {
    double[] keys = null;
    Object[] objects = null;
    int numElem = 0;

    public DoubleHeap() {
        this(new double[0], new Object[0], 0);
    }

    public DoubleHeap(double[] keys, Object[] objects, int numElem) {
        if (keys.length != objects.length) {
            throw new IllegalArgumentException("keys and objects must be of the same length");
        }
        this.keys = keys;
        this.objects = objects;
        this.numElem = numElem;
        this.buildHeap();
    }

    void buildHeap() {
        int i = this.numElem / 2;
        while (i >= 1) {
            this.heapify(i, this.numElem);
            --i;
        }
    }

    void heapify(int i, int heapsize) {
        Object[] objects = this.objects;
        double[] keys = this.keys;
        while (true) {
            int l = 2 * i;
            int r = 2 * i + 1;
            int smallest = l <= heapsize && keys[l - 1] < keys[i - 1] ? l : i;
            if (r <= heapsize && keys[r - 1] < keys[smallest - 1]) {
                smallest = r;
            }
            if (smallest == i) break;
            double tempkey = keys[i - 1];
            keys[i - 1] = keys[smallest - 1];
            keys[smallest - 1] = tempkey;
            Object temp = objects[i - 1];
            objects[i - 1] = objects[smallest - 1];
            objects[smallest - 1] = temp;
            i = smallest;
        }
    }

    public double getMinKey() {
        return this.keys[0];
    }

    public Object extractMin() {
        int numElem = this.numElem;
        Object[] objects = this.objects;
        double[] keys = this.keys;
        if (numElem == 0) {
            return null;
        }
        keys[0] = keys[numElem - 1];
        keys[numElem - 1] = 0.0;
        Object result = objects[0];
        objects[0] = objects[numElem - 1];
        objects[numElem - 1] = null;
        this.heapify(1, --numElem);
        this.numElem = numElem;
        return result;
    }

    public void add(Object elem, double key) {
        int numElem = this.numElem;
        Object[] objects = this.objects;
        double[] keys = this.keys;
        if (++numElem - 1 >= objects.length) {
            Object[] temp = new Object[objects.length * 2 + 1];
            System.arraycopy(objects, 0, temp, 0, objects.length);
            objects = temp;
            double[] temptemp = new double[keys.length * 2 + 1];
            System.arraycopy(keys, 0, temptemp, 0, keys.length);
            keys = temptemp;
            this.objects = objects;
            this.keys = keys;
        }
        int i = numElem;
        while (i > 1 && keys[i / 2 - 1] > key) {
            objects[i - 1] = objects[i / 2 - 1];
            keys[i - 1] = keys[i / 2 - 1];
            i /= 2;
        }
        keys[i - 1] = key;
        objects[i - 1] = elem;
        this.numElem = numElem;
    }

    public boolean isEmpty() {
        return this.numElem == 0;
    }

    public void clear() {
        this.numElem = 0;
    }
}

