/*
 * Decompiled with CFR 0.152.
 */
package sim.util.mantissa.linalg;

import java.io.Serializable;
import sim.util.mantissa.linalg.Matrix;
import sim.util.mantissa.linalg.NonNullRange;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;

public class DiagonalMatrix
extends SquareMatrix
implements Serializable,
Cloneable {
    public DiagonalMatrix(int order) {
        this(order, 1.0);
    }

    public DiagonalMatrix(int order, double value) {
        super(order);
        int index = 0;
        while (index < order * order) {
            this.data[index] = value;
            index += order + 1;
        }
    }

    public DiagonalMatrix(int order, double[] data) {
        super(order, data);
    }

    public DiagonalMatrix(DiagonalMatrix d) {
        super(d);
    }

    @Override
    public Matrix duplicate() {
        return new DiagonalMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        if (i != j) {
            throw new ArrayIndexOutOfBoundsException("cannot set elements out of diagonal in a diagonal matrix");
        }
        super.setElement(i, j, value);
    }

    @Override
    public double getDeterminant(double epsilon) {
        double determinant = this.data[0];
        int index = this.columns + 1;
        while (index < this.columns * this.columns) {
            determinant *= this.data[index];
            index += this.columns + 1;
        }
        return determinant;
    }

    @Override
    public SquareMatrix getInverse(double epsilon) throws SingularMatrixException {
        DiagonalMatrix inv = new DiagonalMatrix(this.columns);
        int index = 0;
        while (index < this.columns * this.columns) {
            if (Math.abs(this.data[index]) < epsilon) {
                throw new SingularMatrixException();
            }
            inv.data[index] = 1.0 / this.data[index];
            index += this.columns + 1;
        }
        return inv;
    }

    @Override
    public Matrix solve(Matrix b, double epsilon) throws SingularMatrixException {
        Matrix result = b.duplicate();
        int i = 0;
        while (i < this.columns) {
            double diag = this.data[i * (this.columns + 1)];
            if (Math.abs(diag) < epsilon) {
                throw new SingularMatrixException();
            }
            double inv = 1.0 / diag;
            NonNullRange range = result.getRangeForRow(i);
            int index = i * b.columns + range.begin;
            while (index < i * b.columns + range.end) {
                result.data[index] = inv * b.data[index];
                ++index;
            }
            ++i;
        }
        return result;
    }

    @Override
    public NonNullRange getRangeForRow(int i) {
        return new NonNullRange(i, i + 1);
    }

    @Override
    public NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(j, j + 1);
    }
}

