/*
 * Decompiled with CFR 0.152.
 */
package sim.util.mantissa.linalg;

import java.io.Serializable;
import sim.util.mantissa.linalg.LowerTriangularMatrix;
import sim.util.mantissa.linalg.Matrix;
import sim.util.mantissa.linalg.MatrixFactory;
import sim.util.mantissa.linalg.NonNullRange;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;
import sim.util.mantissa.linalg.UpperTriangularMatrix;

public class GeneralSquareMatrix
extends SquareMatrix
implements Serializable,
Cloneable {
    private int[] permutations;
    private boolean evenPermutations;
    private LowerTriangularMatrix lower;
    private UpperTriangularMatrix upper;

    public GeneralSquareMatrix(int order) {
        super(order);
        this.permutations = null;
        this.evenPermutations = true;
        this.lower = null;
        this.upper = null;
    }

    public GeneralSquareMatrix(int order, double[] data) {
        super(order, data);
        this.permutations = null;
        this.evenPermutations = true;
        this.lower = null;
        this.upper = null;
    }

    public GeneralSquareMatrix(GeneralSquareMatrix s) {
        super(s);
        if (s.permutations != null) {
            this.permutations = (int[])s.permutations.clone();
            this.evenPermutations = s.evenPermutations;
            this.lower = new LowerTriangularMatrix(s.lower);
            this.upper = new UpperTriangularMatrix(s.upper);
        } else {
            this.permutations = null;
            this.evenPermutations = true;
            this.lower = null;
            this.upper = null;
        }
    }

    @Override
    public Matrix duplicate() {
        return new GeneralSquareMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        super.setElement(i, j, value);
        this.permutations = null;
        this.evenPermutations = true;
        this.lower = null;
        this.upper = null;
    }

    public void selfAdd(SquareMatrix s) {
        if (this.rows != s.rows || this.columns != s.columns) {
            throw new IllegalArgumentException("cannot add a " + s.rows + 'x' + s.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        int index = 0;
        while (index < this.rows * this.columns) {
            int n = index;
            this.data[n] = this.data[n] + s.data[index];
            ++index;
        }
    }

    public void selfSub(SquareMatrix s) {
        if (this.rows != s.rows || this.columns != s.columns) {
            throw new IllegalArgumentException("cannot substract a " + s.rows + 'x' + s.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        int index = 0;
        while (index < this.rows * this.columns) {
            int n = index;
            this.data[n] = this.data[n] - s.data[index];
            ++index;
        }
    }

    @Override
    public double getDeterminant(double epsilon) {
        try {
            if (this.permutations == null) {
                this.computeLUFactorization(epsilon);
            }
            double d = this.upper.getDeterminant(epsilon);
            return this.evenPermutations ? d : -d;
        }
        catch (SingularMatrixException e) {
            return 0.0;
        }
    }

    @Override
    public Matrix solve(Matrix b, double epsilon) throws SingularMatrixException {
        if (b.getRows() != this.rows) {
            throw new IllegalArgumentException("dimension mismatch");
        }
        if (this.permutations == null) {
            this.computeLUFactorization(epsilon);
        }
        double[] permData = new double[b.data.length];
        int bCols = b.getColumns();
        int i = 0;
        while (i < this.rows) {
            NonNullRange range = b.getRangeForRow(this.permutations[i]);
            int j = range.begin;
            while (j < range.end) {
                permData[i * bCols + j] = b.data[this.permutations[i] * bCols + j];
                ++j;
            }
            ++i;
        }
        Matrix permB = MatrixFactory.buildMatrix(b.getRows(), bCols, permData);
        return this.upper.solve(this.lower.solve(permB, epsilon), epsilon);
    }

    @Override
    protected NonNullRange getRangeForRow(int i) {
        return new NonNullRange(0, this.columns);
    }

    @Override
    protected NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(0, this.rows);
    }

    private void computeLUFactorization(double epsilon) throws SingularMatrixException {
        double[] work = new double[this.rows * this.columns];
        int index = 0;
        while (index < work.length) {
            work[index] = this.data[index];
            ++index;
        }
        this.permutations = new int[this.rows];
        int i = 0;
        while (i < this.rows) {
            this.permutations[i] = i;
            ++i;
        }
        this.evenPermutations = true;
        int k = 0;
        while (k < this.rows) {
            double maxElt = Math.abs(work[this.permutations[k] * this.columns + k]);
            int jMax = k;
            int i2 = k + 1;
            while (i2 < this.rows) {
                double curElt = Math.abs(work[this.permutations[i2] * this.columns + k]);
                if (curElt > maxElt) {
                    maxElt = curElt;
                    jMax = i2;
                }
                ++i2;
            }
            if (maxElt < epsilon) {
                throw new SingularMatrixException();
            }
            if (k != jMax) {
                int tmp = this.permutations[k];
                this.permutations[k] = this.permutations[jMax];
                this.permutations[jMax] = tmp;
                this.evenPermutations = !this.evenPermutations;
            }
            double inv = 1.0 / work[this.permutations[k] * this.columns + k];
            int i3 = k + 1;
            while (i3 < this.rows) {
                double factor;
                work[this.permutations[i3] * this.columns + k] = factor = inv * work[this.permutations[i3] * this.columns + k];
                int index1 = this.permutations[i3] * this.columns + k;
                int index2 = this.permutations[k] * this.columns + k;
                int j = k + 1;
                while (j < this.columns) {
                    int n = ++index1;
                    work[n] = work[n] - factor * work[++index2];
                    ++j;
                }
                ++i3;
            }
            ++k;
        }
        double[] lowerData = new double[this.rows * this.columns];
        double[] upperData = new double[this.rows * this.columns];
        int index2 = 0;
        int i4 = 0;
        while (i4 < this.rows) {
            int workIndex = this.permutations[i4] * this.columns;
            int j = 0;
            while (j++ < i4) {
                lowerData[index2] = work[workIndex++];
                upperData[index2++] = 0.0;
            }
            lowerData[index2] = 1.0;
            upperData[index2++] = work[workIndex++];
            while (j++ < this.columns) {
                lowerData[index2] = 0.0;
                upperData[index2++] = work[workIndex++];
            }
            ++i4;
        }
        work = null;
        this.lower = new LowerTriangularMatrix(this.rows, lowerData);
        this.upper = new UpperTriangularMatrix(this.rows, upperData);
    }
}

