/*
 * Decompiled with CFR 0.152.
 */
package sim.util.mantissa.linalg;

import sim.util.mantissa.linalg.DiagonalMatrix;
import sim.util.mantissa.linalg.GeneralMatrix;
import sim.util.mantissa.linalg.GeneralSquareMatrix;
import sim.util.mantissa.linalg.LowerTriangularMatrix;
import sim.util.mantissa.linalg.Matrix;
import sim.util.mantissa.linalg.UpperTriangularMatrix;

public class MatrixFactory {
    private MatrixFactory() {
    }

    public static Matrix buildMatrix(int rows, int columns, double[] data, int lowerElements, int upperElements) {
        if (rows == columns) {
            if (lowerElements == 0 && upperElements == 0) {
                return new DiagonalMatrix(rows, data);
            }
            if (lowerElements == 0) {
                return new UpperTriangularMatrix(rows, data);
            }
            if (upperElements == 0) {
                return new LowerTriangularMatrix(rows, data);
            }
            return new GeneralSquareMatrix(rows, data);
        }
        return new GeneralMatrix(rows, columns, data);
    }

    public static Matrix buildMatrix(int rows, int columns, double[] data) {
        if (rows == columns) {
            return new GeneralSquareMatrix(rows, data);
        }
        return new GeneralMatrix(rows, columns, data);
    }
}

