/*
 * Decompiled with CFR 0.152.
 */
package sim.util.mantissa.linalg;

import java.io.Serializable;
import sim.util.mantissa.linalg.Matrix;
import sim.util.mantissa.linalg.MatrixFactory;
import sim.util.mantissa.linalg.NonNullRange;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;

public class UpperTriangularMatrix
extends SquareMatrix
implements Serializable,
Cloneable {
    public UpperTriangularMatrix(int order) {
        super(order);
    }

    public UpperTriangularMatrix(int order, double[] data) {
        super(order, data);
    }

    public UpperTriangularMatrix(UpperTriangularMatrix u) {
        super(u);
    }

    @Override
    public Matrix duplicate() {
        return new UpperTriangularMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        if (i > j) {
            throw new ArrayIndexOutOfBoundsException("cannot set elements below diagonal of a upper triangular matrix");
        }
        super.setElement(i, j, value);
    }

    public void selfAdd(UpperTriangularMatrix u) {
        if (this.rows != u.rows || this.columns != u.columns) {
            throw new IllegalArgumentException("cannot add a " + u.rows + 'x' + u.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        int i = 0;
        while (i < this.rows) {
            int index = i * (this.columns + 1);
            while (index < (i + 1) * this.columns) {
                int n = index;
                this.data[n] = this.data[n] + u.data[index];
                ++index;
            }
            ++i;
        }
    }

    public void selfSub(UpperTriangularMatrix u) {
        if (this.rows != u.rows || this.columns != u.columns) {
            throw new IllegalArgumentException("cannot substract a " + u.rows + 'x' + u.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        int i = 0;
        while (i < this.rows) {
            int index = i * (this.columns + 1);
            while (index < (i + 1) * this.columns) {
                int n = index;
                this.data[n] = this.data[n] - u.data[index];
                ++index;
            }
            ++i;
        }
    }

    @Override
    public double getDeterminant(double epsilon) {
        double determinant = this.data[0];
        int index = this.columns + 1;
        while (index < this.columns * this.columns) {
            determinant *= this.data[index];
            index += this.columns + 1;
        }
        return determinant;
    }

    @Override
    public Matrix solve(Matrix b, double epsilon) throws SingularMatrixException {
        if (b.getRows() != this.rows) {
            throw new IllegalArgumentException("dimension mismatch");
        }
        int bRows = b.getRows();
        int bCols = b.getColumns();
        double[] resultData = new double[bRows * bCols];
        int resultIndex = bRows * bCols - 1;
        int lowerElements = 0;
        int upperElements = 0;
        int minJ = this.columns;
        int maxJ = 0;
        int i = this.rows - 1;
        while (i >= 0) {
            double diag = this.data[i * (this.columns + 1)];
            if (Math.abs(diag) < epsilon) {
                throw new SingularMatrixException();
            }
            double inv = 1.0 / diag;
            NonNullRange range = b.getRangeForRow(i);
            minJ = Math.min(minJ, range.begin);
            maxJ = Math.max(maxJ, range.end);
            int j = bCols - 1;
            while (j >= maxJ) {
                resultData[resultIndex] = 0.0;
                --resultIndex;
                --j;
            }
            int bIndex = i * bCols + maxJ - 1;
            while (j >= minJ) {
                int index1 = (i + 1) * this.columns - 1;
                int index2 = (bRows - 1) * bCols + j;
                double value = b.data[bIndex];
                while (index1 >= i * (this.columns + 1)) {
                    value -= this.data[index1] * resultData[index2];
                    --index1;
                    index2 -= bCols;
                }
                resultData[resultIndex] = value *= inv;
                if (j < i) {
                    ++lowerElements;
                } else if (i < j) {
                    ++upperElements;
                }
                --bIndex;
                --resultIndex;
                --j;
            }
            while (j >= 0) {
                resultData[resultIndex] = 0.0;
                --resultIndex;
                --j;
            }
            --i;
        }
        return MatrixFactory.buildMatrix(bRows, bCols, resultData, lowerElements, upperElements);
    }

    @Override
    public NonNullRange getRangeForRow(int i) {
        return new NonNullRange(i, this.columns);
    }

    @Override
    public NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(0, j + 1);
    }
}

