/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.csv4j.CSVParser;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVTokenizer
implements Tokenizer<String>,
Enumeration<String>,
Iterator<String>,
Iterable<String> {
    private final List<String> tokens;
    private int iterIndex = 0;

    public CSVTokenizer(String line) throws ParseException {
        this.tokens = new CSVParser().tokenize(line);
    }

    @Override
    public String nextToken() {
        if (this.iterIndex >= this.tokens.size()) {
            throw new NoSuchElementException();
        }
        return this.tokens.get(this.iterIndex++);
    }

    @Override
    public boolean hasMoreTokens() {
        return this.iterIndex < this.tokens.size();
    }

    @Override
    public int countTokens() {
        return this.tokens.size() - this.iterIndex;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public String nextElement() {
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    @Override
    public String next() {
        return this.nextToken();
    }

    @Override
    public void remove() {
        throw new RuntimeException("not supported");
    }

    public void reset() {
        this.iterIndex = 0;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

