/*
 * Decompiled with CFR 0.152.
 */
package swise.agents;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import java.util.ArrayList;
import java.util.HashMap;
import sim.field.geo.GeomVectorField;
import sim.field.network.Edge;
import sim.util.geo.MasonGeometry;
import sim.util.geo.PointMoveTo;
import swise.agents.SpatialAgent;
import swise.objects.AStar;
import swise.objects.network.GeoNode;

public class MobileAgent
extends SpatialAgent {
    protected GeoNode node;
    protected Coordinate goalPoint = null;
    protected Coordinate startPoint = null;
    protected AStar pathfinder = new AStar();
    protected int direction = 1;
    protected Edge edge;
    protected LengthIndexedLine segment = null;
    protected double startIndex = 0.0;
    protected double endIndex = 0.0;
    protected double currentIndex = 0.0;
    protected ArrayList<Edge> path = null;
    protected double speed = 0.0;
    protected double size = 1.0;

    public MobileAgent() {
    }

    public MobileAgent(Coordinate c) {
        super(new GeometryFactory().createPoint(c));
    }

    public MobileAgent(Point p) {
        super(p);
    }

    public HashMap<String, Object> getPositionalInformation() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("node", (Object)this.node);
        results.put("direction", this.direction);
        results.put("edge", this.edge);
        results.put("segment", this.segment);
        results.put("startIndex", this.startIndex);
        results.put("endIndex", this.endIndex);
        results.put("currentIndex", this.currentIndex);
        return results;
    }

    public void setPositionalInformation(HashMap<String, Object> position) {
        this.node = (GeoNode)((Object)position.get("node"));
        this.direction = (Integer)position.get("direction");
        this.edge = (Edge)position.get("edge");
        this.segment = (LengthIndexedLine)position.get("segment");
        this.startIndex = (Double)position.get("startIndex");
        this.endIndex = (Double)position.get("endIndex");
        this.currentIndex = (Double)position.get("currentIndex");
    }

    protected double move(double time, HashMap<GeomVectorField, Double> obstacles) {
        double proposedCurrentIndex;
        if (this.arrived()) {
            if (this.path.size() > 0) {
                this.edge = this.path.remove(this.path.size() - 1);
                LineString ls = (LineString)((MasonGeometry)this.edge.info).geometry;
                this.segment = new LengthIndexedLine((Geometry)ls);
                this.startIndex = this.segment.getStartIndex();
                this.endIndex = this.segment.getEndIndex();
                if (this.node == this.edge.from()) {
                    this.direction = 1;
                    this.currentIndex = this.startIndex;
                } else {
                    this.direction = -1;
                    this.currentIndex = this.endIndex;
                }
                this.node = (GeoNode)((Object)this.edge.getOtherNode((Object)this.node));
            } else if (this.currentIndex <= this.startIndex || this.currentIndex >= this.endIndex) {
                this.path = null;
                return time;
            }
        }
        this.currentIndex = proposedCurrentIndex = this.currentIndex + time * this.speed * (double)this.direction;
        if (this.direction < 0) {
            if (this.currentIndex < this.startIndex) {
                time = (this.startIndex - this.currentIndex) / this.speed;
                this.currentIndex = this.startIndex;
            } else {
                time = 0.0;
            }
        } else if (this.currentIndex > this.endIndex) {
            time = (this.currentIndex - this.endIndex) / this.speed;
            this.currentIndex = this.endIndex;
        } else {
            time = 0.0;
        }
        this.updateLoc(this.segment.extractPoint(this.currentIndex));
        return time;
    }

    protected boolean arrived() {
        return this.direction > 0 && this.currentIndex >= this.endIndex || this.direction < 0 && this.currentIndex <= this.startIndex;
    }

    protected void updateLoc(Coordinate c) {
        PointMoveTo p = new PointMoveTo();
        p.setCoordinate(c);
        this.geometry.apply((CoordinateSequenceFilter)p);
        this.geometry.geometryChanged();
    }

    public int getDirection() {
        return this.direction;
    }

    public double getCurrentIndex() {
        return this.currentIndex;
    }
}

