/*
 * Decompiled with CFR 0.152.
 */
package swise.agents;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import sim.field.network.Edge;
import sim.util.geo.MasonGeometry;
import swise.agents.MobileAgent;
import swise.objects.network.GeoNode;
import swise.objects.network.ListEdge;

public class TrafficAgent
extends MobileAgent {
    private static final long serialVersionUID = 1L;
    public double myLastSpeed = -1.0;
    public double minSpeed = -1.0;

    public TrafficAgent() {
    }

    public TrafficAgent(Coordinate c) {
        super(new GeometryFactory().createPoint(c));
    }

    public TrafficAgent(Point p) {
        super(p);
    }

    protected double move(double time, double mySpeed, double resolution) {
        double proposedCurrentIndex;
        double speed;
        if (this.arrived()) {
            if (this.edge != null && this.edge.getClass().equals(ListEdge.class)) {
                ((ListEdge)this.edge).removeElement(this);
            }
            if (this.goalPoint == null && this.path.size() == 0 && (this.currentIndex <= this.startIndex || this.currentIndex >= this.endIndex)) {
                this.path = null;
                return time;
            }
            if (this.path.size() > 0) {
                Edge newEdge;
                this.edge = newEdge = (Edge)this.path.remove(this.path.size() - 1);
                if (((MasonGeometry)newEdge.info).getStringAttribute("open").equals("CLOSED")) {
                    this.updateLoc(this.node.geometry.getCoordinate());
                    this.edge = newEdge;
                    this.path = null;
                    return -1.0;
                }
                this.node = (GeoNode)((Object)this.edge.getOtherNode((Object)this.node));
                LineString ls = (LineString)((MasonGeometry)this.edge.info).geometry;
                this.segment = new LengthIndexedLine((Geometry)ls);
                this.startIndex = this.segment.getStartIndex();
                this.endIndex = this.segment.getEndIndex();
                this.currentIndex = this.segment.project(this.geometry.getCoordinate());
                if (this.path.size() == 0 && this.goalPoint != null) {
                    double goalIndex = this.segment.project(this.goalPoint);
                    if (this.currentIndex < goalIndex) {
                        this.endIndex = goalIndex;
                    } else {
                        this.startIndex = goalIndex;
                    }
                }
                if (this.node == this.edge.to()) {
                    this.direction = 1;
                    this.currentIndex = Math.max(this.currentIndex, this.startIndex);
                } else {
                    this.direction = -1;
                    this.currentIndex = Math.min(this.currentIndex, this.endIndex);
                }
                if (this.edge.getClass().equals(ListEdge.class)) {
                    ((ListEdge)this.edge).addElement(this);
                }
            }
        }
        if (this.edge != null && this.edge.getClass().equals(ListEdge.class)) {
            double val = Math.min(1.0, ((ListEdge)this.edge).lengthPerElement() / 20.0);
            speed = Math.max(mySpeed * val, this.minSpeed);
        } else {
            speed = mySpeed;
        }
        this.myLastSpeed = speed;
        this.currentIndex = proposedCurrentIndex = this.currentIndex + time * speed * (double)this.direction;
        if (this.direction < 0) {
            if (this.currentIndex < this.startIndex) {
                time = (this.startIndex - this.currentIndex) / speed;
                this.currentIndex = this.startIndex;
            } else {
                time = 0.0;
            }
        } else if (this.currentIndex > this.endIndex) {
            time = (this.currentIndex - this.endIndex) / speed;
            this.currentIndex = this.endIndex;
        } else {
            time = 0.0;
        }
        if (this.goalPoint != null && this.path.size() == 0) {
            double idealIndex = this.segment.indexOf(this.goalPoint);
            if (this.direction == 1 && idealIndex <= this.currentIndex || this.direction == -1 && idealIndex >= this.currentIndex) {
                this.currentIndex = idealIndex;
                time = 0.0;
                this.startIndex = this.endIndex = this.currentIndex;
            }
        }
        this.updateLoc(this.segment.extractPoint(this.currentIndex));
        if (this.path.size() == 0 && this.arrived()) {
            this.path = null;
        }
        return time;
    }

    public int navigate(double resolution) {
        if (this.path != null) {
            double time = 1.0;
            while (this.path != null && time > 0.0) {
                time = this.move(time, this.speed, resolution);
            }
            if (this.segment != null) {
                this.updateLoc(this.segment.extractPoint(this.currentIndex));
            }
            if (time < 0.0) {
                return -1;
            }
            return 1;
        }
        return -1;
    }
}

