/*
 * Decompiled with CFR 0.152.
 */
package swise.disasters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import ec.util.MersenneTwisterFast;
import java.util.ArrayList;
import java.util.HashMap;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.geo.GeomGridField;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.util.IntBag;

public class Wildfire
implements Steppable {
    public GeomGridField burning;
    GeomGridField elevation;
    GeomGridField vegetation;
    GeomGridField impermeability;
    double precision = 5.0;
    double windspeed = 1.0;
    double sqrt2 = Math.sqrt(2.0);
    public static int STATE_no_fuel = 0;
    public static int STATE_vulnerable = 1;
    public static int STATE_burning = 2;
    public static int STATE_burned = 3;
    public static HashMap<Integer, Double> veg_density = new HashMap<Integer, Double>(){
        {
            this.put(11, -0.4);
            this.put(12, -0.4);
            this.put(13, -0.4);
            this.put(14, -0.4);
            this.put(15, -0.4);
            this.put(16, -0.4);
            this.put(17, -0.4);
            this.put(21, -0.4);
            this.put(22, -0.4);
            this.put(23, -0.4);
            this.put(24, -0.4);
            this.put(31, -0.4);
            this.put(32, -0.4);
            this.put(33, -0.4);
            this.put(51, -0.4);
            this.put(52, -0.4);
            this.put(53, -0.4);
            this.put(54, -0.4);
            this.put(62, -0.4);
            this.put(71, -0.4);
            this.put(72, -0.4);
            this.put(73, -0.4);
            this.put(74, -0.4);
            this.put(75, -0.4);
            this.put(76, -0.4);
            this.put(77, -0.4);
            this.put(83, -0.4);
            this.put(84, -0.4);
            this.put(90, -0.4);
            this.put(91, -0.4);
            this.put(92, -0.4);
            this.put(93, -0.4);
            this.put(94, -0.4);
            this.put(95, -0.4);
            this.put(61, 0.0);
            this.put(81, 0.0);
            this.put(82, 0.0);
            this.put(85, 0.0);
            this.put(41, 0.3);
            this.put(42, 0.3);
            this.put(43, 0.3);
        }
    };
    public static HashMap<Integer, Double> veg_type = new HashMap<Integer, Double>(){
        {
            this.put(11, -0.3);
            this.put(12, -0.3);
            this.put(13, -0.3);
            this.put(14, -0.3);
            this.put(15, -0.3);
            this.put(16, -0.3);
            this.put(17, -0.3);
            this.put(21, -0.3);
            this.put(22, -0.3);
            this.put(23, -0.3);
            this.put(24, -0.3);
            this.put(31, -0.3);
            this.put(32, -0.3);
            this.put(33, -0.3);
            this.put(51, -0.3);
            this.put(52, -0.3);
            this.put(53, -0.3);
            this.put(54, -0.3);
            this.put(62, -0.3);
            this.put(71, -0.3);
            this.put(72, -0.3);
            this.put(73, -0.3);
            this.put(74, -0.3);
            this.put(75, -0.3);
            this.put(76, -0.3);
            this.put(77, -0.3);
            this.put(83, -0.3);
            this.put(84, -0.3);
            this.put(90, -0.3);
            this.put(91, -0.3);
            this.put(92, -0.3);
            this.put(93, -0.3);
            this.put(94, -0.3);
            this.put(95, -0.3);
            this.put(41, 0.0);
            this.put(43, 0.0);
            this.put(61, 0.0);
            this.put(81, 0.0);
            this.put(82, 0.0);
            this.put(85, 0.0);
            this.put(42, 0.4);
        }
    };
    double p_h = 0.58;
    double a = 0.078;
    double c1 = 0.045;
    double c2 = 0.131;
    public Coordinate initialPoint = null;
    public ArrayList<FireTile> fires = new ArrayList();
    public int numBurned = 0;
    public GeometryFactory fa = new GeometryFactory();
    public Geometry extent = this.fa.createPoint(new Coordinate(0.0, 0.0));
    MersenneTwisterFast myRandom;

    public Wildfire(GeomGridField vegetation, GeomGridField elevation, GeomGridField impermeable, Envelope MBR) {
        this.vegetation = vegetation;
        this.elevation = elevation;
        this.impermeability = impermeable;
        this.burning = new GeomGridField();
        this.burning.setMBR(vegetation.getMBR());
        this.burning.setGrid((Grid2D)new IntGrid2D(vegetation.getGridWidth(), vegetation.getGridHeight(), STATE_vulnerable));
        this.burning.setMBR(MBR);
        this.precision = vegetation.getPixelHeight() * 1000.0;
        double radius = 6371000.0;
        double dLat = Math.toRadians(MBR.getMaxX() - MBR.getMinX());
        double dLon = Math.toRadians(0.0);
        double lat1 = Math.toRadians(MBR.getMinX());
        double lat2 = Math.toRadians(MBR.getMaxX());
        double a_prime = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c_prime = 2.0 * Math.atan2(Math.sqrt(a_prime), Math.sqrt(1.0 - a_prime));
        this.precision = radius * c_prime / (double)vegetation.getGrid().getWidth();
        this.myRandom = new MersenneTwisterFast(12345L);
    }

    public void step(SimState state) {
        ArrayList currentFires = (ArrayList)this.fires.clone();
        for (FireTile f : currentFires) {
            f.step(state);
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        Point lastPoint = null;
        int i = 0;
        while (i < this.fires.size()) {
            block10: {
                Point p;
                block9: {
                    block8: {
                        FireTile f = this.fires.get(i);
                        p = this.burning.toPoint(f.x, f.y);
                        if (lastPoint != null) break block8;
                        lastPoint = p;
                        break block9;
                    }
                    if (lastPoint.distance((Geometry)p) < 1000.0) break block10;
                }
                coords.add(new Coordinate(p.getX(), p.getY()));
                lastPoint = p;
            }
            ++i;
        }
        if (coords.size() > 3) {
            coords.add((Coordinate)coords.get(0));
            Polygon myGeom = this.fa.createPolygon(this.fa.createLinearRing(coords.toArray(new Coordinate[0])), null);
            if (myGeom.isEmpty()) {
                return;
            }
            this.extent = this.extent.getNumPoints() > 2 ? myGeom.convexHull().union(this.extent) : myGeom.convexHull();
        } else {
            this.extent = coords.size() > 0 ? this.fa.createPoint((Coordinate)coords.get(0)) : this.fa.createPoint(new Coordinate(0.0, 0.0));
        }
    }

    public void initiateFire(double lat, double lon) {
        int x = this.vegetation.toXCoord(lat);
        int y = this.vegetation.toYCoord(lon);
        FireTile init = new FireTile(x, y, this);
        ((IntGrid2D)this.burning.getGrid()).field[x][y] = STATE_burning;
        this.fires.add(init);
        this.initialPoint = new Coordinate(lat, lon);
    }

    public GeomGridField getGrid() {
        return this.burning;
    }

    class FireTile
    implements Steppable {
        Wildfire owner;
        int x;
        int y;

        public FireTile(int x, int y, Wildfire owner) {
            this.x = x;
            this.y = y;
            this.owner = owner;
        }

        public void step(SimState state) {
            int[][] fieldy = ((IntGrid2D)this.owner.burning.getGrid()).field;
            int status = fieldy[this.x][this.y];
            if (status == STATE_burned || status == STATE_no_fuel) {
                return;
            }
            if (status == STATE_burning) {
                int myIndex = Wildfire.this.fires.indexOf(this);
                fieldy[this.x][this.y] = STATE_burned;
                ++Wildfire.this.numBurned;
                IntBag xPos = new IntBag();
                IntBag yPos = new IntBag();
                ((IntGrid2D)this.owner.burning.getGrid()).getNeighborsHexagonalDistance(this.x, this.y, 1, false, xPos, yPos);
                int[] xs = xPos.objs;
                int[] ys = yPos.objs;
                int i = 0;
                while (i < xs.length) {
                    int neighbor_state = fieldy[xs[i]][ys[i]];
                    int permeable = ((IntGrid2D)this.owner.impermeability.getGrid()).field[xs[i]][ys[i]];
                    if (neighbor_state == STATE_vulnerable && permeable == 0) {
                        int veg = ((IntGrid2D)Wildfire.this.vegetation.getGrid()).field[xs[i]][ys[i]];
                        double p_den = veg_density.get(veg);
                        double p_veg = veg_type.get(veg);
                        double p_w = Math.exp(Wildfire.this.c1 * Wildfire.this.windspeed) * Math.exp(Wildfire.this.windspeed * Wildfire.this.c2 * -2.0);
                        DoubleGrid2D elev = (DoubleGrid2D)Wildfire.this.elevation.getGrid();
                        double theta_s = this.theta_s(elev.field[this.x][this.y], elev.field[xs[i]][ys[i]], this.x != xs[i] && this.y != ys[i]);
                        double p_s = Math.exp(Wildfire.this.a * theta_s);
                        double p_burn = Wildfire.this.p_h * (1.0 + p_veg) * (1.0 + p_den) * p_s * p_w;
                        if (Wildfire.this.myRandom.nextDouble() < p_burn) {
                            fieldy[xs[i]][ys[i]] = STATE_burning;
                            FireTile f = new FireTile(xs[i], ys[i], this.owner);
                            this.owner.fires.add(myIndex, f);
                            ++myIndex;
                        }
                    }
                    ++i;
                }
            }
            Wildfire.this.fires.remove(this);
        }

        double theta_s(double e1, double e2, boolean diagonal) {
            if (diagonal) {
                return Math.atan((e1 - e2) / Wildfire.this.precision);
            }
            return Math.atan((e1 - e2) / (Wildfire.this.precision * Wildfire.this.sqrt2));
        }
    }
}

