/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import sim.field.network.Edge;
import sim.field.network.Network;
import swise.objects.network.GeoNode;

public class AStar {
    public ArrayList<Edge> astarPath(GeoNode start, GeoNode goal, Network network) {
        if (start == null || goal == null) {
            System.out.println("Error: invalid node provided to AStar");
            return null;
        }
        if (start == goal) {
            return new ArrayList<Edge>();
        }
        HashMap<GeoNode, AStarNodeWrapper> foundNodes = new HashMap<GeoNode, AStarNodeWrapper>();
        AStarNodeWrapper startNode = new AStarNodeWrapper(start);
        AStarNodeWrapper goalNode = new AStarNodeWrapper(goal);
        foundNodes.put(start, startNode);
        foundNodes.put(goal, goalNode);
        startNode.gx = 0.0;
        startNode.hx = this.heuristic(start, goal);
        startNode.fx = this.heuristic(start, goal);
        ArrayList<AStarNodeWrapper> closedSet = new ArrayList<AStarNodeWrapper>();
        ArrayList<AStarNodeWrapper> openSet = new ArrayList<AStarNodeWrapper>();
        openSet.add(startNode);
        while (openSet.size() > 0) {
            AStarNodeWrapper x = this.findMin(openSet);
            if (x.node == goal) {
                return this.reconstructPath(goalNode);
            }
            openSet.remove(x);
            closedSet.add(x);
            for (Object o : network.getEdges((Object)x.node, null)) {
                AStarNodeWrapper nextNode;
                Edge l = (Edge)o;
                GeoNode next = null;
                next = (GeoNode)((Object)l.getOtherNode((Object)x.node));
                if (foundNodes.containsKey((Object)next)) {
                    nextNode = (AStarNodeWrapper)foundNodes.get((Object)next);
                } else {
                    nextNode = new AStarNodeWrapper(next);
                    foundNodes.put(next, nextNode);
                }
                if (closedSet.contains(nextNode)) continue;
                double tentativeCost = x.gx + this.length(l);
                boolean better = false;
                if (!openSet.contains(nextNode)) {
                    openSet.add(nextNode);
                    nextNode.hx = this.heuristic(next, goal);
                    better = true;
                } else if (tentativeCost < nextNode.gx) {
                    better = true;
                }
                if (!better) continue;
                nextNode.cameFrom = x;
                nextNode.edgeFrom = l;
                nextNode.gx = tentativeCost;
                nextNode.fx = nextNode.gx + nextNode.hx;
            }
        }
        return null;
    }

    public ArrayList<Edge> astarPath(GeoNode start, ArrayList<GeoNode> goal, Network network) {
        if (start == null || goal == null || goal.size() == 0) {
            System.out.println("Error: invalid nodeset provided to AStar");
            return null;
        }
        if (goal.contains((Object)start)) {
            return null;
        }
        HashMap<GeoNode, AStarNodeWrapper> foundNodes = new HashMap<GeoNode, AStarNodeWrapper>();
        AStarNodeWrapper startNode = new AStarNodeWrapper(start);
        foundNodes.put(start, startNode);
        startNode.gx = 0.0;
        ArrayList<AStarNodeWrapper> goalNodes = new ArrayList<AStarNodeWrapper>();
        double minVal = Double.MAX_VALUE;
        for (GeoNode n : goal) {
            AStarNodeWrapper goalNode = new AStarNodeWrapper(n);
            goalNodes.add(goalNode);
            foundNodes.put(n, goalNode);
            double hval = this.heuristic(start, n);
            if (!(hval < minVal)) continue;
            minVal = hval;
        }
        startNode.hx = minVal;
        startNode.fx = minVal;
        ArrayList<AStarNodeWrapper> closedSet = new ArrayList<AStarNodeWrapper>();
        ArrayList<AStarNodeWrapper> openSet = new ArrayList<AStarNodeWrapper>();
        openSet.add(startNode);
        while (openSet.size() > 0) {
            AStarNodeWrapper x = this.findMin(openSet);
            if (goal.contains((Object)x.node)) {
                return this.reconstructPath((AStarNodeWrapper)foundNodes.get((Object)x.node));
            }
            openSet.remove(x);
            closedSet.add(x);
            for (Object o : network.getEdgesOut((Object)x.node)) {
                AStarNodeWrapper nextNode;
                Edge l = (Edge)o;
                GeoNode next = null;
                next = (GeoNode)((Object)l.getOtherNode((Object)x.node));
                if (foundNodes.containsKey((Object)next)) {
                    nextNode = (AStarNodeWrapper)foundNodes.get((Object)next);
                } else {
                    nextNode = new AStarNodeWrapper(next);
                    foundNodes.put(next, nextNode);
                }
                if (closedSet.contains(nextNode)) continue;
                double tentativeCost = x.gx + this.length(l);
                boolean better = false;
                if (!openSet.contains(nextNode)) {
                    openSet.add(nextNode);
                    minVal = Double.MAX_VALUE;
                    for (GeoNode n : goal) {
                        double hval = this.heuristic(next, n);
                        if (!(hval < minVal)) continue;
                        minVal = hval;
                    }
                    nextNode.hx = minVal;
                    better = true;
                } else if (tentativeCost < nextNode.gx) {
                    better = true;
                }
                if (!better) continue;
                nextNode.cameFrom = x;
                nextNode.edgeFrom = l;
                nextNode.gx = tentativeCost;
                nextNode.fx = nextNode.gx + nextNode.hx;
            }
        }
        System.out.println("A* ERROR: No path found. Graph has only " + closedSet.size() + " nodes associated with it");
        return null;
    }

    public ArrayList<Edge> astarWeightedPath(GeoNode start, GeoNode goal, Network network, HashSet<Object> weighted, double weight) {
        if (start == null || goal == null) {
            System.out.println("Error: invalid nodeset provided to AStar");
        }
        ArrayList result = new ArrayList();
        HashMap<GeoNode, AStarNodeWrapper> foundNodes = new HashMap<GeoNode, AStarNodeWrapper>();
        AStarNodeWrapper startNode = new AStarNodeWrapper(start);
        AStarNodeWrapper goalNode = new AStarNodeWrapper(goal);
        foundNodes.put(start, startNode);
        foundNodes.put(goal, goalNode);
        startNode.gx = 0.0;
        startNode.hx = this.heuristic(start, goal);
        startNode.fx = this.heuristic(start, goal);
        HashSet<AStarNodeWrapper> closedSet = new HashSet<AStarNodeWrapper>();
        HashSet<AStarNodeWrapper> openSet = new HashSet<AStarNodeWrapper>();
        openSet.add(startNode);
        while (openSet.size() > 0) {
            AStarNodeWrapper x = this.findMin(openSet);
            if (x.node == goal) {
                return this.reconstructPath((AStarNodeWrapper)foundNodes.get((Object)x.node));
            }
            openSet.remove(x);
            closedSet.add(x);
            for (Object o : network.getEdgesOut((Object)x.node)) {
                AStarNodeWrapper nextNode;
                Edge l = (Edge)o;
                GeoNode next = null;
                next = (GeoNode)((Object)l.getOtherNode((Object)x.node));
                if (foundNodes.containsKey((Object)next)) {
                    nextNode = (AStarNodeWrapper)foundNodes.get((Object)next);
                } else {
                    nextNode = new AStarNodeWrapper(next);
                    foundNodes.put(next, nextNode);
                }
                if (closedSet.contains(nextNode)) continue;
                double edge_factor = 1.0;
                double node_factor = 1.0;
                if (weighted.contains(l)) {
                    edge_factor = weight;
                }
                if (weighted.contains((Object)next)) {
                    node_factor = weight;
                }
                double tentativeCost = node_factor * (x.gx + edge_factor * this.length(l));
                boolean better = false;
                if (!openSet.contains(nextNode)) {
                    openSet.add(nextNode);
                    nextNode.hx = this.heuristic(next, goal);
                    better = true;
                } else if (tentativeCost < nextNode.gx) {
                    better = true;
                }
                if (!better) continue;
                nextNode.cameFrom = x;
                nextNode.edgeFrom = l;
                nextNode.gx = tentativeCost;
                nextNode.fx = nextNode.gx + nextNode.hx;
            }
        }
        System.out.println("A* Problem: graph has only " + closedSet.size() + " nodes associated with it");
        return null;
    }

    ArrayList<Edge> reconstructPath(AStarNodeWrapper n) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        AStarNodeWrapper x = n;
        while (x.cameFrom != null) {
            result.add(x.edgeFrom);
            x = x.cameFrom;
        }
        if (result.size() < 1) {
            System.out.println("stuipd path...");
        }
        return result;
    }

    double heuristic(GeoNode x, GeoNode y) {
        Coordinate xnode = x.geometry.getCoordinate();
        Coordinate ynode = y.geometry.getCoordinate();
        int nodeCost = 0;
        if (x.hasAttribute("delay")) {
            nodeCost += x.getIntegerAttribute("delay").intValue();
        }
        if (y.hasAttribute("delay")) {
            nodeCost += y.getIntegerAttribute("delay").intValue();
        }
        return (double)nodeCost + Math.sqrt(Math.pow(xnode.x - ynode.x, 2.0) + Math.pow(xnode.y - ynode.y, 2.0));
    }

    double length(Edge e) {
        Coordinate xnode = ((GeoNode)((Object)e.from())).geometry.getCoordinate();
        Coordinate ynode = ((GeoNode)((Object)e.to())).geometry.getCoordinate();
        return Math.sqrt(Math.pow(xnode.x - ynode.x, 2.0) + Math.pow(xnode.y - ynode.y, 2.0));
    }

    AStarNodeWrapper findMin(ArrayList<AStarNodeWrapper> set) {
        double min = Double.MAX_VALUE;
        AStarNodeWrapper minNode = null;
        for (AStarNodeWrapper n : set) {
            if (!(n.fx < min)) continue;
            min = n.fx;
            minNode = n;
        }
        return minNode;
    }

    AStarNodeWrapper findMin(HashSet<AStarNodeWrapper> set) {
        double min = Double.MAX_VALUE;
        AStarNodeWrapper minNode = null;
        for (AStarNodeWrapper n : set) {
            if (!(n.fx < min)) continue;
            min = n.fx;
            minNode = n;
        }
        return minNode;
    }

    class AStarNodeWrapper {
        GeoNode node;
        AStarNodeWrapper cameFrom;
        Edge edgeFrom;
        double gx;
        double hx;
        double fx;

        public AStarNodeWrapper(GeoNode n) {
            this.node = n;
            this.gx = 0.0;
            this.hx = 0.0;
            this.fx = 0.0;
            this.cameFrom = null;
            this.edgeFrom = null;
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

