/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.Hashtable;
import java.util.Map;

public class CoordinateConversion {
    public double[] utm2LatLon(String UTM) {
        UTM2LatLon c = new UTM2LatLon(null, null);
        return c.convertUTMToLatLong(UTM);
    }

    public String latLon2UTM(double latitude, double longitude) {
        LatLon2UTM c = new LatLon2UTM(null, null);
        return c.convertLatLonToUTM(latitude, longitude);
    }

    public Coordinate latLon2UTMCoord(double latitude, double longitude) {
        LatLon2UTM c = new LatLon2UTM(null, null);
        return c.convertLatLonToUTMCoord(latitude, longitude);
    }

    private void validate(double latitude, double longitude) {
        if (latitude < -90.0 || latitude > 90.0 || longitude < -180.0 || longitude >= 180.0) {
            throw new IllegalArgumentException("Legal ranges: latitude [-90,90], longitude [-180,180).");
        }
    }

    public String latLon2MGRUTM(double latitude, double longitude) {
        LatLon2MGRUTM c = new LatLon2MGRUTM();
        return c.convertLatLonToMGRUTM(latitude, longitude);
    }

    public double[] mgrutm2LatLon(String MGRUTM) {
        MGRUTM2LatLon c = new MGRUTM2LatLon();
        return c.convertMGRUTMToLatLong(MGRUTM);
    }

    public double degreeToRadian(double degree) {
        return degree * Math.PI / 180.0;
    }

    public double radianToDegree(double radian) {
        return radian * 180.0 / Math.PI;
    }

    private double POW(double a, double b) {
        return Math.pow(a, b);
    }

    private double SIN(double value) {
        return Math.sin(value);
    }

    private double COS(double value) {
        return Math.cos(value);
    }

    private double TAN(double value) {
        return Math.tan(value);
    }

    public static double[] wgs84toOSGB36(double lat, double lon) {
        double E;
        double[] retVals = new double[2];
        double lat_1 = lat * Math.PI / 180.0;
        double lon_1 = lon * Math.PI / 180.0;
        double a_1 = 6378137.0;
        double b_1 = 6356752.3141;
        double e2_1 = 1.0 - b_1 * b_1 / (a_1 * a_1);
        double nu_1 = a_1 / Math.sqrt(1.0 - e2_1 * (Math.sin(lat_1) * Math.sin(lat_1)));
        double H = 0.0;
        double x_1 = (nu_1 + H) * Math.cos(lat_1) * Math.cos(lon_1);
        double y_1 = (nu_1 + H) * Math.cos(lat_1) * Math.sin(lon_1);
        double z_1 = ((1.0 - e2_1) * nu_1 + H) * Math.sin(lat_1);
        double s = 20.4894 * Math.pow(10.0, -6.0);
        double tx = -446.448;
        double ty = 125.157;
        double tz = -542.06;
        double rxs = -0.1502;
        double rys = -0.247;
        double rzs = -0.8421;
        double rx = rxs * Math.PI / 648000.0;
        double ry = rys * Math.PI / 648000.0;
        double rz = rzs * Math.PI / 648000.0;
        double x_2 = tx + (1.0 + s) * x_1 + -rz * y_1 + ry * z_1;
        double y_2 = ty + rz * x_1 + (1.0 + s) * y_1 + -rx * z_1;
        double z_2 = tz + -ry * x_1 + rx * y_1 + (1.0 + s) * z_1;
        double a = 6377563.396;
        double b = 6356256.909;
        double e2 = 1.0 - b * b / (a * a);
        double p = Math.sqrt(Math.pow(x_2, 2.0) + Math.pow(y_2, 2.0));
        lat = Math.atan2(z_2, p * (1.0 - e2));
        double latold = Math.PI * 2;
        double nu = 0.0;
        int numLoops = 0;
        while ((double)numLoops < Math.pow(10.0, -16.0)) {
            latold = lat;
            nu = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(latold), 2.0));
            lat = Math.atan2(z_2 + e2 * nu * Math.sin(latold), p);
            ++numLoops;
        }
        lon = Math.atan2(y_2, x_2);
        H = p / Math.cos(lat) - nu;
        double F0 = 0.9996012717;
        double lat0 = 0.8552113334772214;
        double lon0 = -Math.PI / 90;
        double N0 = -100000.0;
        double E0 = 400000.0;
        double n = (a - b) / (a + b);
        double rho = a * F0 * (1.0 - e2) * (1.0 - e2 * Math.pow(Math.pow(Math.sin(lat), 2.0), -1.5));
        double eta2 = nu * F0 / rho - 1.0;
        double M1 = (1.0 + n + 1.0 * Math.pow(n, 2.0) + 1.0 * Math.pow(n, 3.0)) * (lat - lat0);
        double M2 = (3.0 * n + 3.0 * Math.pow(n, 2.0) + 2.0 * Math.pow(n, 3.0)) * Math.sin(lat - lat0) * Math.cos(lat + lat0);
        double M3 = (1.0 * Math.pow(n, 2.0) + 1.0 * Math.pow(n, 3.0)) * Math.sin(2.0 * (lat - lat0)) * Math.cos(2.0 * (lat + lat0));
        double M4 = 1.0 * Math.pow(n, 3.0) * Math.sin(3.0 * (lat - lat0)) * Math.cos(3.0 * (lat + lat0));
        double M = b * F0 * (M1 - M2 + M3 - M4);
        double I = M + N0;
        double II = nu * F0 * Math.sin(lat) * Math.cos(lat) / 2.0;
        double III = nu * F0 * Math.sin(lat) * Math.pow(Math.cos(lat), 3.0) * (5.0 - Math.pow(Math.tan(lat), 2.0) + 9.0 * eta2) / 24.0;
        double IIIA = nu * F0 * Math.sin(lat) * Math.pow(Math.cos(lat), 5.0) * (61.0 - 58.0 * Math.pow(Math.tan(lat), 2.0) + Math.pow(Math.tan(lat), 4.0)) / 720.0;
        double IV = nu * F0 * Math.cos(lat);
        double V = nu * F0 * Math.pow(Math.cos(lat), 3.0) * (nu / rho - Math.pow(Math.tan(lat), 2.0)) / 6.0;
        double VI = nu * F0 * Math.pow(Math.cos(lat), 5.0) * (5.0 - 18.0 * Math.pow(Math.tan(lat), 2.0) + Math.pow(Math.tan(lat), 4.0) + 14.0 * eta2 - 58.0 * eta2 * Math.pow(Math.tan(lat), 2.0)) / 120.0;
        double N = I + II * Math.pow(lon - lon0, 2.0) + III * Math.pow(lon - lon0, 4.0) + IIIA * Math.pow(lon - lon0, 6.0);
        retVals[0] = E = E0 + IV * (lon - lon0) + V * Math.pow(lon - lon0, 3.0) + VI * Math.pow(lon - lon0, 5.0);
        retVals[1] = N;
        return retVals;
    }

    private class Digraphs {
        private Map digraph1 = new Hashtable();
        private Map digraph2 = new Hashtable();
        private String[] digraph1Array = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        private String[] digraph2Array = new String[]{"V", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V"};

        public Digraphs() {
            this.digraph1.put(new Integer(1), "A");
            this.digraph1.put(new Integer(2), "B");
            this.digraph1.put(new Integer(3), "C");
            this.digraph1.put(new Integer(4), "D");
            this.digraph1.put(new Integer(5), "E");
            this.digraph1.put(new Integer(6), "F");
            this.digraph1.put(new Integer(7), "G");
            this.digraph1.put(new Integer(8), "H");
            this.digraph1.put(new Integer(9), "J");
            this.digraph1.put(new Integer(10), "K");
            this.digraph1.put(new Integer(11), "L");
            this.digraph1.put(new Integer(12), "M");
            this.digraph1.put(new Integer(13), "N");
            this.digraph1.put(new Integer(14), "P");
            this.digraph1.put(new Integer(15), "Q");
            this.digraph1.put(new Integer(16), "R");
            this.digraph1.put(new Integer(17), "S");
            this.digraph1.put(new Integer(18), "T");
            this.digraph1.put(new Integer(19), "U");
            this.digraph1.put(new Integer(20), "V");
            this.digraph1.put(new Integer(21), "W");
            this.digraph1.put(new Integer(22), "X");
            this.digraph1.put(new Integer(23), "Y");
            this.digraph1.put(new Integer(24), "Z");
            this.digraph2.put(new Integer(0), "V");
            this.digraph2.put(new Integer(1), "A");
            this.digraph2.put(new Integer(2), "B");
            this.digraph2.put(new Integer(3), "C");
            this.digraph2.put(new Integer(4), "D");
            this.digraph2.put(new Integer(5), "E");
            this.digraph2.put(new Integer(6), "F");
            this.digraph2.put(new Integer(7), "G");
            this.digraph2.put(new Integer(8), "H");
            this.digraph2.put(new Integer(9), "J");
            this.digraph2.put(new Integer(10), "K");
            this.digraph2.put(new Integer(11), "L");
            this.digraph2.put(new Integer(12), "M");
            this.digraph2.put(new Integer(13), "N");
            this.digraph2.put(new Integer(14), "P");
            this.digraph2.put(new Integer(15), "Q");
            this.digraph2.put(new Integer(16), "R");
            this.digraph2.put(new Integer(17), "S");
            this.digraph2.put(new Integer(18), "T");
            this.digraph2.put(new Integer(19), "U");
            this.digraph2.put(new Integer(20), "V");
        }

        public int getDigraph1Index(String letter) {
            int i = 0;
            while (i < this.digraph1Array.length) {
                if (this.digraph1Array[i].equals(letter)) {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }

        public int getDigraph2Index(String letter) {
            int i = 0;
            while (i < this.digraph2Array.length) {
                if (this.digraph2Array[i].equals(letter)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String getDigraph1(int longZone, double easting) {
            int a1 = longZone;
            double a2 = 8 * ((a1 - 1) % 3) + 1;
            double a3 = easting;
            double a4 = a2 + (double)((int)(a3 / 100000.0)) - 1.0;
            return (String)this.digraph1.get(new Integer((int)Math.floor(a4)));
        }

        public String getDigraph2(int longZone, double northing) {
            int a1 = longZone;
            double a2 = 1 + 5 * ((a1 - 1) % 2);
            double a3 = northing;
            double a4 = a2 + (double)((int)(a3 / 100000.0));
            a4 = (a2 + (double)((int)(a3 / 100000.0))) % 20.0;
            if ((a4 = Math.floor(a4)) < 0.0) {
                a4 += 19.0;
            }
            return (String)this.digraph2.get(new Integer((int)Math.floor(a4)));
        }
    }

    private class LatLon2MGRUTM
    extends LatLon2UTM {
        private LatLon2MGRUTM() {
        }

        public String convertLatLonToMGRUTM(double latitude, double longitude) {
            CoordinateConversion.this.validate(latitude, longitude);
            String mgrUTM = "";
            this.setVariables(latitude, longitude);
            String longZone = this.getLongZone(longitude);
            LatZones latZones = new LatZones();
            String latZone = latZones.getLatZone(latitude);
            double _easting = this.getEasting();
            double _northing = this.getNorthing(latitude);
            Digraphs digraphs = new Digraphs();
            String digraph1 = digraphs.getDigraph1(Integer.parseInt(longZone), _easting);
            String digraph2 = digraphs.getDigraph2(Integer.parseInt(longZone), _northing);
            String easting = String.valueOf((int)_easting);
            if (easting.length() < 5) {
                easting = "00000" + easting;
            }
            easting = easting.substring(easting.length() - 5);
            String northing = String.valueOf((int)_northing);
            if (northing.length() < 5) {
                northing = "0000" + northing;
            }
            northing = northing.substring(northing.length() - 5);
            mgrUTM = String.valueOf(longZone) + latZone + digraph1 + digraph2 + easting + northing;
            return mgrUTM;
        }
    }

    private class LatLon2UTM {
        double equatorialRadius = 6378137.0;
        double polarRadius = 6356752.314;
        double flattening = 0.00335281066474748;
        double inverseFlattening = 298.257223563;
        double rm;
        double k0;
        double e;
        double e1sq;
        double n;
        double rho;
        double nu;
        double S;
        double A0;
        double B0;
        double C0;
        double D0;
        double E0;
        double p;
        double sin1;
        double K1;
        double K2;
        double K3;
        double K4;
        double K5;
        double A6;

        private LatLon2UTM() {
            this.rm = CoordinateConversion.this.POW(this.equatorialRadius * this.polarRadius, 0.5);
            this.k0 = 0.9996;
            this.e = Math.sqrt(1.0 - CoordinateConversion.this.POW(this.polarRadius / this.equatorialRadius, 2.0));
            this.e1sq = this.e * this.e / (1.0 - this.e * this.e);
            this.n = (this.equatorialRadius - this.polarRadius) / (this.equatorialRadius + this.polarRadius);
            this.rho = 6368573.744;
            this.nu = 6389236.914;
            this.S = 5103266.421;
            this.A0 = 6367449.146;
            this.B0 = 16038.42955;
            this.C0 = 16.83261333;
            this.D0 = 0.021984404;
            this.E0 = 3.12705E-4;
            this.p = -0.483084;
            this.sin1 = 4.84814E-6;
            this.K1 = 5101225.115;
            this.K2 = 3750.291596;
            this.K3 = 1.397608151;
            this.K4 = 214839.3105;
            this.K5 = -2.995382942;
            this.A6 = -1.00541E-7;
        }

        public String convertLatLonToUTM(double latitude, double longitude) {
            CoordinateConversion.this.validate(latitude, longitude);
            String UTM = "";
            this.setVariables(latitude, longitude);
            String longZone = this.getLongZone(longitude);
            LatZones latZones = new LatZones();
            String latZone = latZones.getLatZone(latitude);
            double _easting = this.getEasting();
            double _northing = this.getNorthing(latitude);
            UTM = String.valueOf(longZone) + " " + latZone + " " + (int)_easting + " " + (int)_northing;
            return UTM;
        }

        public Coordinate convertLatLonToUTMCoord(double latitude, double longitude) {
            CoordinateConversion.this.validate(latitude, longitude);
            String UTM = "";
            this.setVariables(latitude, longitude);
            String longZone = this.getLongZone(longitude);
            LatZones latZones = new LatZones();
            String latZone = latZones.getLatZone(latitude);
            double _easting = this.getEasting();
            double _northing = this.getNorthing(latitude);
            return new Coordinate(_easting, _northing);
        }

        protected void setVariables(double latitude, double longitude) {
            latitude = CoordinateConversion.this.degreeToRadian(latitude);
            this.rho = this.equatorialRadius * (1.0 - this.e * this.e) / CoordinateConversion.this.POW(1.0 - CoordinateConversion.this.POW(this.e * CoordinateConversion.this.SIN(latitude), 2.0), 1.5);
            this.nu = this.equatorialRadius / CoordinateConversion.this.POW(1.0 - CoordinateConversion.this.POW(this.e * CoordinateConversion.this.SIN(latitude), 2.0), 0.5);
            double var1 = longitude < 0.0 ? (double)((int)((180.0 + longitude) / 6.0) + 1) : (double)((int)(longitude / 6.0) + 31);
            double var2 = 6.0 * var1 - 183.0;
            double var3 = longitude - var2;
            this.p = var3 * 3600.0 / 10000.0;
            this.S = this.A0 * latitude - this.B0 * CoordinateConversion.this.SIN(2.0 * latitude) + this.C0 * CoordinateConversion.this.SIN(4.0 * latitude) - this.D0 * CoordinateConversion.this.SIN(6.0 * latitude) + this.E0 * CoordinateConversion.this.SIN(8.0 * latitude);
            this.K1 = this.S * this.k0;
            this.K2 = this.nu * CoordinateConversion.this.SIN(latitude) * CoordinateConversion.this.COS(latitude) * CoordinateConversion.this.POW(this.sin1, 2.0) * this.k0 * 1.0E8 / 2.0;
            this.K3 = CoordinateConversion.this.POW(this.sin1, 4.0) * this.nu * CoordinateConversion.this.SIN(latitude) * Math.pow(CoordinateConversion.this.COS(latitude), 3.0) / 24.0 * (5.0 - CoordinateConversion.this.POW(CoordinateConversion.this.TAN(latitude), 2.0) + 9.0 * this.e1sq * CoordinateConversion.this.POW(CoordinateConversion.this.COS(latitude), 2.0) + 4.0 * CoordinateConversion.this.POW(this.e1sq, 2.0) * CoordinateConversion.this.POW(CoordinateConversion.this.COS(latitude), 4.0)) * this.k0 * 1.0E16;
            this.K4 = this.nu * CoordinateConversion.this.COS(latitude) * this.sin1 * this.k0 * 10000.0;
            this.K5 = CoordinateConversion.this.POW(this.sin1 * CoordinateConversion.this.COS(latitude), 3.0) * (this.nu / 6.0) * (1.0 - CoordinateConversion.this.POW(CoordinateConversion.this.TAN(latitude), 2.0) + this.e1sq * CoordinateConversion.this.POW(CoordinateConversion.this.COS(latitude), 2.0)) * this.k0 * 1.0E12;
            this.A6 = CoordinateConversion.this.POW(this.p * this.sin1, 6.0) * this.nu * CoordinateConversion.this.SIN(latitude) * CoordinateConversion.this.POW(CoordinateConversion.this.COS(latitude), 5.0) / 720.0 * (61.0 - 58.0 * CoordinateConversion.this.POW(CoordinateConversion.this.TAN(latitude), 2.0) + CoordinateConversion.this.POW(CoordinateConversion.this.TAN(latitude), 4.0) + 270.0 * this.e1sq * CoordinateConversion.this.POW(CoordinateConversion.this.COS(latitude), 2.0) - 330.0 * this.e1sq * CoordinateConversion.this.POW(CoordinateConversion.this.SIN(latitude), 2.0)) * this.k0 * 1.0E24;
        }

        protected String getLongZone(double longitude) {
            double longZone = 0.0;
            longZone = longitude < 0.0 ? (180.0 + longitude) / 6.0 + 1.0 : longitude / 6.0 + 31.0;
            String val = String.valueOf((int)longZone);
            if (val.length() == 1) {
                val = "0" + val;
            }
            return val;
        }

        protected double getNorthing(double latitude) {
            double northing = this.K1 + this.K2 * this.p * this.p + this.K3 * CoordinateConversion.this.POW(this.p, 4.0);
            if (latitude < 0.0) {
                northing += 1.0E7;
            }
            return northing;
        }

        protected double getEasting() {
            return 500000.0 + (this.K4 * this.p + this.K5 * CoordinateConversion.this.POW(this.p, 3.0));
        }

        /* synthetic */ LatLon2UTM(LatLon2UTM latLon2UTM, LatLon2UTM latLon2UTM2) {
            this();
        }
    }

    private class LatZones {
        private char[] letters = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Z'};
        private int[] degrees;
        private char[] negLetters;
        private int[] negDegrees;
        private char[] posLetters;
        private int[] posDegrees;
        private int arrayLength;

        public LatZones() {
            int[] nArray = new int[22];
            nArray[0] = -90;
            nArray[1] = -84;
            nArray[2] = -72;
            nArray[3] = -64;
            nArray[4] = -56;
            nArray[5] = -48;
            nArray[6] = -40;
            nArray[7] = -32;
            nArray[8] = -24;
            nArray[9] = -16;
            nArray[10] = -8;
            nArray[12] = 8;
            nArray[13] = 16;
            nArray[14] = 24;
            nArray[15] = 32;
            nArray[16] = 40;
            nArray[17] = 48;
            nArray[18] = 56;
            nArray[19] = 64;
            nArray[20] = 72;
            nArray[21] = 84;
            this.degrees = nArray;
            this.negLetters = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M'};
            this.negDegrees = new int[]{-90, -84, -72, -64, -56, -48, -40, -32, -24, -16, -8};
            this.posLetters = new char[]{'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Z'};
            int[] nArray2 = new int[11];
            nArray2[1] = 8;
            nArray2[2] = 16;
            nArray2[3] = 24;
            nArray2[4] = 32;
            nArray2[5] = 40;
            nArray2[6] = 48;
            nArray2[7] = 56;
            nArray2[8] = 64;
            nArray2[9] = 72;
            nArray2[10] = 84;
            this.posDegrees = nArray2;
            this.arrayLength = 22;
        }

        public int getLatZoneDegree(String letter) {
            char ltr = letter.charAt(0);
            int i = 0;
            while (i < this.arrayLength) {
                if (this.letters[i] == ltr) {
                    return this.degrees[i];
                }
                ++i;
            }
            return -100;
        }

        public String getLatZone(double latitude) {
            int latIndex = -2;
            int lat = (int)latitude;
            if (lat >= 0) {
                int len = this.posLetters.length;
                int i = 0;
                while (i < len) {
                    if (lat == this.posDegrees[i]) {
                        latIndex = i;
                        break;
                    }
                    if (lat <= this.posDegrees[i]) {
                        latIndex = i - 1;
                        break;
                    }
                    ++i;
                }
            } else {
                int len = this.negLetters.length;
                int i = 0;
                while (i < len) {
                    if (lat == this.negDegrees[i]) {
                        latIndex = i;
                        break;
                    }
                    if (lat < this.negDegrees[i]) {
                        latIndex = i - 1;
                        break;
                    }
                    ++i;
                }
            }
            if (latIndex == -1) {
                latIndex = 0;
            }
            if (lat >= 0) {
                if (latIndex == -2) {
                    latIndex = this.posLetters.length - 1;
                }
                return String.valueOf(this.posLetters[latIndex]);
            }
            if (latIndex == -2) {
                latIndex = this.negLetters.length - 1;
            }
            return String.valueOf(this.negLetters[latIndex]);
        }
    }

    private class MGRUTM2LatLon
    extends UTM2LatLon {
        private MGRUTM2LatLon() {
        }

        public double[] convertMGRUTMToLatLong(String mgrutm) {
            double a3;
            double[] latlon = new double[]{0.0, 0.0};
            int zone = Integer.parseInt(mgrutm.substring(0, 2));
            String latZone = mgrutm.substring(2, 3);
            String digraph1 = mgrutm.substring(3, 4);
            String digraph2 = mgrutm.substring(4, 5);
            this.easting = Double.parseDouble(mgrutm.substring(5, 10));
            this.northing = Double.parseDouble(mgrutm.substring(10, 15));
            LatZones lz = new LatZones();
            double latZoneDegree = lz.getLatZoneDegree(latZone);
            double a1 = latZoneDegree * 4.0E7 / 360.0;
            double a2 = 2000000.0 * Math.floor(a1 / 2000000.0);
            Digraphs digraphs = new Digraphs();
            double digraph2Index = digraphs.getDigraph2Index(digraph2);
            double startindexEquator = 1.0;
            if (1 + zone % 2 == 1) {
                startindexEquator = 6.0;
            }
            if ((a3 = a2 + (digraph2Index - startindexEquator) * 100000.0) <= 0.0) {
                a3 += 1.0E7;
            }
            this.northing = a3 + this.northing;
            this.zoneCM = -183 + 6 * zone;
            double digraph1Index = digraphs.getDigraph1Index(digraph1);
            int a5 = 1 + zone % 3;
            double[] a6 = new double[]{16.0, 0.0, 8.0};
            double a7 = 100000.0 * (digraph1Index - a6[a5 - 1]);
            this.easting += a7;
            this.setVariables();
            double latitude = 0.0;
            latitude = 180.0 * (this.phi1 - this.fact1 * (this.fact2 + this.fact3 + this.fact4)) / Math.PI;
            if (latZoneDegree < 0.0) {
                latitude = 90.0 - latitude;
            }
            double d = this._a2 * 180.0 / Math.PI;
            double longitude = this.zoneCM - d;
            if (this.getHemisphere(latZone).equals("S")) {
                latitude = -latitude;
            }
            latlon[0] = latitude;
            latlon[1] = longitude;
            return latlon;
        }
    }

    private class UTM2LatLon {
        double easting;
        double northing;
        int zone;
        String southernHemisphere = "ACDEFGHJKLM";
        double arc;
        double mu;
        double ei;
        double ca;
        double cb;
        double cc;
        double cd;
        double n0;
        double r0;
        double _a1;
        double dd0;
        double t0;
        double Q0;
        double lof1;
        double lof2;
        double lof3;
        double _a2;
        double phi1;
        double fact1;
        double fact2;
        double fact3;
        double fact4;
        double zoneCM;
        double _a3;
        double b = 6356752.314;
        double a = 6378137.0;
        double e = 0.081819191;
        double e1sq = 0.006739497;
        double k0 = 0.9996;

        private UTM2LatLon() {
        }

        protected String getHemisphere(String latZone) {
            String hemisphere = "N";
            if (this.southernHemisphere.indexOf(latZone) > -1) {
                hemisphere = "S";
            }
            return hemisphere;
        }

        public double[] convertUTMToLatLong(String UTM) {
            double[] latlon = new double[]{0.0, 0.0};
            String[] utm = UTM.split(" ");
            this.zone = Integer.parseInt(utm[0]);
            String latZone = utm[1];
            this.easting = Double.parseDouble(utm[2]);
            this.northing = Double.parseDouble(utm[3]);
            String hemisphere = this.getHemisphere(latZone);
            double latitude = 0.0;
            double longitude = 0.0;
            if (hemisphere.equals("S")) {
                this.northing = 1.0E7 - this.northing;
            }
            this.setVariables();
            latitude = 180.0 * (this.phi1 - this.fact1 * (this.fact2 + this.fact3 + this.fact4)) / Math.PI;
            this.zoneCM = this.zone > 0 ? (double)(6 * this.zone) - 183.0 : 3.0;
            longitude = this.zoneCM - this._a3;
            if (hemisphere.equals("S")) {
                latitude = -latitude;
            }
            latlon[0] = latitude;
            latlon[1] = longitude;
            return latlon;
        }

        protected void setVariables() {
            this.arc = this.northing / this.k0;
            this.mu = this.arc / (this.a * (1.0 - CoordinateConversion.this.POW(this.e, 2.0) / 4.0 - 3.0 * CoordinateConversion.this.POW(this.e, 4.0) / 64.0 - 5.0 * CoordinateConversion.this.POW(this.e, 6.0) / 256.0));
            this.ei = (1.0 - CoordinateConversion.this.POW(1.0 - this.e * this.e, 0.5)) / (1.0 + CoordinateConversion.this.POW(1.0 - this.e * this.e, 0.5));
            this.ca = 3.0 * this.ei / 2.0 - 27.0 * CoordinateConversion.this.POW(this.ei, 3.0) / 32.0;
            this.cb = 21.0 * CoordinateConversion.this.POW(this.ei, 2.0) / 16.0 - 55.0 * CoordinateConversion.this.POW(this.ei, 4.0) / 32.0;
            this.cc = 151.0 * CoordinateConversion.this.POW(this.ei, 3.0) / 96.0;
            this.cd = 1097.0 * CoordinateConversion.this.POW(this.ei, 4.0) / 512.0;
            this.phi1 = this.mu + this.ca * CoordinateConversion.this.SIN(2.0 * this.mu) + this.cb * CoordinateConversion.this.SIN(4.0 * this.mu) + this.cc * CoordinateConversion.this.SIN(6.0 * this.mu) + this.cd * CoordinateConversion.this.SIN(8.0 * this.mu);
            this.n0 = this.a / CoordinateConversion.this.POW(1.0 - CoordinateConversion.this.POW(this.e * CoordinateConversion.this.SIN(this.phi1), 2.0), 0.5);
            this.r0 = this.a * (1.0 - this.e * this.e) / CoordinateConversion.this.POW(1.0 - CoordinateConversion.this.POW(this.e * CoordinateConversion.this.SIN(this.phi1), 2.0), 1.5);
            this.fact1 = this.n0 * CoordinateConversion.this.TAN(this.phi1) / this.r0;
            this._a1 = 500000.0 - this.easting;
            this.dd0 = this._a1 / (this.n0 * this.k0);
            this.fact2 = this.dd0 * this.dd0 / 2.0;
            this.t0 = CoordinateConversion.this.POW(CoordinateConversion.this.TAN(this.phi1), 2.0);
            this.Q0 = this.e1sq * CoordinateConversion.this.POW(CoordinateConversion.this.COS(this.phi1), 2.0);
            this.fact3 = (5.0 + 3.0 * this.t0 + 10.0 * this.Q0 - 4.0 * this.Q0 * this.Q0 - 9.0 * this.e1sq) * CoordinateConversion.this.POW(this.dd0, 4.0) / 24.0;
            this.fact4 = (61.0 + 90.0 * this.t0 + 298.0 * this.Q0 + 45.0 * this.t0 * this.t0 - 252.0 * this.e1sq - 3.0 * this.Q0 * this.Q0) * CoordinateConversion.this.POW(this.dd0, 6.0) / 720.0;
            this.lof1 = this._a1 / (this.n0 * this.k0);
            this.lof2 = (1.0 + 2.0 * this.t0 + this.Q0) * CoordinateConversion.this.POW(this.dd0, 3.0) / 6.0;
            this.lof3 = (5.0 - 2.0 * this.Q0 + 28.0 * this.t0 - 3.0 * CoordinateConversion.this.POW(this.Q0, 2.0) + 8.0 * this.e1sq + 24.0 * CoordinateConversion.this.POW(this.t0, 2.0)) * CoordinateConversion.this.POW(this.dd0, 5.0) / 120.0;
            this._a2 = (this.lof1 - this.lof2 + this.lof3) / CoordinateConversion.this.COS(this.phi1);
            this._a3 = this._a2 * 180.0 / Math.PI;
        }

        /* synthetic */ UTM2LatLon(UTM2LatLon uTM2LatLon, UTM2LatLon uTM2LatLon2) {
            this();
        }
    }
}

