/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import sim.util.Bag;
import sim.util.geo.MasonGeometry;
import swise.objects.network.GeoNode;

public class GeometryUtilities {
    public static HashMap<MasonGeometry, ArrayList<GeoNode>> mapGeoNodesToMasonGeometries(Bag masongeos, Bag nodes) {
        HashMap<MasonGeometry, ArrayList<GeoNode>> result = new HashMap<MasonGeometry, ArrayList<GeoNode>>();
        HashMap<Geometry, MasonGeometry> geos = new HashMap<Geometry, MasonGeometry>();
        for (Object o : masongeos) {
            if (!(o instanceof MasonGeometry)) {
                System.out.println("Error: object " + o + " is not a MasonGeometry and will not be mapped.");
                continue;
            }
            MasonGeometry mg = (MasonGeometry)o;
            geos.put(mg.getGeometry(), mg);
            result.put(mg, new ArrayList());
        }
        block1: for (Object o : nodes) {
            if (!(o instanceof GeoNode)) {
                System.out.println("Error: object " + o + " is not a GeoNode and will not be mapped.");
                continue;
            }
            GeoNode gn = (GeoNode)((Object)o);
            Geometry gn_n = gn.geometry;
            for (Geometry g : geos.keySet()) {
                if (!g.contains(gn_n)) continue;
                result.get(geos.get(g)).add(gn);
                continue block1;
            }
        }
        return result;
    }

    public static double cleanAngle(double angle) {
        while (angle > 360.0) {
            angle -= 360.0;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double toAngle(Coordinate from, Coordinate to) {
        return GeometryUtilities.cleanAngle(Math.toDegrees(Math.atan((to.x - from.x) / (to.y - from.y))));
    }
}

