/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import sim.field.geo.GeomGridField;
import sim.field.geo.GeomVectorField;
import sim.io.geo.ArcInfoASCGridImporter;
import sim.io.geo.ShapeFileImporter;
import sim.util.Bag;

public class InOutUtilities {
    public static void readInVectorLayer(GeomVectorField layer, String filename, String layerDescription, Bag attributes) {
        try {
            System.out.print("Reading in " + layerDescription + "...");
            File file = new File(filename);
            if (attributes == null || attributes.size() == 0) {
                ShapeFileImporter.read((URL)file.toURI().toURL(), (GeomVectorField)layer);
            } else {
                ShapeFileImporter.read((URL)file.toURI().toURL(), (GeomVectorField)layer, (Bag)attributes);
            }
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readInRasterLayer(GeomGridField layer, String filename, String layerDescription, GeomGridField.GridDataType type) {
        try {
            System.out.print("Reading in " + layerDescription + "...");
            FileInputStream fstream = new FileInputStream(filename);
            ArcInfoASCGridImporter.read((InputStream)fstream, (GeomGridField.GridDataType)type, (GeomGridField)layer);
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Coordinate readCoordinateFromFile(String s) {
        if (s.equals("")) {
            return null;
        }
        String[] bits = s.split(" ");
        Double x = Double.parseDouble(bits[1].substring(1));
        Double y = Double.parseDouble(bits[2].substring(0, bits[2].length() - 2));
        return new Coordinate(x.doubleValue(), y.doubleValue());
    }
}

