/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import sim.field.geo.GeomGridField;
import sim.field.geo.GeomVectorField;
import sim.field.grid.IntGrid2D;
import sim.io.geo.ArcInfoASCGridImporter;
import sim.io.geo.ShapeFileImporter;
import sim.util.Bag;

public class InputCleaning {
    public static Coordinate readCoordinateFromFile(String s) {
        if (s.equals("")) {
            return null;
        }
        String[] bits = s.split(" ");
        Double x = Double.parseDouble(bits[1].substring(1));
        Double y = Double.parseDouble(bits[2].substring(0, bits[2].length() - 2));
        return new Coordinate(x.doubleValue(), y.doubleValue());
    }

    public static synchronized void readInVectorLayer(GeomVectorField layer, String filename, String layerDescription, Bag attributes) {
        try {
            System.out.print("Reading in " + layerDescription + "from " + filename + "...");
            File file = new File(filename);
            if (attributes == null || attributes.size() == 0) {
                ShapeFileImporter.read((URL)file.toURL(), (GeomVectorField)layer);
            } else {
                ShapeFileImporter.read((URL)file.toURL(), (GeomVectorField)layer, (Bag)attributes);
            }
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void readInRasterLayer(GeomGridField layer, String filename, String layerDescription, GeomGridField.GridDataType type) {
        try {
            System.out.print("Reading in " + layerDescription + "from " + filename + "...");
            FileInputStream fstream = new FileInputStream(filename);
            ArcInfoASCGridImporter.read((InputStream)fstream, (GeomGridField.GridDataType)type, (GeomGridField)layer);
            fstream.close();
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void incrementHeatmap(Geometry geom, GeomGridField heatmap, Envelope MBR) {
        Point p = geom.getCentroid();
        int x = (int)((double)heatmap.getGrid().getWidth() * (MBR.getMaxX() - p.getX()) / (MBR.getMaxX() - MBR.getMinX()));
        int y = (int)((double)heatmap.getGrid().getHeight() * (MBR.getMaxY() - p.getY()) / (MBR.getMaxY() - MBR.getMinY()));
        if (x >= 0 && y >= 0 && x < heatmap.getGrid().getWidth() && y < heatmap.getGrid().getHeight()) {
            int[] nArray = ((IntGrid2D)heatmap.getGrid()).field[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
        }
    }
}

