/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import ec.util.MersenneTwisterFast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import sim.field.continuous.Continuous2D;
import sim.field.geo.GeomVectorField;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.geo.AttributeValue;
import sim.util.geo.MasonGeometry;
import sim.util.geo.PointMoveTo;
import swise.objects.AStar;
import swise.objects.network.GeoNode;
import swise.objects.network.ListEdge;

public class NetworkUtilities {
    static GeoNode getNode(Coordinate c, Continuous2D field, GeomVectorField fields, HashMap<MasonGeometry, GeoNode[]> linkToNodeMapping, HashMap<MasonGeometry, ListEdge> geomToEdgeMapping, Network network, double resolution, GeometryFactory fa) {
        Double2D loc = new Double2D(c.x, c.y);
        Bag b = field.getObjectsWithinDistance(loc, resolution);
        if (b == null || b.size() == 0) {
            Iterator iterator;
            GeoNode node = new GeoNode((Geometry)fa.createPoint(c));
            field.setObjectLocation((Object)node, loc);
            Bag edges = fields.getObjectsWithinDistance(node.geometry, resolution);
            if (edges != null && edges.size() > 0 && (iterator = edges.iterator()).hasNext()) {
                Coordinate coord;
                Object o = iterator.next();
                MasonGeometry mg = (MasonGeometry)o;
                GeoNode[] nodes = linkToNodeMapping.get(mg);
                LineString myLine = (LineString)mg.getGeometry();
                network.removeEdge((Edge)geomToEdgeMapping.get(mg));
                GeoNode nStart = nodes[0];
                GeoNode nEnd = nodes[1];
                ArrayList<Coordinate> front = new ArrayList<Coordinate>();
                ArrayList<Coordinate> back = new ArrayList<Coordinate>();
                int index = 0;
                LineString mySegment = null;
                Coordinate lastCoord = myLine.getCoordinateN(0);
                front.add(lastCoord);
                int i = 1;
                while (i < myLine.getCoordinates().length) {
                    coord = myLine.getCoordinateN(i);
                    Coordinate[] coordinateArray = new Coordinate[]{lastCoord, coord};
                    mySegment = fa.createLineString(coordinateArray);
                    if (node.geometry.distance((Geometry)mySegment) < resolution) {
                        index = i;
                        i = myLine.getCoordinates().length;
                        front.add(node.geometry.getCoordinate());
                        lastCoord = node.geometry.getCoordinate();
                    } else {
                        front.add(coord);
                        lastCoord = coord;
                    }
                    ++i;
                }
                back.add(node.geometry.getCoordinate());
                i = index;
                while (i < myLine.getCoordinates().length - 1) {
                    coord = myLine.getCoordinateN(i);
                    back.add(coord);
                    ++i;
                }
                back.add(nEnd.geometry.getCoordinate());
                LineString frontLine = fa.createLineString(CoordinateArrays.removeRepeatedPoints((Coordinate[])front.toArray(new Coordinate[front.size()])));
                LineString backLine = fa.createLineString(CoordinateArrays.removeRepeatedPoints((Coordinate[])back.toArray(new Coordinate[back.size()])));
                MasonGeometry newFront = new MasonGeometry((Geometry)frontLine);
                mg.geometry = backLine;
                for (String attr : mg.getAttributes().keySet()) {
                    Object value = ((AttributeValue)mg.getAttribute(attr)).getValue();
                    if (value instanceof String) {
                        newFront.addStringAttribute(attr, (String)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        newFront.addIntegerAttribute(attr, ((Integer)value).intValue());
                        continue;
                    }
                    if (value instanceof Double) {
                        newFront.addDoubleAttribute(attr, ((Double)value).doubleValue());
                        continue;
                    }
                    newFront.addAttribute(attr, value);
                }
                fields.addGeometry(newFront);
                PointMoveTo newPoint = new PointMoveTo();
                newPoint.setCoordinate(backLine.getCoordinate());
                mg.geometry.apply((CoordinateSequenceFilter)newPoint);
                mg.geometry.geometryChanged();
                linkToNodeMapping.put(newFront, new GeoNode[]{nStart, node});
                linkToNodeMapping.put(mg, new GeoNode[]{node, nEnd});
                Edge edFrontEd = new Edge((Object)nStart, (Object)node, (Object)newFront);
                ListEdge edFront = new ListEdge(edFrontEd, nStart.getGeometry().distance(node.getGeometry()));
                Edge edBackEd = new Edge((Object)node, (Object)nEnd, (Object)mg);
                ListEdge edBack = new ListEdge(edBackEd, nEnd.getGeometry().distance(node.getGeometry()));
                NetworkUtilities.testEdgeForIssues(edFront);
                NetworkUtilities.testEdgeForIssues(edBack);
                network.addEdge((Edge)edFront);
                network.addEdge((Edge)edBack);
                geomToEdgeMapping.put(newFront, edFront);
                geomToEdgeMapping.put(mg, edBack);
                return node;
            }
            return node;
        }
        return (GeoNode)((Object)b.get(0));
    }

    static void testEdgeForIssues(ListEdge e) {
        LineString ls = (LineString)((MasonGeometry)e.info).geometry;
        Coordinate c1 = ls.getCoordinateN(0);
        Coordinate c2 = ls.getCoordinateN(ls.getNumPoints() - 1);
        GeoNode g1 = (GeoNode)((Object)e.getFrom());
        GeoNode g2 = (GeoNode)((Object)e.getTo());
        if (c1.distance(g1.geometry.getCoordinate()) > 1.0) {
            System.out.println("found you");
        }
        if (c2.distance(g2.geometry.getCoordinate()) > 1.0) {
            System.out.println("found you");
        }
    }

    static void testNetworkForIssues(Network n) {
        System.out.println("testing");
        for (Object o : n.allNodes) {
            GeoNode node = (GeoNode)((Object)o);
            for (Object p : n.getEdgesOut((Object)node)) {
                Edge e = (Edge)p;
                LineString ls = (LineString)((MasonGeometry)e.info).geometry;
                Coordinate c1 = ls.getCoordinateN(0);
                Coordinate c2 = ls.getCoordinateN(ls.getNumPoints() - 1);
                GeoNode g1 = (GeoNode)((Object)e.getFrom());
                GeoNode g2 = (GeoNode)((Object)e.getTo());
                if (c1.distance(g1.geometry.getCoordinate()) > 1.0) {
                    System.out.println("found you");
                }
                if (!(c2.distance(g2.geometry.getCoordinate()) > 1.0)) continue;
                System.out.println("found you");
            }
        }
    }

    static GeoNode checkForNode(Coordinate c, Continuous2D field, double resolution) {
        Double2D loc = new Double2D(c.x, c.y);
        Bag b = field.getObjectsWithinDistance(loc, resolution);
        if (b == null || b.size() == 0) {
            return null;
        }
        return (GeoNode)((Object)b.get(0));
    }

    public static Network multipartNetworkCleanup(GeomVectorField roadLayer, Bag roadNodes, double resolution, GeometryFactory fa, MersenneTwisterFast random, double roadWidth) {
        Continuous2D nodesInWorld = new Continuous2D(resolution, (double)roadLayer.fieldWidth, (double)roadLayer.fieldHeight);
        GeomVectorField addedRoads = new GeomVectorField();
        HashMap<MasonGeometry, GeoNode[]> linkToNodeMapping = new HashMap<MasonGeometry, GeoNode[]>();
        HashMap<MasonGeometry, ListEdge> geometryToEdgeMapping = new HashMap<MasonGeometry, ListEdge>();
        Bag geometries = roadLayer.getGeometries();
        Network net = new Network(false);
        boolean testIndex = false;
        for (Object o : geometries) {
            Coordinate[] linePts;
            LineString line;
            if (!(((MasonGeometry)o).geometry instanceof LineString) || (line = (LineString)((MasonGeometry)o).geometry).isEmpty() || (linePts = CoordinateArrays.removeRepeatedPoints((Coordinate[])line.getCoordinates())).length < 2) continue;
            Coordinate startPt = linePts[0];
            GeoNode nStart = NetworkUtilities.getNode(startPt, nodesInWorld, addedRoads, linkToNodeMapping, geometryToEdgeMapping, net, resolution, fa);
            startPt = nStart.getGeometry().getCoordinate();
            ArrayList<Coordinate> points = new ArrayList<Coordinate>();
            points.add(startPt);
            Coordinate lastPt = startPt;
            int i = 1;
            while (i < linePts.length) {
                Coordinate c = linePts[i];
                if (lastPt.distance(c) != 0.0) {
                    GeoNode thisNode = NetworkUtilities.checkForNode(c, nodesInWorld, resolution);
                    if (thisNode == null && i == linePts.length - 1) {
                        thisNode = NetworkUtilities.getNode(c, nodesInWorld, addedRoads, linkToNodeMapping, geometryToEdgeMapping, net, resolution, fa);
                    }
                    if (thisNode == null) {
                        lastPt = c;
                        points.add(c);
                    } else {
                        c = thisNode.getGeometry().getCoordinate();
                        points.add(c);
                        LineString mgLS = fa.createLineString(points.toArray(new Coordinate[points.size()]));
                        MasonGeometry mg = new MasonGeometry((Geometry)mgLS);
                        for (String attr : ((MasonGeometry)o).getAttributes().keySet()) {
                            Object value = ((AttributeValue)((MasonGeometry)o).getAttribute(attr)).getValue();
                            if (value instanceof String) {
                                mg.addStringAttribute(attr, (String)value);
                                continue;
                            }
                            if (value instanceof Integer) {
                                mg.addIntegerAttribute(attr, ((Integer)value).intValue());
                                continue;
                            }
                            if (value instanceof Double) {
                                mg.addDoubleAttribute(attr, ((Double)value).doubleValue());
                                continue;
                            }
                            mg.addAttribute(attr, value);
                        }
                        addedRoads.addGeometry(mg);
                        linkToNodeMapping.put(mg, new GeoNode[]{nStart, thisNode});
                        ListEdge ed = new ListEdge(new Edge((Object)nStart, (Object)thisNode, (Object)mg), ((LineString)mg.geometry).getLength());
                        net.addEdge((Edge)ed);
                        NetworkUtilities.testEdgeForIssues(ed);
                        geometryToEdgeMapping.put(mg, ed);
                        points = new ArrayList();
                        points.add(c);
                        nStart = thisNode;
                        startPt = c;
                        lastPt = c;
                    }
                }
                ++i;
            }
        }
        roadNodes = new Bag();
        roadNodes.addAll(NetworkUtilities.getSubcomponents(net, random));
        Bag badNodes = new Bag(net.getAllNodes());
        badNodes.removeAll((Collection)roadNodes);
        for (Object o : badNodes) {
            net.removeNode(o);
        }
        roadNodes = new Bag();
        roadNodes.addAll(net.getAllNodes());
        return net;
    }

    static Bag getSubcomponents(Network network, MersenneTwisterFast random) {
        ArrayList<Bag> subcomponents = new ArrayList<Bag>();
        int biggestIndex = -1;
        int biggestSize = -1;
        Bag nodes = new Bag(network.getAllNodes());
        int count = (int)Math.max(1.0, Math.log10(nodes.size()));
        int i = 0;
        while (i < count) {
            int s;
            GeoNode n = (GeoNode)((Object)nodes.get(random.nextInt(nodes.size())));
            HashSet<GeoNode> closedSet = new HashSet<GeoNode>();
            ArrayList<GeoNode> openSet = new ArrayList<GeoNode>();
            Bag found = new Bag();
            openSet.add(n);
            while (openSet.size() > biggestSize && openSet.size() > 0) {
                GeoNode nprime = (GeoNode)((Object)openSet.remove(openSet.size() - 1));
                found.add((Object)nprime);
                closedSet.add(nprime);
                for (Object o : network.getEdges((Object)nprime, null)) {
                    Edge e = (Edge)o;
                    GeoNode n2 = (GeoNode)((Object)e.getOtherNode((Object)nprime));
                    if (closedSet.contains((Object)n2) || openSet.contains((Object)n2)) continue;
                    openSet.add(n2);
                }
            }
            subcomponents.add(found);
            if (closedSet.size() > biggestSize) {
                biggestSize = closedSet.size();
                biggestIndex = i;
            }
            if ((s = nodes.size() - found.size()) == 0 || s < biggestSize) {
                i = count;
            }
            if ((double)found.size() < (double)nodes.size() / 2.0) {
                nodes.removeAll((Collection)found);
                i = count;
            }
            ++i;
        }
        return (Bag)subcomponents.get(biggestIndex);
    }

    public static ArrayList<Edge> findLinkTo(Network subgraph, Network all, GeoNode target, AStar astar) {
        ArrayList<GeoNode> ns = new ArrayList<GeoNode>();
        for (Object o : subgraph.getAllNodes()) {
            ns.add((GeoNode)((Object)o));
        }
        return astar.astarPath(target, ns, all);
    }

    public static void attachUnconnectedComponents(Network subgraph, Network all) {
        AStar astar = new AStar();
        ArrayList<Bag> components = NetworkUtilities.connectedComponents(subgraph);
        int i = 0;
        int j = 1;
        while (components.size() > 1 && i < components.size() - 1) {
            Bag component1 = components.get(i);
            Bag component2 = components.get(j);
            ArrayList<Edge> es = astar.astarPath((GeoNode)((Object)component1.get(0)), (GeoNode)((Object)component2.get(0)), all);
            if (es == null) {
                components.add(i, component1);
                components.add(j, component2);
                if (++j <= components.size() - 1) continue;
                j = ++i + 1;
                continue;
            }
            components.remove(j);
            components.remove(i);
            for (Edge e : es) {
                Object from = e.from();
                Object to = e.to();
                if (component1.contains(from) && component1.contains(to) || component2.contains(from) && component2.contains(to)) continue;
                subgraph.addEdge(from, to, e.info);
                if (!component1.contains(from) && !component2.contains(from)) {
                    component1.add(from);
                }
                if (component1.contains(to) || component2.contains(to)) continue;
                component1.add(to);
            }
            component1.addAll(component2);
            components.add(i, component1);
        }
    }

    public static ArrayList<Bag> connectedComponents(Network graph) {
        ArrayList<Bag> subcomponents = new ArrayList<Bag>();
        Bag nodes = new Bag(graph.getAllNodes());
        while (nodes.size() > 0) {
            Bag connected = new Bag();
            Bag toExplore = new Bag();
            Object n = nodes.remove(nodes.size() - 1);
            connected.add(n);
            toExplore.add(n);
            while (toExplore.size() > 0) {
                n = toExplore.remove(toExplore.size() - 1);
                for (Object o : graph.getEdges(n, null)) {
                    Edge e = (Edge)o;
                    Object other = null;
                    other = e.from() == n ? e.to() : e.from();
                    if (connected.contains(other)) continue;
                    connected.add(other);
                    toExplore.add(other);
                }
            }
            nodes.removeAll((Collection)connected);
            subcomponents.add(connected);
        }
        return subcomponents;
    }

    public static boolean validPath(ArrayList<Edge> path, Network network) {
        if (path == null) {
            return false;
        }
        for (Edge e : path) {
            if (!((MasonGeometry)e.info).getStringAttribute("open").equals("CLOSED")) continue;
            return false;
        }
        return true;
    }
}

