/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import ec.util.MersenneTwisterFast;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import sim.field.geo.GeomVectorField;
import sim.field.network.Network;
import sim.io.geo.ShapeFileImporter;
import sim.util.Bag;
import sim.util.distribution.Distributions;
import sim.util.geo.MasonGeometry;
import swise.objects.NetworkUtilities;
import swise.objects.network.GeoNode;
import swise.objects.network.ListEdge;

public class PopSynth {
    String censusTractFilename = "/Users/swise/Dissertation/Colorado/data/Tract_2010Census_DP1/tinyArea.shp";
    String roadsFilename = "/Users/swise/Dissertation/Colorado/data/osm_extracts/tinyRoads.shp";
    String travelToWorkFilename = "/Users/swise/Dissertation/Colorado/data/census/countyTravelToWork.csv";
    String socialMediaUsageFilename = "/Users/swise/Dissertation/Colorado/data/PewTwitterUsageStats.txt";
    Network roadNetwork;
    MersenneTwisterFast random = new MersenneTwisterFast(1234L);
    GeometryFactory gf = new GeometryFactory();
    public static double resolution = 5.0;
    public static int familyWeight = 10;
    public static int friendWeight = 5;
    public static int acquaintenceWeight = 1;
    public static int maxNumCoworkers = 35;
    double[] ageSexConstraints = null;

    public PopSynth() {
        GeomVectorField field = this.readInVectors(this.censusTractFilename);
        GeomVectorField roads = this.readInVectors(this.roadsFilename);
        this.roadNetwork = NetworkUtilities.multipartNetworkCleanup(roads, new Bag(), resolution, this.gf, this.random, 0.0);
        HashMap<MasonGeometry, ArrayList<GeoNode>> nodesTractMapping = this.getNodesTractMapping(field, this.roadNetwork);
        HashMap<MasonGeometry, ArrayList<Point>> houses = this.generateHouses(field, this.roadNetwork);
        ArrayList<ArrayList<Agent>> allHouseholds = new ArrayList<ArrayList<Agent>>();
        HashMap<String, ArrayList<ArrayList<Agent>>> householdsPerCounty = new HashMap<String, ArrayList<ArrayList<Agent>>>();
        HashMap<MasonGeometry, String> tractToCountyMapping = new HashMap<MasonGeometry, String>();
        for (Object o : field.getGeometries()) {
            MasonGeometry masonGeometry = (MasonGeometry)o;
            if (!nodesTractMapping.containsKey(masonGeometry)) continue;
            String tractName = masonGeometry.getStringAttribute("GEOID10");
            String countyName = tractName.substring(0, 5);
            tractToCountyMapping.put(masonGeometry, countyName);
            if (householdsPerCounty.containsKey(countyName)) continue;
            householdsPerCounty.put(countyName, new ArrayList());
        }
        ArrayList<Agent> allIndividuals = new ArrayList<Agent>();
        for (Object o : field.getGeometries()) {
            ArrayList<Agent> individuals;
            MasonGeometry tract = (MasonGeometry)o;
            if (!nodesTractMapping.containsKey(tract) || houses.get(tract) == null || houses.get(tract).size() == 0 || (individuals = this.generateIndividuals(tract)) == null) continue;
            ArrayList<ArrayList<Agent>> households = this.generateHouseholds(tract, (ArrayList)individuals.clone());
            this.assignHouseholdsToHouses(households, houses.get(tract));
            ArrayList<Agent> noAssignedHome = new ArrayList<Agent>();
            for (Agent a : individuals) {
                if (a.home != null) continue;
                noAssignedHome.add(a);
            }
            ArrayList<ArrayList<Agent>> emptyHouseholds = new ArrayList<ArrayList<Agent>>();
            for (ArrayList<Agent> household : households) {
                if (household.size() != 0) continue;
                emptyHouseholds.add(household);
            }
            households.removeAll(emptyHouseholds);
            individuals.removeAll(noAssignedHome);
            allIndividuals.addAll(individuals);
            householdsPerCounty.get(tractToCountyMapping.get(tract)).addAll(households);
            allHouseholds.addAll(households);
            System.out.println("Finished with " + tract.getStringAttribute("GEOID10"));
        }
        ArrayList<Agent> socialMediaUsers = this.getSocialMediaUsers(allIndividuals);
        System.out.println("Finished with picking social media users");
        this.generateWorkplaces(field, this.roadNetwork, tractToCountyMapping, householdsPerCounty);
        System.out.println("Finished with generating workplaces");
        System.gc();
        allIndividuals = new ArrayList();
        for (ArrayList arrayList : allHouseholds) {
            allIndividuals.addAll(arrayList);
        }
        this.sociallyCluster(allIndividuals, acquaintenceWeight);
        System.out.println("Finished with social clustering");
        this.sociallyMediaCluster(socialMediaUsers, acquaintenceWeight, 15.0);
        System.out.println("Finished with social media clustering");
        this.writeOutAggregated(allHouseholds);
    }

    HashMap<MasonGeometry, ArrayList<GeoNode>> getNodesTractMapping(GeomVectorField field, Network roadNetwork) {
        HashMap<MasonGeometry, ArrayList<GeoNode>> nodesTractMapping = new HashMap<MasonGeometry, ArrayList<GeoNode>>();
        for (Object o : roadNetwork.getAllNodes()) {
            GeoNode node = (GeoNode)((Object)o);
            MasonGeometry tract = this.getCovering(node, field);
            if (tract == null) continue;
            if (!nodesTractMapping.containsKey(tract)) {
                nodesTractMapping.put(tract, new ArrayList());
            }
            nodesTractMapping.get(tract).add(node);
        }
        return nodesTractMapping;
    }

    /*
     * WARNING - void declaration
     */
    public void writeOutAggregated(ArrayList<ArrayList<Agent>> households) {
        String fout = "/Users/swise/Dissertation/Colorado/TESTTINY.txt";
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(fout));
            HashMap<Agent, Agent> agentsToHouseAgents = new HashMap<Agent, Agent>();
            ArrayList<Agent> houseAgents = new ArrayList<Agent>();
            for (ArrayList<Agent> household : households) {
                Agent head;
                ArrayList<Agent> employees = new ArrayList<Agent>();
                for (Agent a : household) {
                    if (a.work == null) continue;
                    employees.add(a);
                }
                if (employees.size() == 0) {
                    int maxAge = -1;
                    Agent defaultAgent = null;
                    for (Agent agent : household) {
                        if (maxAge >= agent.age) continue;
                        maxAge = agent.age;
                        defaultAgent = agent;
                    }
                    employees.add(defaultAgent);
                }
                if (employees.size() == 0) {
                    System.out.println("synth pop problem");
                }
                if ((head = (Agent)((Object)employees.get(0))) == null) continue;
                Agent houseAgent = new Agent(head.age, head.sex);
                houseAgent.home = head.home;
                houseAgent.work = head.work;
                houseAgent.addStringAttribute("ID", head.getStringAttribute("ID"));
                houseAgents.add(houseAgent);
                for (Agent agent : household) {
                    agentsToHouseAgents.put(agent, houseAgent);
                }
            }
            for (ArrayList<Agent> household : households) {
                HashSet<Agent> connectedHouses = new HashSet<Agent>();
                HashSet<Agent> connectedMediaHouses = new HashSet<Agent>();
                for (Agent a : household) {
                    Agent bHouse;
                    for (Agent agent : a.socialTies.keySet()) {
                        if (household.contains((Object)agent) || !agentsToHouseAgents.containsKey((Object)agent)) continue;
                        bHouse = (Agent)((Object)agentsToHouseAgents.get((Object)agent));
                        connectedHouses.add(bHouse);
                    }
                    if (a.socialMediaTies == null) continue;
                    for (Agent agent : a.socialMediaTies) {
                        if (household.contains((Object)agent) || !agentsToHouseAgents.containsKey((Object)agent)) continue;
                        bHouse = (Agent)((Object)agentsToHouseAgents.get((Object)agent));
                        connectedMediaHouses.add(bHouse);
                    }
                }
                Agent thisHouse = (Agent)((Object)agentsToHouseAgents.get((Object)household.get(0)));
                for (Agent agent : connectedHouses) {
                    thisHouse.addContact(agent, friendWeight);
                }
                for (Agent agent : connectedMediaHouses) {
                    thisHouse.addMediaContact(agent);
                }
            }
            for (Agent a : houseAgents) {
                void var11_24;
                w.write(String.valueOf(a.getStringAttribute("ID")) + "\t" + a.age + "\t" + a.sex + "\t" + a.home.toString() + "\t");
                long myId = Long.parseLong(a.getStringAttribute("ID"));
                if (a.work != null) {
                    w.write(String.valueOf(a.work.toString()) + "\t");
                } else {
                    w.write("\t");
                }
                String contacts = "";
                boolean bl = false;
                for (Agent agent : a.socialTies.keySet()) {
                    if (Long.parseLong(agent.getStringAttribute("ID")) >= myId) continue;
                    contacts = String.valueOf(contacts) + agent.getStringAttribute("ID") + " " + a.socialTies.get((Object)agent) + "\t";
                    ++var11_24;
                }
                w.write(String.valueOf((int)var11_24) + "\t" + contacts);
                if (a.socialMediaTies != null) {
                    void var11_26;
                    contacts = "";
                    boolean bl2 = false;
                    for (Agent agent : a.socialMediaTies) {
                        if (Long.parseLong(agent.getStringAttribute("ID")) >= myId) continue;
                        contacts = String.valueOf(contacts) + agent.getStringAttribute("ID") + "\t";
                        ++var11_26;
                    }
                    w.write(String.valueOf((int)var11_26) + "\t" + contacts);
                }
                w.newLine();
            }
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void assignHouseholdsToHouses(ArrayList<ArrayList<Agent>> households, ArrayList<Point> houses) {
        ArrayList<Point> assignedHouses = new ArrayList<Point>();
        int numHouses = houses.size();
        if (numHouses < households.size()) {
            System.out.println("ERROR: not enough housing units given the number of households");
        }
        for (ArrayList<Agent> household : households) {
            Point assignedHouse = houses.get(this.random.nextInt(numHouses));
            while (assignedHouses.contains(assignedHouse)) {
                assignedHouse = houses.get(this.random.nextInt(numHouses));
            }
            assignedHouses.add(assignedHouse);
            for (Agent a : household) {
                a.home = assignedHouse;
            }
        }
    }

    void generateWorkplaces(GeomVectorField field, Network roadNetwork, HashMap<MasonGeometry, String> tractToCountyMapping, HashMap<String, ArrayList<ArrayList<Agent>>> householdsPerCounty) {
        HashMap countyToTractMappingCompare = new HashMap();
        for (MasonGeometry mg : tractToCountyMapping.keySet()) {
            String c = tractToCountyMapping.get(mg);
            if (!countyToTractMappingCompare.containsKey(c)) {
                countyToTractMappingCompare.put(c, new ArrayList());
            }
            ((ArrayList)countyToTractMappingCompare.get(c)).add(mg);
        }
        HashMap countyToTractMapping = new HashMap();
        for (Object o : field.getGeometries()) {
            MasonGeometry tract = (MasonGeometry)o;
            String tractName = tract.getStringAttribute("GEOID10");
            String countyName = tractName.substring(0, 5);
            if (!countyToTractMapping.containsKey(countyName)) {
                countyToTractMapping.put(countyName, new ArrayList());
            }
            ((ArrayList)countyToTractMapping.get(countyName)).add(tract);
        }
        HashMap populationFlows = new HashMap();
        HashMap<String, Double> ratioEmployed = new HashMap<String, Double>();
        try {
            String s;
            FileInputStream fstream = new FileInputStream(this.travelToWorkFilename);
            BufferedReader flowData = new BufferedReader(new InputStreamReader(fstream));
            flowData.readLine();
            while ((s = flowData.readLine()) != null) {
                String[] bits = s.split(",");
                String from = String.valueOf(bits[0]) + bits[1];
                String to = String.valueOf(bits[2].substring(1, 3)) + bits[3];
                Double count = Double.parseDouble(bits[4]);
                if (!countyToTractMapping.containsKey(from)) continue;
                if (!populationFlows.containsKey(from)) {
                    populationFlows.put(from, new HashMap());
                }
                ((HashMap)populationFlows.get(from)).put(to, count);
            }
            flowData.close();
        }
        catch (Exception e) {
            System.err.println("File input error");
        }
        if (populationFlows.keySet().size() == 0) {
            return;
        }
        for (String from : populationFlows.keySet()) {
            double totalJobs = 0.0;
            for (String to : ((HashMap)populationFlows.get(from)).keySet()) {
                totalJobs += ((Double)((HashMap)populationFlows.get(from)).get(to)).doubleValue();
            }
            for (String to : ((HashMap)populationFlows.get(from)).keySet()) {
                ((HashMap)populationFlows.get(from)).put(to, (Double)((HashMap)populationFlows.get(from)).get(to) / totalJobs);
            }
            double pop = 0.0;
            for (MasonGeometry mg : (ArrayList)countyToTractMapping.get(from)) {
                pop += (double)mg.getIntegerAttribute("DP0010001").intValue();
            }
            ratioEmployed.put(from, totalJobs / pop);
        }
        HashMap nodesToCountyMapping = new HashMap();
        for (Object o : roadNetwork.getAllNodes()) {
            GeoNode node = (GeoNode)((Object)o);
            MasonGeometry tract = this.getCovering(node, field);
            String county = tractToCountyMapping.get(tract);
            if (!nodesToCountyMapping.containsKey(county)) {
                nodesToCountyMapping.put(county, new ArrayList());
            }
            ((ArrayList)nodesToCountyMapping.get(county)).add(node);
        }
        for (String county : householdsPerCounty.keySet()) {
            ArrayList households = new ArrayList(householdsPerCounty.get(county));
            if (populationFlows.get(county) == null) continue;
            int pop = 0;
            for (ArrayList household : households) {
                pop += household.size();
            }
            int numJobs = (int)((double)pop * (Double)ratioEmployed.get(county));
            ArrayList<Agent> workers = new ArrayList<Agent>();
            for (ArrayList household : households) {
                for (Agent a : household) {
                    if (a.age <= 3 || a.work != null) continue;
                    workers.add(a);
                }
            }
            HashMap jobDistribution = (HashMap)populationFlows.get(county);
            int workerSize = workers.size();
            if (workerSize == 0) {
                System.out.println("ERROR: no workers for this tract");
                continue;
            }
            int i = 0;
            while (i < numJobs) {
                String toCounty = this.getIndex(jobDistribution, this.random.nextDouble());
                ArrayList countyNodes = (ArrayList)nodesToCountyMapping.get(toCounty);
                if (countyNodes != null) {
                    Point workPoint = this.gf.createPoint(((GeoNode)((Object)countyNodes.get((int)this.random.nextInt((int)countyNodes.size())))).geometry.getCoordinate());
                    boolean unassigned = true;
                    while (unassigned) {
                        int workerIndex = this.random.nextInt(workerSize);
                        Agent a = (Agent)((Object)workers.get(workerIndex));
                        if (a.age <= 3 || a.work != null) continue;
                        a.work = workPoint;
                        workers.remove(workerIndex);
                        unassigned = false;
                        --workerSize;
                    }
                    if (workers.size() == 0) {
                        i = numJobs + 1;
                    }
                }
                ++i;
            }
        }
    }

    HashMap<MasonGeometry, ArrayList<Point>> generateHouses(GeomVectorField field, Network roadNetwork) {
        HashMap<MasonGeometry, ArrayList<Point>> result = new HashMap<MasonGeometry, ArrayList<Point>>();
        HashMap<GeoNode, MasonGeometry> nodesTractMapping = new HashMap<GeoNode, MasonGeometry>();
        HashMap edgesTractMapping = new HashMap();
        for (Object o : roadNetwork.getAllNodes()) {
            GeoNode node = (GeoNode)((Object)o);
            MasonGeometry tract = (MasonGeometry)nodesTractMapping.get((Object)node);
            if (tract == null) {
                tract = this.getCovering(node, field);
                nodesTractMapping.put(node, tract);
            }
            if (tract == null) continue;
            for (Object p : roadNetwork.getEdgesOut((Object)node)) {
                MasonGeometry otherTract;
                ListEdge edge = (ListEdge)((Object)p);
                String type = ((MasonGeometry)edge.getInfo()).getStringAttribute("TYPE");
                if (!type.equals("residential")) continue;
                GeoNode otherNode = (GeoNode)((Object)edge.getTo());
                if (otherNode == node) {
                    otherNode = (GeoNode)((Object)edge.getFrom());
                }
                if ((otherTract = (MasonGeometry)nodesTractMapping.get((Object)otherNode)) == null) {
                    otherTract = this.getCovering(otherNode, field);
                    nodesTractMapping.put(otherNode, otherTract);
                }
                if (otherTract == null || otherTract != tract) continue;
                if (edgesTractMapping.get(tract) == null) {
                    edgesTractMapping.put(tract, new ArrayList());
                }
                ((ArrayList)edgesTractMapping.get(tract)).add(edge);
            }
        }
        for (Object o : field.getGeometries()) {
            MasonGeometry tract = (MasonGeometry)o;
            if (!edgesTractMapping.containsKey(tract)) continue;
            double residentialRoadLength = 0.0;
            ArrayList<ListEdge> residentialRoads = new ArrayList<ListEdge>();
            for (ListEdge e : (ArrayList)edgesTractMapping.get(tract)) {
                String type = ((MasonGeometry)e.info).getStringAttribute("TYPE");
                if (!type.equals("residential")) continue;
                Geometry gm = ((MasonGeometry)e.info).geometry;
                residentialRoadLength += ((MasonGeometry)e.info).geometry.getLength();
                residentialRoads.add(e);
            }
            int numHouses = tract.getIntegerAttribute("DP0180001");
            double houseSpacing = residentialRoadLength / (double)numHouses;
            ArrayList<Point> houses = new ArrayList<Point>();
            for (ListEdge e : residentialRoads) {
                LineString ls = (LineString)((MasonGeometry)e.info).geometry;
                LengthIndexedLine segment = new LengthIndexedLine((Geometry)ls);
                double startIndex = segment.getStartIndex();
                double endIndex = segment.getEndIndex();
                double i = startIndex;
                while (i < endIndex) {
                    Point house1 = this.gf.createPoint(segment.extractPoint(i));
                    houses.add(house1);
                    i += houseSpacing;
                }
            }
            result.put(tract, houses);
        }
        return result;
    }

    MasonGeometry getCovering(MasonGeometry g, GeomVectorField field) {
        Bag geos = field.getCoveringObjects(g);
        if (geos == null || geos.size() == 0) {
            System.out.println("Geometry Error: no field contains this geometry");
            return null;
        }
        return (MasonGeometry)geos.get(0);
    }

    double[] getAgeSexConstraints(MasonGeometry tract) {
        int value;
        String attribute;
        double[] ageSexConstraints = new double[36];
        double total = 0.0;
        String prefix = "DP00100";
        int index = 0;
        int i = 21;
        while (i < 39) {
            attribute = String.valueOf(prefix) + i;
            value = tract.getIntegerAttribute(attribute);
            ageSexConstraints[index] = value;
            ++index;
            total += (double)value;
            ++i;
        }
        i = 40;
        while (i < 58) {
            attribute = String.valueOf(prefix) + i;
            value = tract.getIntegerAttribute(attribute);
            ageSexConstraints[index] = value;
            ++index;
            total += (double)value;
            ++i;
        }
        i = 0;
        while (i < 36) {
            int n = i++;
            ageSexConstraints[n] = ageSexConstraints[n] / total;
        }
        return ageSexConstraints;
    }

    ArrayList<Agent> generateIndividuals(MasonGeometry area) {
        double[] ageSexConstraints = this.getAgeSexConstraints(area);
        ArrayList<Agent> individuals = new ArrayList<Agent>();
        int totalPop = area.getIntegerAttribute("DP0010001");
        if (totalPop == 0) {
            return null;
        }
        totalPop = Math.min(totalPop, 30);
        int i = 0;
        while (i < totalPop) {
            double val = this.random.nextDouble();
            int index = this.getIndex(ageSexConstraints, val);
            int sex = index / 18;
            int age = index % 18;
            Agent a = new Agent(age, sex);
            individuals.add(a);
            ++i;
        }
        this.ageSexConstraints = ageSexConstraints;
        return individuals;
    }

    double[] getHouseholdConstraints(MasonGeometry tract) {
        double[] householdConstraints = new double[16];
        String prefix = "DP01300";
        int i = 1;
        while (i < 16) {
            String attribute = prefix;
            if (i < 10) {
                attribute = String.valueOf(attribute) + 0;
            }
            attribute = String.valueOf(attribute) + i;
            householdConstraints[i] = tract.getIntegerAttribute(attribute).intValue();
            ++i;
        }
        double[] householdRatios = new double[12];
        householdRatios[0] = householdConstraints[4] - householdConstraints[5];
        householdRatios[1] = householdConstraints[5];
        householdRatios[2] = householdConstraints[6] - householdConstraints[7];
        householdRatios[3] = householdConstraints[7];
        householdRatios[4] = householdConstraints[8] - householdConstraints[9];
        householdRatios[5] = householdConstraints[9];
        householdRatios[6] = householdConstraints[10] - householdConstraints[11];
        householdRatios[7] = householdConstraints[12] - householdConstraints[13];
        householdRatios[8] = householdConstraints[13];
        householdRatios[9] = householdConstraints[14] - householdConstraints[15];
        householdRatios[10] = householdConstraints[15];
        int i2 = 0;
        while (i2 < 11) {
            int n = i2++;
            householdRatios[n] = householdRatios[n] / householdConstraints[1];
        }
        return householdRatios;
    }

    /*
     * WARNING - void declaration
     */
    ArrayList<ArrayList<Agent>> generateHouseholds(MasonGeometry area, ArrayList<Agent> individuals) {
        int j;
        int i;
        Object a;
        ArrayList<ArrayList<Agent>> allHouseholds = new ArrayList<ArrayList<Agent>>();
        ArrayList<ArrayList<Agent>> familyHouseholds = new ArrayList<ArrayList<Agent>>();
        double[] householdTypeRatios = this.getHouseholdConstraints(area);
        int popInGroupQuarters = area.getIntegerAttribute("DP0120014");
        ArrayList<Agent> groupPopulation = new ArrayList<Agent>();
        int i2 = 0;
        while (i2 < Math.min(individuals.size(), popInGroupQuarters)) {
            groupPopulation.add(individuals.remove(this.random.nextInt(individuals.size())));
            ++i2;
        }
        int numHouseholds = area.getIntegerAttribute("DP0130001");
        int i3 = 0;
        while (i3 < numHouseholds) {
            if (individuals.size() != 0) {
                ArrayList arrayList = new ArrayList();
                double val = this.random.nextDouble();
                int index = this.getIndex(householdTypeRatios, val);
                int hh1 = -1;
                int hh2 = -1;
                int numChildren = 0;
                boolean under18 = false;
                boolean over65 = false;
                boolean familyGroup = true;
                switch (index) {
                    case 0: {
                        hh1 = 0;
                        hh2 = 1;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 1: {
                        hh1 = 0;
                        hh2 = 1;
                        under18 = true;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 2: {
                        hh1 = 0;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 3: {
                        hh1 = 0;
                        under18 = true;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 4: {
                        hh1 = 1;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 5: {
                        hh1 = 1;
                        under18 = true;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 6: {
                        familyGroup = false;
                        break;
                    }
                    case 7: {
                        hh1 = 0;
                        familyGroup = false;
                        break;
                    }
                    case 8: {
                        hh1 = 0;
                        familyGroup = false;
                        over65 = true;
                        break;
                    }
                    case 9: {
                        hh1 = 1;
                        familyGroup = false;
                        break;
                    }
                    case 10: {
                        hh1 = 1;
                        familyGroup = false;
                        over65 = true;
                    }
                }
                int spouseAge = -1;
                int numAttempts = 1000;
                int attempts = Math.min(numAttempts, individuals.size());
                while (attempts > 0 && hh1 >= 0) {
                    a = individuals.get(this.random.nextInt(individuals.size()));
                    --attempts;
                    if (((Agent)((Object)a)).sex != hh1 || ((Agent)((Object)a)).age <= 3 || over65 && ((Agent)((Object)a)).age < 13 || !over65 && ((Agent)((Object)a)).age >= 13 || under18 && ((Agent)((Object)a)).age > 14) continue;
                    arrayList.add(a);
                    spouseAge = ((Agent)((Object)a)).age + (int)(1.5 * this.random.nextGaussian());
                    individuals.remove(a);
                    attempts = -1;
                }
                attempts = Math.min(100, individuals.size());
                while (attempts > 0 && hh2 >= 0) {
                    a = individuals.get(this.random.nextInt(individuals.size()));
                    if (((Agent)((Object)a)).sex == hh2 && ((Agent)((Object)a)).age == spouseAge) {
                        arrayList.add(a);
                        individuals.remove(a);
                        attempts = -1;
                    }
                    --attempts;
                }
                if (numChildren > 0) {
                    int minAge = 17;
                    int maxAge = 0;
                    for (Agent member : arrayList) {
                        if (member.age > maxAge) {
                            maxAge = member.age;
                        }
                        if (member.age >= minAge) continue;
                        minAge = member.age;
                    }
                    int maxChildAge = minAge - 3;
                    int minChildAge = Math.max(0, maxAge - 9);
                    attempts = Math.min(numAttempts * numChildren, individuals.size());
                    int previousChildAge = -1;
                    int fulfilled = 0;
                    while (attempts > 0 && fulfilled < numChildren) {
                        --attempts;
                        a = individuals.get(this.random.nextInt(individuals.size()));
                        if (under18 && ((Agent)((Object)a)).age > 4 && fulfilled == 0 || ((Agent)((Object)a)).age < minChildAge || ((Agent)((Object)a)).age > maxChildAge || (double)Math.abs(((Agent)((Object)a)).age - previousChildAge) > Math.abs(this.random.nextGaussian())) continue;
                        arrayList.add(a);
                        individuals.remove(a);
                        ++fulfilled;
                        previousChildAge = ((Agent)((Object)a)).age;
                    }
                }
                if (hh1 == -1 && hh2 == -1 && !familyGroup) {
                    attempts = Math.min(numAttempts, individuals.size());
                    int numMembers = this.otherAdultsDistribution();
                    int fulfilled = 0;
                    while (attempts > 0 && fulfilled < numMembers) {
                        a = individuals.get(this.random.nextInt(individuals.size()));
                        if (((Agent)((Object)a)).age > 4) {
                            arrayList.add(a);
                            individuals.remove(a);
                            ++fulfilled;
                        }
                        --attempts;
                    }
                }
                if (arrayList.size() > 0) {
                    if (familyGroup) {
                        familyHouseholds.add(arrayList);
                    } else {
                        allHouseholds.add(arrayList);
                    }
                } else {
                    --i3;
                }
            }
            ++i3;
        }
        int leftoverIndividualsToAllocate = individuals.size();
        while (leftoverIndividualsToAllocate > 0) {
            Agent agent = individuals.remove(this.random.nextInt(leftoverIndividualsToAllocate));
            ((ArrayList)familyHouseholds.get(this.random.nextInt(familyHouseholds.size()))).add(agent);
            --leftoverIndividualsToAllocate;
        }
        for (ArrayList arrayList : familyHouseholds) {
            int weight = familyWeight;
            i = 0;
            while (i < arrayList.size() - 1) {
                j = i + 1;
                while (j < arrayList.size()) {
                    ((Agent)((Object)arrayList.get(i))).addContact((Agent)((Object)arrayList.get(j)), weight);
                    ((Agent)((Object)arrayList.get(j))).addContact((Agent)((Object)arrayList.get(i)), weight);
                    ++j;
                }
                ++i;
            }
        }
        for (ArrayList arrayList : allHouseholds) {
            int weight = friendWeight;
            i = 0;
            while (i < arrayList.size() - 1) {
                j = i + 1;
                while (j < arrayList.size()) {
                    ((Agent)((Object)arrayList.get(i))).addContact((Agent)((Object)arrayList.get(j)), weight);
                    ((Agent)((Object)arrayList.get(j))).addContact((Agent)((Object)arrayList.get(i)), weight);
                    ++j;
                }
                ++i;
            }
        }
        if (groupPopulation.size() > 10) {
            this.sociallyCluster(groupPopulation, acquaintenceWeight);
        } else {
            void var10_18;
            boolean bl = false;
            while (var10_18 < groupPopulation.size()) {
                a = groupPopulation.get((int)var10_18);
                void j2 = var10_18 + true;
                while (j2 < groupPopulation.size()) {
                    Agent b = groupPopulation.get((int)j2);
                    ((Agent)((Object)a)).addContact(b, acquaintenceWeight);
                    b.addContact((Agent)((Object)a), acquaintenceWeight);
                    ++j2;
                }
                ++var10_18;
            }
        }
        allHouseholds.addAll(familyHouseholds);
        this.fitOfHouseholds(area, allHouseholds, familyHouseholds);
        if (groupPopulation.size() > 0) {
            allHouseholds.add(groupPopulation);
        }
        return allHouseholds;
    }

    ArrayList<ArrayList<Agent>> generateSubsetOfHouseholds(MasonGeometry area, ArrayList<Agent> individuals) {
        ArrayList<ArrayList<Agent>> allHouseholds = new ArrayList<ArrayList<Agent>>();
        ArrayList familyHouseholds = new ArrayList();
        double[] householdTypeRatios = this.getHouseholdConstraints(area);
        int numHouseholds = area.getIntegerAttribute("DP0130001");
        int i = 0;
        while (i < Math.min(numHouseholds, 10)) {
            if (individuals.size() != 0) {
                Agent a;
                ArrayList<Agent> arrayList = new ArrayList<Agent>();
                double val = this.random.nextDouble();
                int index = this.getIndex(householdTypeRatios, val);
                int hh1 = -1;
                int hh2 = -1;
                int numChildren = 0;
                boolean under18 = false;
                boolean over65 = false;
                boolean familyGroup = true;
                switch (index) {
                    case 0: {
                        hh1 = 0;
                        hh2 = 1;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 1: {
                        hh1 = 0;
                        hh2 = 1;
                        under18 = true;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 2: {
                        hh1 = 0;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 3: {
                        hh1 = 0;
                        under18 = true;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 4: {
                        hh1 = 1;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 5: {
                        hh1 = 0;
                        under18 = true;
                        numChildren = this.ownChildrenDistribution();
                        break;
                    }
                    case 6: {
                        familyGroup = false;
                        break;
                    }
                    case 7: {
                        hh1 = 0;
                        familyGroup = false;
                        break;
                    }
                    case 8: {
                        hh1 = 0;
                        familyGroup = false;
                        over65 = true;
                        break;
                    }
                    case 9: {
                        hh1 = 1;
                        familyGroup = false;
                        break;
                    }
                    case 10: {
                        hh1 = 1;
                        familyGroup = false;
                        over65 = true;
                    }
                }
                int spouseAge = -1;
                int numAttempts = 1000;
                int attempts = Math.min(numAttempts, individuals.size());
                while (attempts > 0 && hh1 >= 0) {
                    a = individuals.get(this.random.nextInt(individuals.size()));
                    if (a.sex == hh1 && a.age > 3) {
                        if (over65 && a.age < 13 || !over65 && a.age >= 13 || under18 && a.age > 14) continue;
                        arrayList.add(a);
                        spouseAge = a.age + (int)(1.5 * this.random.nextGaussian());
                        individuals.remove((Object)a);
                        attempts = -1;
                    }
                    --attempts;
                }
                attempts = Math.min(100, individuals.size());
                while (attempts > 0 && hh2 >= 0) {
                    a = individuals.get(this.random.nextInt(individuals.size()));
                    if (a.sex == hh2 && a.age == spouseAge) {
                        arrayList.add(a);
                        individuals.remove((Object)a);
                        attempts = -1;
                    }
                    --attempts;
                }
                if (numChildren > 0) {
                    int minAge = 17;
                    int maxAge = 0;
                    for (Agent member : arrayList) {
                        if (member.age > maxAge) {
                            maxAge = member.age;
                        }
                        if (member.age >= minAge) continue;
                        minAge = member.age;
                    }
                    int maxChildAge = minAge - 3;
                    int minChildAge = Math.max(0, maxAge - 9);
                    attempts = Math.min(numAttempts * numChildren, individuals.size());
                    int previousChildAge = -1;
                    int fulfilled = 0;
                    while (attempts > 0 && fulfilled < numChildren) {
                        --attempts;
                        a = individuals.get(this.random.nextInt(individuals.size()));
                        if (under18 && a.age > 4 && fulfilled == 0 || a.age < minChildAge || a.age > maxChildAge || (double)Math.abs(a.age - previousChildAge) > Math.abs(this.random.nextGaussian())) continue;
                        arrayList.add(a);
                        individuals.remove((Object)a);
                        ++fulfilled;
                        previousChildAge = a.age;
                    }
                }
                if (hh1 == -1 && hh2 == -1 && !familyGroup) {
                    attempts = Math.min(numAttempts, individuals.size());
                    int numMembers = this.otherAdultsDistribution();
                    int fulfilled = 0;
                    while (attempts > 0 && fulfilled < numMembers) {
                        a = individuals.get(this.random.nextInt(individuals.size()));
                        if (a.age > 4) {
                            arrayList.add(a);
                            individuals.remove((Object)a);
                            ++fulfilled;
                        }
                        --attempts;
                    }
                }
                if (arrayList.size() > 0) {
                    if (familyGroup) {
                        familyHouseholds.add(arrayList);
                    } else {
                        allHouseholds.add(arrayList);
                    }
                } else {
                    --i;
                }
            }
            ++i;
        }
        allHouseholds.addAll(familyHouseholds);
        ArrayList<Agent> copyOfIndividuals = new ArrayList<Agent>();
        for (ArrayList arrayList : allHouseholds) {
            for (Agent a : arrayList) {
                copyOfIndividuals.add(a);
            }
        }
        return allHouseholds;
    }

    void sociallyCluster(ArrayList<Agent> individuals, int weight) {
        int numConnections;
        int indexy = -1;
        HashMap<Agent, Integer> assignedFriends = new HashMap<Agent, Integer>();
        for (Agent a : individuals) {
            numConnections = 103 - (int)Distributions.nextPowLaw((double)6.0, (double)100.0, (MersenneTwisterFast)this.random);
            assignedFriends.put(a, numConnections);
            if (++indexy % 100 != 0) continue;
            System.out.println(String.valueOf(indexy) + " out of " + individuals.size() + " distrib. assigned...");
        }
        indexy = -1;
        for (Agent a : individuals) {
            Agent b;
            if (++indexy % 100 == 0) {
                System.out.println(String.valueOf(indexy) + " out of " + individuals.size());
            }
            if ((numConnections = (Integer)assignedFriends.get((Object)a) - a.socialTies.size()) <= 0) continue;
            HashMap<Agent, Double> socialTree = new HashMap<Agent, Double>();
            for (Agent b2 : a.socialTies.keySet()) {
                for (Agent c : b2.socialTies.keySet()) {
                    if (c == a || a.socialTies.containsKey((Object)c) || c.socialTies.size() >= (Integer)assignedFriends.get((Object)c)) continue;
                    double distance = a.getSocialDistance(c);
                    socialTree.put(c, distance);
                }
            }
            int i = socialTree.size();
            while (i < numConnections + 100) {
                b = individuals.get(this.random.nextInt(individuals.size()));
                if (b != a && !a.socialTies.containsKey((Object)b) && !socialTree.containsKey((Object)b) && b.socialTies.size() < (Integer)assignedFriends.get((Object)b)) {
                    double distance = a.getSocialDistance(b);
                    socialTree.put(b, distance);
                }
                ++i;
            }
            i = 0;
            while (i < numConnections) {
                b = this.getMin(socialTree);
                if (b != null) {
                    a.addContact(b, weight);
                    b.addContact(a, weight);
                    socialTree.remove((Object)b);
                }
                ++i;
            }
        }
    }

    void sociallyMediaCluster(ArrayList<Agent> individuals, int weight, double averageDegree) {
        int numConnections;
        HashMap<Agent, Integer> assignedFriends = new HashMap<Agent, Integer>();
        for (Agent a : individuals) {
            numConnections = 103 - (int)Distributions.nextPowLaw((double)6.0, (double)100.0, (MersenneTwisterFast)this.random);
            assignedFriends.put(a, numConnections);
        }
        for (Agent a : individuals) {
            Agent b;
            numConnections = 105 - (int)Distributions.nextPowLaw((double)6.0, (double)100.0, (MersenneTwisterFast)this.random) - a.socialMediaTies.size();
            HashMap<Agent, Double> socialTree = new HashMap<Agent, Double>();
            for (Agent b2 : a.socialTies.keySet()) {
                for (Agent c : b2.socialTies.keySet()) {
                    if (c == a || c.socialMediaTies == null || a.socialMediaTies.contains((Object)c) || c.socialMediaTies.size() >= (Integer)assignedFriends.get((Object)c)) continue;
                    double distance = a.getSocialDistance(c);
                    socialTree.put(c, distance);
                }
            }
            int i = socialTree.size();
            while (i < numConnections + 100) {
                b = individuals.get(this.random.nextInt(individuals.size()));
                if (b != a && !a.socialMediaTies.contains((Object)b) && b.socialMediaTies.size() >= (Integer)assignedFriends.get((Object)b)) {
                    double distance = a.getSocialDistance(b);
                    socialTree.put(b, distance);
                }
                ++i;
            }
            i = 0;
            while (i < numConnections) {
                b = this.getMin(socialTree);
                if (b != null) {
                    a.addMediaContact(b);
                    socialTree.remove((Object)b);
                }
                ++i;
            }
        }
    }

    Agent getMin(HashMap<Agent, Double> map) {
        double minVal = Double.MAX_VALUE;
        Agent best = null;
        for (Agent a : map.keySet()) {
            if (!(map.get((Object)a) < minVal)) continue;
            minVal = map.get((Object)a);
            best = a;
        }
        return best;
    }

    int ownChildrenDistribution() {
        return this.random.nextInt(2) + 1;
    }

    int otherAdultsDistribution() {
        return this.random.nextInt(2) + 2;
    }

    double fitIndividuals(ArrayList<Agent> individuals, double[] ageSexConstraints) {
        double[] counts = new double[ageSexConstraints.length];
        int ageCategories = ageSexConstraints.length / 2;
        for (Agent a : individuals) {
            int index;
            int n = index = ageCategories * a.sex + a.age;
            counts[n] = counts[n] + 1.0;
        }
        double total = 0.0;
        double totalPop = individuals.size();
        int i = 0;
        while (i < ageSexConstraints.length) {
            double expected = totalPop * ageSexConstraints[i];
            if (expected == 0.0) {
                expected = 0.001;
            }
            total += Math.pow(counts[i] - expected, 2.0) / expected;
            ++i;
        }
        return total;
    }

    void fitOfHouseholds(MasonGeometry area, ArrayList<ArrayList<Agent>> households, ArrayList<ArrayList<Agent>> familyHouseholds) {
        int peopleInFamily = 0;
        int peopleInHouseholds = 0;
        int householdsUnder18 = 0;
        int householdsOver65 = 0;
        ArrayList<Agent> individuals = new ArrayList<Agent>();
        for (ArrayList<Agent> h : households) {
            if (h.size() == 0) {
                System.out.print("EMPTY HOUSE");
            }
            if (familyHouseholds.contains(h)) {
                peopleInFamily += h.size();
            }
            peopleInHouseholds += h.size();
            boolean under18 = false;
            boolean over65 = false;
            for (Agent ha : h) {
                if (ha.age < 4) {
                    under18 = true;
                }
                if (ha.age > 12) {
                    over65 = true;
                }
                individuals.add(ha);
            }
            if (under18) {
                ++householdsUnder18;
            }
            if (!over65) continue;
            ++householdsOver65;
        }
        System.out.print(String.valueOf(area.getStringAttribute("NAMELSAD10")) + "\t");
        System.out.print(String.valueOf(individuals.size()) + "\t" + area.getIntegerAttribute("DP0120002") + "\t" + area.getIntegerAttribute("DP0120014") + "\t");
        System.out.print(String.valueOf(households.size()) + "\t" + area.getIntegerAttribute("DP0130001") + "\t");
        System.out.print(String.valueOf((double)peopleInFamily / (double)familyHouseholds.size()) + "\t" + area.getDoubleAttribute("DP0170001") + "\t");
        System.out.print(String.valueOf((double)peopleInHouseholds / (double)households.size()) + "\t" + area.getDoubleAttribute("DP0160001") + "\t");
        System.out.print(String.valueOf(householdsUnder18) + "\t" + area.getIntegerAttribute("DP0140001") + "\t");
        System.out.print(String.valueOf(householdsOver65) + "\t" + area.getIntegerAttribute("DP0150001") + "\t");
        System.out.println(this.fitIndividuals(individuals, this.getAgeSexConstraints(area)));
    }

    int getIndex(double[] vals, double val) {
        double count = 0.0;
        int j = 0;
        while (j < vals.length) {
            if (val <= (count += vals[j])) {
                return j;
            }
            ++j;
        }
        return vals.length - 1;
    }

    String getIndex(HashMap<String, Double> distribution, double val) {
        double count = 0.0;
        for (String index : distribution.keySet()) {
            if (!(val <= (count += distribution.get(index).doubleValue()))) continue;
            return index;
        }
        return null;
    }

    GeomVectorField readInVectors(String filename) {
        GeomVectorField field = new GeomVectorField();
        try {
            System.out.print("Reading in file...");
            File file = new File(filename);
            ShapeFileImporter.read((URL)file.toURL(), (GeomVectorField)field);
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return field;
    }

    double[] getSumByCol(double[] popMatrix) {
        double[] result = new double[18];
        int i = 0;
        while (i < result.length) {
            result[i] = popMatrix[i] + popMatrix[i + 18];
            ++i;
        }
        return result;
    }

    double[] getSumByRow(double[] popMatrix) {
        double[] result = new double[2];
        int i = 0;
        while (i < popMatrix.length) {
            int n = (int)Math.floor(i / 18);
            result[n] = result[n] + popMatrix[i];
            ++i;
        }
        return result;
    }

    ArrayList<Agent> getSocialMediaUsers(ArrayList<Agent> individuals) {
        try {
            double[] ageSexPopConstraints = new double[36];
            for (Agent a : individuals) {
                int aIndex;
                int n = aIndex = a.age + a.sex * 18;
                ageSexPopConstraints[n] = ageSexPopConstraints[n] + 1.0;
            }
            double[] totalPopSexCounts = this.getSumByRow(ageSexPopConstraints);
            double[] totalPopAgeCounts = this.getSumByCol(ageSexPopConstraints);
            FileInputStream fstream = new FileInputStream(this.socialMediaUsageFilename);
            BufferedReader d = new BufferedReader(new InputStreamReader(fstream));
            d.readLine();
            d.readLine();
            double[] sexSocialMediaUsageCounts = new double[2];
            String s = d.readLine();
            String[] bits = s.split("\t");
            if (bits[0].equals("Men")) {
                sexSocialMediaUsageCounts[0] = (double)Integer.parseInt(bits[2]) * totalPopSexCounts[0] * (double)Integer.parseInt(bits[1]) / 10000.0;
            }
            if ((bits = (s = d.readLine()).split("\t"))[0].equals("Women")) {
                sexSocialMediaUsageCounts[1] = (double)Integer.parseInt(bits[2]) * totalPopSexCounts[1] * (double)Integer.parseInt(bits[1]) / 10000.0;
            }
            d.readLine();
            int index = 0;
            double[] ageSocialMediaUsageCounts = new double[18];
            while ((s = d.readLine()) != null) {
                bits = s.split("\t");
                int minAgeInGroup = (int)Math.floor(Integer.parseInt(bits[0]) / 5);
                int maxAgeInGroup = (int)Math.floor(Integer.parseInt(bits[1]) / 5);
                while (index < minAgeInGroup) {
                    ageSocialMediaUsageCounts[index] = 0.0;
                    ++index;
                }
                double perHundredSocialMedia = (double)(Integer.parseInt(bits[3]) * Integer.parseInt(bits[2])) / 10000.0;
                while (index <= maxAgeInGroup) {
                    ageSocialMediaUsageCounts[index] = perHundredSocialMedia * totalPopAgeCounts[index];
                    ++index;
                }
            }
            while (index < 18) {
                ageSocialMediaUsageCounts[index] = 0.0;
                ++index;
            }
            double[] oldRatios = new double[36];
            double[] newCounts = new double[36];
            double initialVal = (totalPopSexCounts[0] + totalPopSexCounts[1]) / 36.0;
            int i = 0;
            while (i < 36) {
                newCounts[i] = initialVal;
                ++i;
            }
            boolean finished = false;
            block8: while (!finished) {
                int j;
                int j2;
                oldRatios = newCounts;
                newCounts = new double[36];
                double[] currentSexSizes = new double[2];
                int i2 = 0;
                while (i2 < currentSexSizes.length) {
                    j2 = 0;
                    while (j2 < 18) {
                        int n = i2;
                        currentSexSizes[n] = currentSexSizes[n] + oldRatios[j2 + i2 * 18];
                        ++j2;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < currentSexSizes.length) {
                    j2 = 0;
                    while (j2 < 18) {
                        newCounts[j2 + i2 * 18] = oldRatios[j2 + i2 * 18] / currentSexSizes[i2] * sexSocialMediaUsageCounts[i2];
                        ++j2;
                    }
                    ++i2;
                }
                double[] currentAgeSizes = new double[18];
                int i3 = 0;
                while (i3 < currentAgeSizes.length) {
                    j = 0;
                    while (j < 2) {
                        int n = i3;
                        currentAgeSizes[n] = currentAgeSizes[n] + oldRatios[i3 + j * 18];
                        ++j;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < currentAgeSizes.length) {
                    j = 0;
                    while (j < 2) {
                        newCounts[i3 + j * 18] = oldRatios[i3 + j * 18] / currentAgeSizes[i3] * ageSocialMediaUsageCounts[i3];
                        ++j;
                    }
                    ++i3;
                }
                finished = true;
                i3 = 0;
                while (i3 < 36) {
                    if (Math.abs(oldRatios[i3] - newCounts[i3]) > 5.0) {
                        finished = false;
                        continue block8;
                    }
                    ++i3;
                }
            }
            d.close();
            int i4 = 0;
            while (i4 < newCounts.length) {
                int n = i4;
                newCounts[n] = newCounts[n] / ageSexPopConstraints[i4];
                ++i4;
            }
            ArrayList<Agent> socialMediaUsers = new ArrayList<Agent>();
            for (Agent a : individuals) {
                int aIndex = a.age + a.sex * 18;
                if (!(this.random.nextDouble() < newCounts[aIndex])) continue;
                a.socialMediaTies = new ArrayList();
                socialMediaUsers.add(a);
            }
            return socialMediaUsers;
        }
        catch (Exception e) {
            System.err.println("File input error");
            return null;
        }
    }

    public static void main(String[] args) {
        PopSynth newpop = new PopSynth();
    }

    class Agent
    extends MasonGeometry {
        int age;
        int sex;
        Point home;
        Point work;
        HashMap<Agent, Integer> socialTies;
        ArrayList<Agent> socialMediaTies;

        public Agent(int a, int s) {
            this.age = a;
            this.sex = s;
            this.socialTies = new HashMap();
            this.socialMediaTies = null;
            this.addStringAttribute("ID", "" + PopSynth.this.random.nextLong());
        }

        public void addContact(Agent a, int weight) {
            if (this.socialTies.containsKey((Object)a)) {
                this.socialTies.put(a, weight + this.socialTies.get((Object)a));
            } else {
                this.socialTies.put(a, weight);
            }
        }

        public void addMediaContact(Agent a) {
            if (this.socialMediaTies == null) {
                this.socialMediaTies = new ArrayList();
            }
            this.socialMediaTies.add(a);
        }

        public double getSocialDistance(Agent a) {
            double ageDiff;
            double similarity = 0.0;
            if (a.sex != this.sex) {
                similarity += 2.0;
            }
            similarity = (ageDiff = (double)(10 * (a.age - this.age) / 18)) > 0.0 ? (similarity += ageDiff) : (similarity -= ageDiff);
            if (this.home != null) {
                double distance = this.home.distance((Geometry)a.home);
                similarity += distance * 1000.0;
            }
            return Math.max(0.0, similarity);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Agent)) {
                return false;
            }
            return ((Agent)((Object)o)).getStringAttribute("ID").equals(this.getStringAttribute("ID"));
        }

        public int hashCode() {
            return this.getStringAttribute("ID").hashCode();
        }
    }
}

