/*
 * Decompiled with CFR 0.152.
 */
package swise.objects;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import sim.field.geo.GeomVectorField;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.util.Bag;
import sim.util.geo.AttributeValue;
import sim.util.geo.MasonGeometry;
import swise.objects.AStar;
import swise.objects.NetworkUtilities;
import swise.objects.network.GeoNode;
import swise.objects.network.ListEdge;

public class RoadNetworkUtilities {
    public static void connectToMajorNetwork(GeoNode n, Network subNetwork, Network roads) {
        try {
            Bag subNetNodes = (Bag)subNetwork.allNodes.clone();
            AStar pathfinder = new AStar();
            ArrayList<Edge> edges = pathfinder.astarPath(n, new ArrayList<GeoNode>((Collection<GeoNode>)subNetNodes), roads);
            if (edges == null) {
                return;
            }
            for (Edge e : edges) {
                GeoNode a = (GeoNode)((Object)e.getFrom());
                GeoNode b = (GeoNode)((Object)e.getTo());
                if (subNetwork.nodeExists((Object)a) && subNetwork.nodeExists((Object)b)) continue;
                subNetwork.addEdge((Object)a, (Object)b, e.info);
            }
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
    }

    public static void testNetworkForIssues(Network n) {
        System.out.println("testing");
        for (Object o : n.allNodes) {
            GeoNode node = (GeoNode)((Object)o);
            for (Object p : n.getEdgesOut((Object)node)) {
                Edge e = (Edge)p;
                LineString ls = (LineString)((MasonGeometry)e.info).geometry;
                Coordinate c1 = ls.getCoordinateN(0);
                Coordinate c2 = ls.getCoordinateN(ls.getNumPoints() - 1);
                GeoNode g1 = (GeoNode)((Object)e.getFrom());
                GeoNode g2 = (GeoNode)((Object)e.getTo());
                if (c1.distance(g1.geometry.getCoordinate()) > 1.0) {
                    System.out.println("found you");
                }
                if (!(c2.distance(g2.geometry.getCoordinate()) > 1.0)) continue;
                System.out.println("found you");
            }
        }
    }

    public static GeoNode getClosestGeoNode(Coordinate c, double resolution, GeomVectorField networkLayer, GeomVectorField networkEdgeLayer, GeometryFactory fa) {
        Bag objects = networkLayer.getObjectsWithinDistance((Geometry)fa.createPoint(c), resolution);
        if (objects == null || networkLayer.getGeometries().size() <= 0) {
            return null;
        }
        double bestDist = resolution;
        GeoNode best = null;
        for (Object o : objects) {
            double dist = ((GeoNode)((Object)o)).geometry.getCoordinate().distance(c);
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            best = (GeoNode)((Object)o);
        }
        if (best != null && bestDist == 0.0) {
            return best;
        }
        ListEdge edge = RoadNetworkUtilities.getClosestEdge(c, resolution, networkEdgeLayer, fa);
        if (edge == null && (edge = RoadNetworkUtilities.getClosestEdge(c, resolution * 10.0, networkEdgeLayer, fa)) == null) {
            return null;
        }
        GeoNode n1 = (GeoNode)((Object)edge.getFrom());
        GeoNode n2 = (GeoNode)((Object)edge.getTo());
        if (n1.geometry.getCoordinate().distance(c) <= n2.geometry.getCoordinate().distance(c)) {
            return n1;
        }
        return n2;
    }

    public static ListEdge getClosestEdge(Coordinate c, double resolution, GeomVectorField networkEdgeLayer, GeometryFactory fa) {
        Bag objects = networkEdgeLayer.getObjectsWithinDistance((Geometry)fa.createPoint(c), resolution);
        if (objects == null || networkEdgeLayer.getGeometries().size() <= 0) {
            return null;
        }
        Point point = fa.createPoint(c);
        double bestDist = resolution;
        ListEdge bestEdge = null;
        for (Object o : objects) {
            double dist = ((MasonGeometry)o).getGeometry().distance((Geometry)point);
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestEdge = (ListEdge)((Object)((AttributeValue)((MasonGeometry)o).getAttribute("ListEdge")).getValue());
        }
        if (bestEdge != null) {
            return bestEdge;
        }
        return null;
    }

    public static Network extractMajorRoads(Network roads) {
        Network majorRoads = new Network();
        for (Object o : roads.getAllNodes()) {
            GeoNode n = (GeoNode)((Object)o);
            for (Object p : roads.getEdgesOut((Object)n)) {
                Edge e = (Edge)p;
                String type = ((MasonGeometry)e.info).getStringAttribute("highway");
                if (!type.equals("major")) continue;
                majorRoads.addEdge(e.from(), e.to(), e.info);
            }
        }
        NetworkUtilities.attachUnconnectedComponents(majorRoads, roads);
        return majorRoads;
    }
}

