/*
 * Decompiled with CFR 0.152.
 */
package swise.objects.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import sim.field.network.Edge;
import sim.util.geo.MasonGeometry;
import swise.agents.MobileAgent;

public class ListEdge
extends Edge {
    private static final long serialVersionUID = 1L;
    ArrayList<MobileAgent> elements = new ArrayList();
    double length = 1.0;
    double width = 1.0;

    public ListEdge(Edge e) {
        super(e);
    }

    public ListEdge(Edge e, double length) {
        this(e);
        this.length = length;
    }

    public ListEdge(Edge e, double length, double width) {
        this(e, length);
        this.width = width;
    }

    public boolean equals(Object o) {
        MasonGeometry myMG;
        if (!(o instanceof ListEdge)) {
            return false;
        }
        ListEdge l = (ListEdge)((Object)o);
        if (o == this) {
            return true;
        }
        MasonGeometry mg = (MasonGeometry)l.getInfo();
        return mg == (myMG = (MasonGeometry)this.info) || mg.geometry.equals(myMG.geometry);
    }

    public int hashCode() {
        return this.from().hashCode() + this.to().hashCode() + this.info.hashCode();
    }

    public void addElement(MobileAgent o) {
        if (o.getDirection() == -1) {
            this.elements.add(o);
        } else {
            this.elements.add(0, o);
        }
    }

    public Object removeElement(MobileAgent o) {
        Boolean result = this.elements.remove((Object)o);
        this.resort();
        return result;
    }

    public void resort() {
        Collections.sort(this.elements, new Comparator<MobileAgent>(){

            @Override
            public int compare(MobileAgent o1, MobileAgent o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1.getDirection() != o2.getDirection()) {
                    if (o1.getDirection() == 1) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.getCurrentIndex() == o2.getCurrentIndex()) {
                    return 0;
                }
                if (Math.abs(o1.getCurrentIndex()) > Math.abs(o2.getCurrentIndex())) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public int numElementsOnListEdge() {
        return this.elements.size();
    }

    public double lengthPerElement() {
        return this.length * this.width / (double)Math.max(1, this.elements.size());
    }

    public int returnMyIndex(MobileAgent m) {
        return this.elements.indexOf((Object)m);
    }

    public double length() {
        return this.length;
    }

    public void setWidth(double w) {
        this.width = w;
    }

    public double width() {
        return this.width;
    }
}

