/*
 * Decompiled with CFR 0.152.
 */
package swise.visualization;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.geo.GeomInfo2D;
import sim.portrayal.geo.GeomPortrayal;
import sim.util.geo.MasonGeometry;

public class FilledPolyPortrayal
extends GeomPortrayal {
    private static final long serialVersionUID = 1L;
    public Paint outlinePaint;

    public FilledPolyPortrayal() {
        this(Color.GRAY, Color.BLACK, 1.0, true);
    }

    public FilledPolyPortrayal(Paint paint) {
        this(paint, Color.BLACK, 1.0, true);
    }

    public FilledPolyPortrayal(Paint paint, Paint outline, boolean filled) {
        this(paint, outline, 1.0, filled);
    }

    public FilledPolyPortrayal(Paint paint, Paint outline, double scale, boolean filled) {
        this.paint = paint;
        this.outlinePaint = outline;
        this.scale = scale;
        this.filled = filled;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        GeomInfo2D gInfo = info instanceof GeomInfo2D ? (GeomInfo2D)info : new GeomInfo2D(info, new AffineTransform());
        MasonGeometry gm = (MasonGeometry)object;
        Geometry geometry = gm.getGeometry();
        if (geometry.isEmpty()) {
            return;
        }
        if (this.paint != null) {
            graphics.setPaint(this.paint);
        }
        if (gm.isMovable || gm.shape == null || !gm.transform.equals(gInfo.transform)) {
            gm.transform.setTransform(gInfo.transform);
            if (geometry instanceof Point) {
                GeneralPath path;
                Point point = (Point)geometry;
                double offset = 3.0 * this.scale / 2.0;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(point.getX() - offset, point.getY() - offset, 3.0 * this.scale, 3.0 * this.scale);
                gm.shape = path = (GeneralPath)new GeneralPath(ellipse).createTransformedShape(gInfo.transform);
            } else if (geometry instanceof LineString) {
                gm.shape = this.drawGeometry(geometry, gInfo, false);
                this.filled = false;
            } else if (geometry instanceof Polygon) {
                gm.shape = this.drawPolygon((Polygon)geometry, gInfo, this.filled);
            } else if (geometry instanceof MultiLineString) {
                MultiLineString multiLine = (MultiLineString)geometry;
                int i = 0;
                while (i < multiLine.getNumGeometries()) {
                    GeneralPath p = this.drawGeometry(multiLine.getGeometryN(i), gInfo, false);
                    if (i == 0) {
                        gm.shape = p;
                    } else {
                        gm.shape.append(p, false);
                    }
                    ++i;
                }
                this.filled = false;
            } else if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                int i = 0;
                while (i < multiPolygon.getNumGeometries()) {
                    GeneralPath p = this.drawPolygon((Polygon)multiPolygon.getGeometryN(i), gInfo, this.filled);
                    if (i == 0) {
                        gm.shape = p;
                    } else {
                        gm.shape.append(p, false);
                    }
                    ++i;
                }
            } else {
                throw new UnsupportedOperationException("Unsupported JTS type for draw()" + geometry);
            }
        }
        if (this.filled) {
            graphics.fill(gm.shape);
            graphics.setPaint(this.outlinePaint);
            graphics.draw(gm.shape);
        } else {
            graphics.draw(gm.shape);
        }
    }

    GeneralPath drawPolygon(Polygon polygon, GeomInfo2D info, boolean fill) {
        GeneralPath p = this.drawGeometry((Geometry)polygon.getExteriorRing(), info, fill);
        int i = 0;
        while (i < polygon.getNumInteriorRing()) {
            p.append(this.drawGeometry((Geometry)polygon.getInteriorRingN(i), info, false), false);
            ++i;
        }
        return p;
    }

    GeneralPath drawGeometry(Geometry geom, GeomInfo2D info, boolean fill) {
        Coordinate[] coords = geom.getCoordinates();
        GeneralPath path = new GeneralPath(1, coords.length);
        path.moveTo((float)coords[0].x, (float)coords[0].y);
        int i = 1;
        while (i < coords.length) {
            path.lineTo((float)coords[i].x, (float)coords[i].y);
            ++i;
        }
        path.transform(info.transform);
        return path;
    }
}

