/*
 * Decompiled with CFR 0.152.
 */
package swise.visualization;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import sim.field.geo.GeomVectorField;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.geo.GeomInfo2D;
import sim.portrayal.geo.GeomPortrayal;
import sim.util.Bag;
import sim.util.geo.GeomPlanarGraphEdge;
import sim.util.geo.MasonGeometry;
import swise.objects.network.GeoNode;
import swise.visualization.GeomEdgeDrawInfo;

public class GeomNetworkFieldPortrayal
extends FieldPortrayal2D {
    Network network;
    private static final long serialVersionUID = 8409421628913847667L;
    GeomPortrayal defaultPortrayal = new GeomPortrayal();
    BufferedImage buffer = null;
    RenderingHints hints = null;
    HashMap<Object, LocationWrapper> selectedWrappers = new HashMap();

    public void setField(Object field, Network net) {
        if (!(field instanceof GeomVectorField)) {
            throw new RuntimeException("Invalid field for FieldPortrayal2D: " + field);
        }
        super.setField(field);
        this.network = net;
    }

    public Portrayal getPortrayalForObject(Object obj) {
        Portrayal tmp;
        if (this.portrayalForAll != null) {
            return this.portrayalForAll;
        }
        MasonGeometry mg = (MasonGeometry)obj;
        Geometry geometry = mg.getGeometry();
        Object user = mg.getUserData();
        if (user != null && user instanceof Portrayal) {
            return (Portrayal)user;
        }
        if (this.portrayalForNonNull != null) {
            return this.portrayalForNonNull;
        }
        if (this.portrayals != null && (tmp = (Portrayal)this.portrayals.get(user)) != null) {
            return tmp;
        }
        if (this.portrayals != null && (tmp = (Portrayal)this.portrayals.get(geometry)) != null) {
            return tmp;
        }
        if (user != null && this.classPortrayals != null && (tmp = (Portrayal)this.classPortrayals.get(user.getClass())) != null) {
            return tmp;
        }
        if (geometry != null && this.classPortrayals != null && (tmp = (Portrayal)this.classPortrayals.get(geometry.getClass())) != null) {
            return tmp;
        }
        if (this.portrayalForRemainder != null) {
            return this.portrayalForRemainder;
        }
        return this.getDefaultPortrayal();
    }

    public GeomNetworkFieldPortrayal() {
        this.setImmutableField(false);
    }

    public GeomNetworkFieldPortrayal(boolean immutableField) {
        this.setImmutableField(immutableField);
    }

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        if (this.field == null) {
            return;
        }
        if (graphics != null && this.immutableField && !info.precise) {
            GeomVectorField geomField = (GeomVectorField)this.field;
            double x = info.clip.x;
            double y = info.clip.y;
            boolean dirty = false;
            if (this.buffer == null || (double)this.buffer.getWidth() != info.clip.width || (double)this.buffer.getHeight() != info.clip.height || this.hints == null || !this.hints.equals(graphics.getRenderingHints())) {
                this.hints = graphics.getRenderingHints();
                this.buffer = new BufferedImage((int)info.clip.width, (int)info.clip.height, 2);
                dirty = true;
            }
            if (geomField.drawX != x || geomField.drawY != y) {
                dirty = true;
            }
            geomField.drawX = x;
            geomField.drawY = y;
            if (dirty) {
                this.clearBufferedImage(this.buffer);
                Graphics2D newGraphics = (Graphics2D)this.buffer.getGraphics();
                newGraphics.setRenderingHints(this.hints);
                this.hitOrDraw2(newGraphics, new DrawInfo2D(info, -x, -y), putInHere);
                newGraphics.dispose();
            }
            graphics.drawImage((Image)this.buffer, (int)x, (int)y, null);
        } else if (graphics == null) {
            this.hitOrDraw2(graphics, info, putInHere);
        } else {
            this.buffer = null;
            this.hitOrDraw2(graphics, info, putInHere);
        }
    }

    void clearBufferedImage(BufferedImage image) {
        int len = image.getHeight() * image.getWidth();
        WritableRaster raster = image.getRaster();
        int[] data = new int[len];
        int i = 0;
        while (i < len) {
            data[i] = 0;
            ++i;
        }
        raster.setDataElements(0, 0, image.getWidth(), image.getHeight(), data);
    }

    void hitOrDraw2(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        GeomVectorField geomField = (GeomVectorField)this.field;
        if (geomField == null) {
            return;
        }
        geomField.updateTransform(info);
        GeomInfo2D gInfo = new GeomInfo2D(info, geomField.worldToScreen);
        double xScale = info.draw.width / (double)geomField.getFieldWidth();
        double yScale = info.draw.height / (double)geomField.getFieldHeight();
        GeomEdgeDrawInfo newinfo = new GeomEdgeDrawInfo(new DrawInfo2D(info.gui, info.fieldPortrayal, (RectangularShape)new Rectangle2D.Double(0.0, 0.0, xScale, yScale), (RectangularShape)info.clip), geomField.worldToScreen, new Point2D.Double(0.0, 0.0));
        newinfo.fieldPortrayal = this;
        Bag nodes = this.network.getAllNodes();
        HashMap<Edge, Edge> edgemap = new HashMap<Edge, Edge>();
        int x = 0;
        while (x < nodes.numObjs) {
            block14: {
                MasonGeometry geo1;
                Bag edges;
                Object node;
                block13: {
                    block12: {
                        node = nodes.objs[x];
                        edges = this.network.getEdgesOut(node);
                        if (!(node instanceof MasonGeometry)) break block12;
                        geo1 = (MasonGeometry)node;
                        break block13;
                    }
                    if (!(node instanceof GeoNode)) break block14;
                    geo1 = (GeoNode)((Object)node);
                }
                Point locStart = geo1.getGeometry().getCentroid();
                Coordinate c1 = geo1.getGeometry().getCoordinate();
                if (locStart == null) break block14;
                locStart.apply((CoordinateSequenceFilter)geomField.jtsTransform);
                locStart.geometryChanged();
                newinfo.draw.x = locStart.getX();
                newinfo.draw.y = locStart.getY();
                int y = 0;
                while (y < edges.numObjs) {
                    block17: {
                        MasonGeometry geo2;
                        Edge edge;
                        block16: {
                            Object node2;
                            block15: {
                                edge = (Edge)edges.objs[y];
                                node2 = edge.getOtherNode(node);
                                if (!(node2 instanceof MasonGeometry)) break block15;
                                geo2 = (MasonGeometry)node2;
                                break block16;
                            }
                            if (!(node2 instanceof GeoNode)) break block17;
                            geo2 = (GeoNode)((Object)node2);
                        }
                        Point locStop = geo2.getGeometry().getCentroid();
                        Coordinate c2 = geo2.getGeometry().getCoordinate();
                        if (!(locStop == null || this.network.isDirected() && edgemap.containsKey(edge))) {
                            edgemap.put(edge, edge);
                            GeometryFactory gf = new GeometryFactory();
                            LineString ls = edge.info instanceof GeomPlanarGraphEdge ? ((GeomPlanarGraphEdge)edge.info).getLine() : (edge.info instanceof LineString ? (LineString)edge.info : gf.createLineString(new Coordinate[]{c1, c2}));
                            MasonGeometry mg = new MasonGeometry((Geometry)ls);
                            Portrayal p = this.getPortrayalForObject(edge);
                            SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                            if (graphics == null) {
                                if (portrayal.hitObject((Object)mg, info)) {
                                    putInHere.add((Object)new LocationWrapper((Object)mg, (Object)ls.getCentroid(), (FieldPortrayal)this));
                                }
                            } else if (portrayal instanceof GeomPortrayal) {
                                portrayal.draw((Object)mg, graphics, (DrawInfo2D)gInfo);
                            } else {
                                System.out.println("GAHHH");
                            }
                        }
                    }
                    ++y;
                }
            }
            ++x;
        }
    }

    public void setField(Object field) {
        if (!(field instanceof GeomVectorField)) {
            throw new RuntimeException("Invalid field for GeomNetworkFieldPortrayal: " + field);
        }
        super.setField(field);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
        if (selected) {
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
        } else {
            this.selectedWrappers.remove(obj);
        }
        return true;
    }

    String edgeLocation(Edge edge) {
        if (edge == null) {
            return "(Null)";
        }
        if (edge.owner() == null) {
            return "(Unowned)" + edge.from() + " --> " + edge.to();
        }
        if (edge.owner().isDirected()) {
            return edge.from() + " --> " + edge.to();
        }
        return edge.from() + " <-> " + edge.to();
    }

    public LocationWrapper getWrapper(Edge edge) {
        final GeomVectorField field = (GeomVectorField)this.field;
        return new LocationWrapper(edge.info, edge, (FieldPortrayal)this){

            public String getLocationName() {
                Edge edge = (Edge)this.getLocation();
                if (field != null && GeomNetworkFieldPortrayal.this.network != null) {
                    Bag b = GeomNetworkFieldPortrayal.this.network.getEdgesOut(edge.from());
                    int x = 0;
                    while (x < b.numObjs) {
                        if (b.objs[x] == edge) {
                            return GeomNetworkFieldPortrayal.this.edgeLocation(edge);
                        }
                        ++x;
                    }
                }
                return "Gone.  Was: " + GeomNetworkFieldPortrayal.this.edgeLocation(edge);
            }
        };
    }
}

