/*
 * Decompiled with CFR 0.152.
 */
package swise.visualization;

import java.awt.Color;
import sim.util.Bag;
import sim.util.gui.ColorMap;

public class SegmentedColorMap
implements ColorMap {
    public final Color clearColor = new Color(0, 0, 0, 0);
    static final int COLOR_DISCRETIZATION = 257;
    double[] levels;
    int[] reds;
    int[] blues;
    int[] greens;
    int[] alphas;
    double maxLevel = 0.0;
    double minLevel = 0.0;
    Color minColor = this.clearColor;
    Color maxColor = this.clearColor;
    public Color[] colors;
    Bag[] colorCache = new Bag[257];

    public SegmentedColorMap(double[] levels, Color[] colors) {
        if (levels.length != colors.length) {
            System.out.println("hmmm");
        }
        this.colors = colors;
        this.levels = levels;
        this.minColor = colors[0];
        this.maxColor = colors[colors.length - 1];
        this.minLevel = levels[0];
        this.maxLevel = levels[levels.length - 1];
        int len = colors.length;
        this.reds = new int[len];
        this.blues = new int[len];
        this.greens = new int[len];
        this.alphas = new int[len];
        int i = 0;
        while (i < colors.length) {
            this.reds[i] = colors[i].getRed();
            this.blues[i] = colors[i].getBlue();
            this.greens[i] = colors[i].getGreen();
            this.alphas[i] = colors[i].getAlpha();
            ++i;
        }
    }

    public Color[] setColorTable(Color[] colorTable) {
        Color[] retval = this.colors;
        this.colors = colorTable;
        return retval;
    }

    public double filterLevel(double level) {
        return level;
    }

    public Color getColor(double level) {
        double minLevel = this.minLevel;
        double maxLevel = this.maxLevel;
        if (level >= maxLevel) {
            return this.maxColor;
        }
        if (level <= minLevel) {
            return this.minColor;
        }
        int interval = 0;
        int i = 1;
        while (i < this.levels.length) {
            if (level <= this.levels[i]) {
                interval = i;
                i = this.levels.length;
            }
            ++i;
        }
        minLevel = this.levels[interval - 1];
        maxLevel = this.levels[interval];
        double interpolation = (level - minLevel) / (maxLevel - minLevel);
        int alpha = (int)(interpolation * (double)(this.alphas[interval] - this.alphas[interval - 1]) + (double)this.alphas[interval - 1]);
        if (alpha == 0) {
            return this.clearColor;
        }
        int red = (int)(interpolation * (double)(this.reds[interval] - this.reds[interval - 1]) + (double)this.reds[interval - 1]);
        int green = (int)(interpolation * (double)(this.greens[interval] - this.greens[interval - 1]) + (double)this.greens[interval - 1]);
        int blue = (int)(interpolation * (double)(this.blues[interval] - this.blues[interval - 1]) + (double)this.blues[interval - 1]);
        int rgb = alpha << 24 | red << 16 | green << 8 | blue;
        Color c = new Color(rgb, alpha != 0);
        return c;
    }

    public int getAlpha(double level) {
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level].getAlpha();
        }
        double minLevel = this.minLevel;
        double maxLevel = this.maxLevel;
        if (level >= maxLevel) {
            return this.maxColor.getAlpha();
        }
        if (level <= minLevel) {
            return this.minColor.getAlpha();
        }
        double interval = maxLevel - minLevel;
        level = this.filterLevel((level - minLevel) / interval) * interval + minLevel;
        double interpolation = (level - minLevel) / (maxLevel - minLevel);
        int maxAlpha = this.alphas[this.alphas.length - 1];
        int minAlpha = this.alphas[0];
        return maxAlpha == minAlpha ? minAlpha : (int)(interpolation * (double)(maxAlpha - minAlpha) + (double)minAlpha);
    }

    public int getRGB(double level) {
        double minLevel = this.minLevel;
        double maxLevel = this.maxLevel;
        if (level >= maxLevel) {
            return this.maxColor.getRGB();
        }
        if (level <= minLevel) {
            return this.minColor.getRGB();
        }
        int interval = 0;
        int i = 1;
        while (i < this.levels.length) {
            if (level <= this.levels[i]) {
                interval = i;
                i = this.levels.length;
            }
            ++i;
        }
        minLevel = this.levels[interval - 1];
        maxLevel = this.levels[interval];
        double interpolation = (level - minLevel) / (maxLevel - minLevel);
        int alpha = (int)(interpolation * (double)(this.alphas[interval] - this.alphas[interval - 1]) + (double)this.alphas[interval - 1]);
        int red = (int)(interpolation * (double)(this.reds[interval] - this.reds[interval - 1]) + (double)this.reds[interval - 1]);
        int green = (int)(interpolation * (double)(this.greens[interval] - this.greens[interval - 1]) + (double)this.greens[interval - 1]);
        int blue = (int)(interpolation * (double)(this.blues[interval] - this.blues[interval - 1]) + (double)this.blues[interval - 1]);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public boolean validLevel(double value) {
        return value >= this.minLevel && value < this.maxLevel;
    }

    public double defaultValue() {
        if (this.colors != null) {
            return 0.0;
        }
        return this.minLevel;
    }
}

