/*
 * Decompiled with CFR 0.152.
 */
package swise.visualization;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import swise.visualization.GeomEdgeDrawInfo;

public class SimpleGeoEdgePortrayal
extends SimpleEdgePortrayal2D {
    public SimpleGeoEdgePortrayal(Paint edgepaint) {
        this.fromPaint = edgepaint;
        this.toPaint = edgepaint;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (!(info instanceof GeomEdgeDrawInfo)) {
            throw new RuntimeException("Expected this to be an GeomEdgeDrawInfo: " + info);
        }
        GeomEdgeDrawInfo e = (GeomEdgeDrawInfo)info;
        int scaling = this.getScaling();
        Line2D.Double preciseLine = new Line2D.Double();
        double startXd = e.draw.x;
        double startYd = e.draw.y;
        double endXd = e.secondPoint.x;
        double endYd = e.secondPoint.y;
        double midXd = (startXd + endXd) / 2.0;
        double midYd = (startYd + endYd) / 2.0;
        int startX = (int)startXd;
        int startY = (int)startYd;
        int endX = (int)endXd;
        int endY = (int)endYd;
        int midX = (int)midXd;
        int midY = (int)midYd;
        if (this.fromPaint == this.toPaint) {
            graphics.setPaint(this.fromPaint);
            double width = this.getBaseWidth();
            if (info.precise || width != 0.0) {
                double scale = info.draw.width;
                if (scaling == 1 && info.draw.width >= 1.0 || scaling == 0) {
                    scale = 1.0;
                }
                Stroke oldstroke = graphics.getStroke();
                double weight = 1.0;
                graphics.setStroke(new BasicStroke((float)(width * weight * scale), 0, 0));
                preciseLine.setLine(startXd, startYd, endXd, endYd);
                graphics.draw(preciseLine);
                graphics.setStroke(oldstroke);
            } else {
                graphics.drawLine(startX, startY, endX, endY);
            }
        } else {
            graphics.setPaint(this.fromPaint);
            double width = this.getBaseWidth();
            if (info.precise || width != 0.0) {
                double scale = info.draw.width;
                if (scaling == 1 && info.draw.width >= 1.0 || scaling == 0) {
                    scale = 1.0;
                }
                Stroke oldstroke = graphics.getStroke();
                double weight = 1.0;
                graphics.setStroke(new BasicStroke((float)(width * weight * scale), 0, 0));
                preciseLine.setLine(startXd, startYd, midXd, midYd);
                graphics.draw(preciseLine);
                graphics.setPaint(this.toPaint);
                preciseLine.setLine(midXd, midYd, endXd, endYd);
                graphics.draw(preciseLine);
                graphics.setStroke(oldstroke);
            } else {
                graphics.drawLine(startX, startY, midX, midY);
                graphics.setPaint(this.toPaint);
                graphics.drawLine(midX, midY, endX, endY);
            }
        }
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        if (!(range instanceof GeomEdgeDrawInfo)) {
            throw new RuntimeException("Expected this to be an GeomEdgeDrawInfo: " + range);
        }
        GeomEdgeDrawInfo e = (GeomEdgeDrawInfo)range;
        int scaling = this.getScaling();
        double startXd = e.draw.x;
        double startYd = e.draw.y;
        double endXd = e.secondPoint.x;
        double endYd = e.secondPoint.y;
        double weight = 1.0;
        double width = this.getBaseWidth();
        double SLOP = 5.0;
        double scale = range.draw.width;
        if (scaling == 1 && range.draw.width >= 1.0 || scaling == 0) {
            scale = 1.0;
        }
        Line2D.Double line = new Line2D.Double(startXd, startYd, endXd, endYd);
        if (width == 0.0) {
            return line.intersects(range.clip.x - 5.0, range.clip.y - 5.0, range.clip.width + 10.0, range.clip.height + 10.0);
        }
        return new BasicStroke((float)(width * weight * scale), 0, 0).createStrokedShape(line).intersects(range.clip.x - 5.0, range.clip.y - 5.0, range.clip.width + 10.0, range.clip.height + 10.0);
    }
}

