/*
 * Decompiled with CFR 0.152.
 */
package swise.visualization.holders;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import sim.display.GUIState;
import sim.display.Manipulating2D;
import sim.display.Prefs;
import sim.display.SimApplet;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Bag;
import sim.util.gui.LabelledList;
import sim.util.gui.MovieMaker;
import sim.util.gui.NumberTextField;
import sim.util.gui.Utilities;
import sim.util.media.PDFEncoder;
import sim.util.media.PNGEncoder;

public class StaticDisplay2D
extends JComponent
implements Manipulating2D {
    protected boolean precise = false;
    public String DEFAULT_PREFERENCES_KEY;
    String preferencesKey = this.DEFAULT_PREFERENCES_KEY = "StaticDisplay2D";
    public static final boolean isMacOSX = StaticDisplay2D.isMacOSX();
    public static final boolean isWindows = StaticDisplay2D.isWindows();
    public static final String javaVersion = StaticDisplay2D.getVersion();
    public static final ImageIcon LAYERS_ICON;
    public static final ImageIcon LAYERS_ICON_P;
    public static final ImageIcon REFRESH_ICON;
    public static final ImageIcon REFRESH_ICON_P;
    public static final ImageIcon MOVIE_ON_ICON;
    public static final ImageIcon MOVIE_ON_ICON_P;
    public static final ImageIcon MOVIE_OFF_ICON;
    public static final ImageIcon MOVIE_OFF_ICON_P;
    public static final ImageIcon CAMERA_ICON;
    public static final ImageIcon CAMERA_ICON_P;
    public static final ImageIcon OPTIONS_ICON;
    public static final ImageIcon OPTIONS_ICON_P;
    public static final Object[] REDRAW_OPTIONS;
    boolean useTooltips;
    long lastEncodedSteps = -1L;
    MovieMaker movieMaker;
    public InnerDisplay2D insideDisplay;
    public OptionPane optionPane = new OptionPane("");
    ArrayList portrayals = new ArrayList();
    public JScrollPane display;
    JViewport port;
    public Box header;
    public JPopupMenu popup;
    public JToggleButton layersbutton;
    public JPopupMenu refreshPopup;
    public JToggleButton refreshbutton;
    public JButton movieButton;
    public JButton snapshotButton;
    public JButton optionButton;
    public NumberTextField scaleField;
    public NumberTextField skipField;
    public JComboBox skipBox;
    public JFrame skipFrame;
    double scale = 1.0;
    final Object scaleLock = new Object();
    boolean clipping = true;
    Paint backdrop = Color.white;
    ArrayList selectedWrappers = new ArrayList();
    static final int SCROLL_BAR_SCROLL_RATIO = 10;
    private Object sacrificialObj = null;
    public static final int TYPE_PDF = 1;
    public static final int TYPE_PNG = 2;
    public static final int UPDATE_RULE_STEPS = 0;
    public static final int UPDATE_RULE_INTERNAL_TIME = 1;
    public static final int UPDATE_RULE_WALLCLOCK_TIME = 2;
    public static final int UPDATE_RULE_ALWAYS = 3;
    public static final int UPDATE_RULE_NEVER = 4;
    int updateRule = 3;
    long stepInterval = 1L;
    double timeInterval = 0.0;
    long wallInterval = 0L;
    long lastStep = -1L;
    double lastTime = -1.0;
    long lastWall = -1L;

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.setProperty("com.apple.hwaccel", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LAYERS_ICON = StaticDisplay2D.iconFor("Layers.png");
        LAYERS_ICON_P = StaticDisplay2D.iconFor("LayersPressed.png");
        REFRESH_ICON = StaticDisplay2D.iconFor("Reload.png");
        REFRESH_ICON_P = StaticDisplay2D.iconFor("ReloadPressed.png");
        MOVIE_ON_ICON = StaticDisplay2D.iconFor("MovieOn.png");
        MOVIE_ON_ICON_P = StaticDisplay2D.iconFor("MovieOnPressed.png");
        MOVIE_OFF_ICON = StaticDisplay2D.iconFor("MovieOff.png");
        MOVIE_OFF_ICON_P = StaticDisplay2D.iconFor("MovieOffPressed.png");
        CAMERA_ICON = StaticDisplay2D.iconFor("Camera.png");
        CAMERA_ICON_P = StaticDisplay2D.iconFor("CameraPressed.png");
        OPTIONS_ICON = StaticDisplay2D.iconFor("Options.png");
        OPTIONS_ICON_P = StaticDisplay2D.iconFor("OptionsPressed.png");
        REDRAW_OPTIONS = new Object[]{"Steps/Redraw", "Model Secs/Redraw", "Real Secs/Redraw", "Always Redraw", "Never Redraw"};
    }

    public void setPreferencesKey(String s) {
        if (s.trim().endsWith("/")) {
            throw new RuntimeException("Key ends with '/', which is not allowed");
        }
        this.preferencesKey = s;
    }

    public String getPreferencesKey() {
        return this.preferencesKey;
    }

    public void removeListeners() {
        this.insideDisplay.removeListeners();
    }

    static boolean isMacOSX() {
        try {
            return System.getProperty("mrj.version") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isWindows() {
        try {
            return !StaticDisplay2D.isMacOSX() && System.getProperty("os.name").startsWith("Win");
        }
        catch (Throwable e) {
            return false;
        }
    }

    static String getVersion() {
        try {
            return System.getProperty("java.version");
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    static ImageIcon iconFor(String name) {
        return new ImageIcon(StaticDisplay2D.class.getResource(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double val) {
        Object object = this.scaleLock;
        synchronized (object) {
            if (val > 0.0) {
                this.scale = val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScale() {
        Object object = this.scaleLock;
        synchronized (object) {
            return this.scale;
        }
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean val) {
        this.clipping = val;
    }

    public void setBackdrop(Paint c) {
        this.backdrop = c;
    }

    public Paint getBackdrop() {
        return this.backdrop;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.quit();
    }

    public void quit() {
        this.stopMovie();
    }

    public void reset() {
        this.clearSelections();
    }

    public void attach(FieldPortrayal2D portrayal, String name) {
        this.attach(portrayal, name, true);
    }

    public void attach(FieldPortrayal2D portrayal, String name, Rectangle2D.Double bounds) {
        this.attach(portrayal, name, bounds, true);
    }

    public void attach(FieldPortrayal2D portrayal, String name, boolean visible) {
        this.attach(portrayal, name, 0.0, 0.0, visible);
    }

    public void attach(FieldPortrayal2D portrayal, String name, double x, double y, boolean visible) {
        this.attach(portrayal, name, new Rectangle2D.Double(x, y, this.insideDisplay.width, this.insideDisplay.height), visible);
    }

    public void attach(FieldPortrayal2D portrayal, String name, Rectangle2D.Double bounds, boolean visible) {
        FieldPortrayal2DHolder p = new FieldPortrayal2DHolder(portrayal, name, bounds, visible);
        this.portrayals.add(p);
        this.popup.add(p.menuItem);
    }

    public void attach(final Inspector inspector, final String name) {
        JMenuItem consoleMenu = new JMenuItem("Show " + name);
        this.popup.add(consoleMenu);
        consoleMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bag inspectors = new Bag();
                inspectors.add((Object)inspector);
                Bag names = new Bag();
                names.add((Object)name);
            }
        });
    }

    public ArrayList detatchAll() {
        ArrayList old = this.portrayals;
        this.popup.removeAll();
        this.portrayals = new ArrayList();
        return old;
    }

    public StaticDisplay2D(double width, double height, GUIState simulation, long interval) {
        this(width, height, simulation);
    }

    public StaticDisplay2D(double width, double height, GUIState simulation) {
        this.reset();
        Color transparentBackground = new JPanel().getBackground();
        this.insideDisplay = new InnerDisplay2D(width, height);
        this.display = new JScrollPane(this.insideDisplay, 22, 32);
        this.display.setMinimumSize(new Dimension(0, 0));
        this.display.setBorder(null);
        this.display.getHorizontalScrollBar().setBorder(null);
        this.display.getVerticalScrollBar().setBorder(null);
        this.port = this.display.getViewport();
        this.insideDisplay.setViewRect(this.port.getViewRect());
        this.insideDisplay.setOpaque(true);
        this.insideDisplay.setBackground(UIManager.getColor("Panel.background"));
        this.display.setBackground(UIManager.getColor("Panel.background"));
        this.port.setBackground(UIManager.getColor("Panel.background"));
        this.header = new Box(0){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 0;
                return d;
            }
        };
        this.layersbutton = new JToggleButton(LAYERS_ICON);
        this.layersbutton.setPressedIcon(LAYERS_ICON_P);
        this.layersbutton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layersbutton.setBorderPainted(false);
        this.layersbutton.setContentAreaFilled(false);
        this.layersbutton.setToolTipText("Show and hide different layers");
        this.header.add(this.layersbutton);
        this.popup = new JPopupMenu();
        this.popup.setLightWeightPopupEnabled(false);
        this.layersbutton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                StaticDisplay2D.this.popup.show(e.getComponent(), 0, StaticDisplay2D.this.layersbutton.getSize().height);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                StaticDisplay2D.this.layersbutton.setSelected(false);
            }
        });
        this.refreshbutton = new JToggleButton(REFRESH_ICON);
        this.refreshbutton.setPressedIcon(REFRESH_ICON_P);
        this.refreshbutton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.refreshbutton.setBorderPainted(false);
        this.refreshbutton.setContentAreaFilled(false);
        this.refreshbutton.setToolTipText("Change How and When the Display Redraws Itself");
        this.header.add(this.refreshbutton);
        this.refreshPopup = new JPopupMenu();
        this.refreshPopup.setLightWeightPopupEnabled(false);
        this.refreshbutton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                StaticDisplay2D.this.rebuildRefreshPopup();
                StaticDisplay2D.this.refreshPopup.show(e.getComponent(), 0, StaticDisplay2D.this.refreshbutton.getSize().height);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                StaticDisplay2D.this.refreshbutton.setSelected(false);
                StaticDisplay2D.this.rebuildRefreshPopup();
            }
        });
        this.insideDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) == 16) {
                    Point point = e.getPoint();
                    if (e.getClickCount() == 2) {
                        StaticDisplay2D.this.createInspectors(new Rectangle2D.Double(point.x, point.y, 1.0, 1.0));
                    }
                    if (e.getClickCount() == 1 || e.getClickCount() == 2) {
                        StaticDisplay2D.this.performSelection(new Rectangle2D.Double(point.x, point.y, 1.0, 1.0));
                    }
                    StaticDisplay2D.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StaticDisplay2D.this.insideDisplay.lastToolTipEvent = null;
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
            }
        });
        this.insideDisplay.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StaticDisplay2D.this.handleMouseEvent(e)) {
                    StaticDisplay2D.this.repaint();
                    return;
                }
            }
        });
        this.insideDisplay.setToolTipText("Display");
        this.movieButton = new JButton(MOVIE_OFF_ICON);
        this.movieButton.setPressedIcon(MOVIE_OFF_ICON_P);
        this.movieButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.movieButton.setBorderPainted(false);
        this.movieButton.setContentAreaFilled(false);
        this.movieButton.setToolTipText("Create a Quicktime movie");
        this.movieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StaticDisplay2D.this.movieMaker == null) {
                    StaticDisplay2D.this.startMovie();
                } else {
                    StaticDisplay2D.this.stopMovie();
                }
            }
        });
        this.header.add(this.movieButton);
        this.snapshotButton = new JButton(CAMERA_ICON);
        this.snapshotButton.setPressedIcon(CAMERA_ICON_P);
        this.snapshotButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.snapshotButton.setBorderPainted(false);
        this.snapshotButton.setContentAreaFilled(false);
        this.snapshotButton.setToolTipText("Create a snapshot (as a PNG or PDF file)");
        this.snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.takeSnapshot();
            }
        });
        this.header.add(this.snapshotButton);
        this.optionButton = new JButton(OPTIONS_ICON);
        this.optionButton.setPressedIcon(OPTIONS_ICON_P);
        this.optionButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.optionButton.setBorderPainted(false);
        this.optionButton.setContentAreaFilled(false);
        this.optionButton.setToolTipText("Show the Option Pane");
        this.optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.optionPane.setTitle(String.valueOf(StaticDisplay2D.this.getFrame().getTitle()) + " Options");
                StaticDisplay2D.this.optionPane.pack();
                StaticDisplay2D.this.optionPane.setVisible(true);
            }
        });
        this.header.add(this.optionButton);
        this.scaleField = new NumberTextField("  Scale: ", 1.0, true){

            public double newValue(double newValue) {
                if (newValue <= 0.0) {
                    newValue = this.currentValue;
                }
                StaticDisplay2D.this.insideDisplay.paintLock = true;
                Rectangle r = StaticDisplay2D.this.port.getViewRect();
                double centerx = (double)r.x + (double)r.width / 2.0;
                double centery = (double)r.y + (double)r.height / 2.0;
                Point topleft = new Point((int)((centerx *= newValue / this.currentValue) - (double)r.width / 2.0), (int)((centery *= newValue / this.currentValue) - (double)r.height / 2.0));
                if (topleft.x < 0) {
                    topleft.x = 0;
                }
                if (topleft.y < 0) {
                    topleft.y = 0;
                }
                StaticDisplay2D.this.setScale(newValue);
                StaticDisplay2D.this.optionPane.xOffsetField.setValue(StaticDisplay2D.this.insideDisplay.xOffset * newValue);
                StaticDisplay2D.this.optionPane.yOffsetField.setValue(StaticDisplay2D.this.insideDisplay.yOffset * newValue);
                StaticDisplay2D.this.port.setView(StaticDisplay2D.this.insideDisplay);
                StaticDisplay2D.this.insideDisplay.paintLock = false;
                StaticDisplay2D.this.port.setViewPosition(topleft);
                StaticDisplay2D.this.repaint();
                return newValue;
            }
        };
        this.scaleField.setToolTipText("Zoom in and out");
        this.scaleField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.header.add((Component)this.scaleField);
        this.skipFrame = new JFrame();
        this.rebuildSkipFrame();
        this.skipFrame.pack();
        this.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.add((Component)this.display, "Center");
        this.optionPane.resetToPreferences();
    }

    public Bag[] objectsHitBy(Rectangle2D.Double rect) {
        Bag[] hitObjs = new Bag[this.portrayals.size()];
        Iterator iter = this.portrayals.iterator();
        int x = 0;
        while (iter.hasNext()) {
            hitObjs[x] = new Bag();
            FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)iter.next();
            if (p.visible) {
                p.portrayal.hitObjects(this.getDrawInfo2D(p, (Rectangle2D)rect), hitObjs[x]);
            }
            ++x;
        }
        return hitObjs;
    }

    public Bag[] objectsHitBy(Point2D point) {
        return this.objectsHitBy(new Rectangle2D.Double(point.getX(), point.getY(), 1.0, 1.0));
    }

    public DrawInfo2D getDrawInfo2D(FieldPortrayal2D portrayal, Point2D point) {
        return this.getDrawInfo2D(portrayal, (Rectangle2D)new Rectangle2D.Double(point.getX(), point.getY(), 1.0, 1.0));
    }

    public DrawInfo2D getDrawInfo2D(FieldPortrayal2D portrayal, Rectangle2D clip) {
        for (FieldPortrayal2DHolder p : this.portrayals) {
            if (p.portrayal != portrayal) continue;
            return this.getDrawInfo2D(p, clip);
        }
        return null;
    }

    DrawInfo2D getDrawInfo2D(FieldPortrayal2DHolder holder, Rectangle2D clip) {
        if (holder == null) {
            return null;
        }
        double scale = this.getScale();
        int origindx = 0;
        int origindy = 0;
        origindx += (int)(this.insideDisplay.xOffset * scale);
        origindy += (int)(this.insideDisplay.yOffset * scale);
        Rectangle fullComponent = this.insideDisplay.getViewRect();
        if (((RectangularShape)fullComponent).getWidth() > this.insideDisplay.width * scale) {
            origindx = (int)((((RectangularShape)fullComponent).getWidth() - this.insideDisplay.width * scale) / 2.0);
        }
        if (((RectangularShape)fullComponent).getHeight() > this.insideDisplay.height * scale) {
            origindy = (int)((((RectangularShape)fullComponent).getHeight() - this.insideDisplay.height * scale) / 2.0);
        }
        Rectangle2D.Double region = new Rectangle2D.Double((int)(holder.bounds.x * scale) + origindx, (int)(holder.bounds.y * scale) + origindy, (int)(holder.bounds.width * scale), (int)(holder.bounds.height * scale));
        DrawInfo2D d2d = new DrawInfo2D(null, holder.portrayal, (RectangularShape)region, (RectangularShape)clip);
        d2d.gui = null;
        d2d.precise = this.precise;
        return d2d;
    }

    public void performSelection(LocationWrapper wrapper) {
        Bag b = new Bag();
        b.add((Object)wrapper);
        this.performSelection(b);
    }

    public void clearSelections() {
        int x = 0;
        while (x < this.selectedWrappers.size()) {
            LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, false);
            ++x;
        }
        this.selectedWrappers.clear();
    }

    public void performSelection(Bag locationWrappers) {
        this.clearSelections();
        if (locationWrappers == null) {
            return;
        }
        int x = 0;
        while (x < locationWrappers.size()) {
            LocationWrapper wrapper = (LocationWrapper)locationWrappers.get(x);
            wrapper.getFieldPortrayal().setSelected(wrapper, true);
            this.selectedWrappers.add(wrapper);
            ++x;
        }
    }

    public void performSelection(Rectangle2D.Double rect) {
        Bag[] hitObjects = this.objectsHitBy(rect);
        Bag collection = new Bag();
        int x = 0;
        while (x < hitObjects.length) {
            collection.addAll(hitObjects[x]);
            ++x;
        }
        this.performSelection(collection);
    }

    public void createInspectors(Rectangle2D.Double rect) {
        Bag inspectors = new Bag();
        Bag names = new Bag();
        Bag[] hitObjects = this.objectsHitBy(rect);
        int x = 0;
        while (x < hitObjects.length) {
            FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)this.portrayals.get(x);
            int i = 0;
            while (i < hitObjects[x].numObjs) {
                LocationWrapper wrapper = (LocationWrapper)hitObjects[x].objs[i];
                names.add((Object)p.portrayal.getName(wrapper));
                ++i;
            }
            ++x;
        }
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame(){

            @Override
            public void dispose() {
                StaticDisplay2D.this.quit();
                super.dispose();
            }
        };
        frame.setResizable(true);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Utilities.doEnsuredRepaint((Component)StaticDisplay2D.this.header);
                StaticDisplay2D.this.display.getHorizontalScrollBar().setUnitIncrement(StaticDisplay2D.this.display.getViewport().getWidth() / 10);
                StaticDisplay2D.this.display.getVerticalScrollBar().setUnitIncrement(StaticDisplay2D.this.display.getViewport().getHeight() / 10);
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this, "Center");
        frame.setTitle("Display");
        frame.pack();
        return frame;
    }

    public Frame getFrame() {
        Container c = this;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    public void takeSnapshot(File file, int type) throws IOException {
        if (type == 2) {
            Graphics g = this.insideDisplay.getGraphics();
            BufferedImage img = this.insideDisplay.paint(g, true, false);
            g.dispose();
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
            PNGEncoder tmpEncoder = new PNGEncoder((Image)img, false, 0, 9);
            ((OutputStream)stream).write(tmpEncoder.pngEncode());
            ((OutputStream)stream).close();
        } else {
            boolean oldprecise = this.precise;
            this.precise = true;
            PDFEncoder.generatePDF((Component)this.port, (File)file);
            this.precise = oldprecise;
        }
    }

    public void takeSnapshot() {
        FileDialog fd;
        if (SimApplet.isApplet()) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot save snapshots from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        boolean havePDF = false;
        Graphics g = this.insideDisplay.getGraphics();
        BufferedImage img = this.insideDisplay.paint(g, true, false);
        try {
            this.sacrificialObj = Class.forName("com.lowagie.text.Cell").newInstance();
            havePDF = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.dispose();
        boolean CANCEL_BUTTON = false;
        boolean PNG_BUTTON = true;
        int PDF_BUTTON = 2;
        int PDF_NO_BACKDROP_BUTTON = 3;
        int result = 1;
        if (havePDF) {
            Object[] options = new Object[]{"Cancel", "Save to PNG Bitmap", "Save to PDF", "Save to PDF with no Backdrop"};
            result = JOptionPane.showOptionDialog(this.getFrame(), "Save window snapshot to what kind of file format?", "Save Format", 0, 3, null, options, options[0]);
        }
        if (result == 1) {
            fd = new FileDialog(this.getFrame(), "Save Snapshot as 24-bit PNG...", 1);
            fd.setFile("Untitled.png");
            fd.setVisible(true);
            if (fd.getFile() != null) {
                try {
                    BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(new File(fd.getDirectory(), Utilities.ensureFileEndsWith((String)fd.getFile(), (String)".png"))));
                    PNGEncoder tmpEncoder = new PNGEncoder((Image)img, false, 0, 9);
                    ((OutputStream)stream).write(tmpEncoder.pngEncode());
                    ((OutputStream)stream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (result == 2 || result == 3) {
            fd = new FileDialog(this.getFrame(), "Save Snapshot as PDF...", 1);
            fd.setFile("Untitled.pdf");
            fd.setVisible(true);
            if (fd.getFile() != null) {
                try {
                    boolean oldprecise = this.precise;
                    this.precise = true;
                    Paint b = this.getBackdrop();
                    if (result == 3) {
                        this.setBackdrop(null);
                    }
                    PDFEncoder.generatePDF((Component)this.port, (File)new File(fd.getDirectory(), Utilities.ensureFileEndsWith((String)fd.getFile(), (String)".pdf")));
                    this.precise = oldprecise;
                    if (result == 3) {
                        this.setBackdrop(b);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void startMovie() {
        if (SimApplet.isApplet()) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot create movies from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        if (this.movieMaker != null) {
            return;
        }
        this.movieMaker = new MovieMaker(this.getFrame());
        Graphics g = this.insideDisplay.getGraphics();
        BufferedImage typicalImage = this.insideDisplay.paint(g, true, false);
        g.dispose();
        if (!this.movieMaker.start(typicalImage)) {
            this.movieMaker = null;
        } else {
            this.movieButton.setIcon(MOVIE_ON_ICON);
            this.movieButton.setPressedIcon(MOVIE_ON_ICON_P);
            this.lastEncodedSteps = -1L;
            this.insideDisplay.paintToMovie(null);
        }
    }

    public void stopMovie() {
        if (this.movieMaker == null) {
            return;
        }
        if (!this.movieMaker.stop()) {
            Object[] options = new Object[]{"Drat"};
            JOptionPane.showOptionDialog(this, "Your movie did not write to disk\ndue to a spurious JMF movie generation bug.", "JMF Movie Generation Bug", 0, 2, null, options, options[0]);
        }
        this.movieMaker = null;
        if (this.movieButton != null) {
            this.movieButton.setIcon(MOVIE_OFF_ICON);
            this.movieButton.setPressedIcon(MOVIE_OFF_ICON_P);
        }
    }

    public boolean shouldUpdate() {
        boolean val = false;
        if (this.updateRule == 3) {
            val = true;
        }
        return val;
    }

    public boolean handleMouseEvent(MouseEvent event) {
        Point2D.Double p = new Point2D.Double(event.getX(), event.getY());
        int x = 0;
        while (x < this.selectedWrappers.size()) {
            LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(x);
            FieldPortrayal2D f = (FieldPortrayal2D)wrapper.getFieldPortrayal();
            Object obj = wrapper.getObject();
            SimplePortrayal2D simplePortrayal2D = (SimplePortrayal2D)f.getPortrayalForObject(obj);
            ++x;
        }
        Bag[] hitObjects = this.objectsHitBy(p);
        int x2 = hitObjects.length - 1;
        while (x2 >= 0) {
            int i = 0;
            while (i < hitObjects[x2].numObjs) {
                LocationWrapper wrapper = (LocationWrapper)hitObjects[x2].objs[i];
                FieldPortrayal2D f = (FieldPortrayal2D)wrapper.getFieldPortrayal();
                Object obj = wrapper.getObject();
                SimplePortrayal2D simplePortrayal2D = (SimplePortrayal2D)f.getPortrayalForObject(obj);
                ++i;
            }
            --x2;
        }
        return false;
    }

    void rebuildSkipFrame() {
        this.skipFrame.getContentPane().removeAll();
        this.skipFrame.getContentPane().invalidate();
        this.skipFrame.getContentPane().repaint();
        this.skipFrame.getContentPane().setLayout(new BorderLayout());
        JPanel skipHeader = new JPanel();
        skipHeader.setLayout(new BorderLayout());
        this.skipFrame.add((Component)skipHeader, "Center");
        this.skipBox = new JComboBox<Object>(REDRAW_OPTIONS);
        this.skipBox.setSelectedIndex(this.updateRule);
        ActionListener skipListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = StaticDisplay2D.this.skipBox.getSelectedIndex();
                if (StaticDisplay2D.this.updateRule == 3 || StaticDisplay2D.this.updateRule == 4) {
                    StaticDisplay2D.this.skipField.getField().setText("");
                    StaticDisplay2D.this.skipField.setEnabled(false);
                } else if (StaticDisplay2D.this.updateRule == 0) {
                    StaticDisplay2D.this.skipField.setValue((double)StaticDisplay2D.this.stepInterval);
                    StaticDisplay2D.this.skipField.setEnabled(true);
                } else if (StaticDisplay2D.this.updateRule == 1) {
                    StaticDisplay2D.this.skipField.setValue(StaticDisplay2D.this.timeInterval);
                    StaticDisplay2D.this.skipField.setEnabled(true);
                } else {
                    StaticDisplay2D.this.skipField.setValue((double)(StaticDisplay2D.this.wallInterval / 1000L));
                    StaticDisplay2D.this.skipField.setEnabled(true);
                }
            }
        };
        this.skipBox.addActionListener(skipListener);
        this.skipBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setHorizontalAlignment(4);
                return label;
            }
        });
        skipHeader.add((Component)this.skipBox, "West");
        this.skipField = new NumberTextField(null, 1.0, false){

            public double newValue(double newValue) {
                double val;
                if (StaticDisplay2D.this.updateRule == 3 || StaticDisplay2D.this.updateRule == 4) {
                    val = 0.0;
                } else if (StaticDisplay2D.this.updateRule == 0) {
                    val = (long)newValue;
                    if (val < 1.0) {
                        val = StaticDisplay2D.this.stepInterval;
                    }
                    StaticDisplay2D.this.stepInterval = (long)val;
                } else if (StaticDisplay2D.this.updateRule == 2) {
                    val = newValue;
                    if (val < 0.0) {
                        val = StaticDisplay2D.this.wallInterval / 1000L;
                    }
                    StaticDisplay2D.this.wallInterval = (long)(newValue * 1000.0);
                } else {
                    val = newValue;
                    if (newValue < 0.0) {
                        newValue = StaticDisplay2D.this.timeInterval;
                    }
                    StaticDisplay2D.this.timeInterval = val;
                }
                StaticDisplay2D.this.reset();
                return val;
            }
        };
        this.skipField.setToolTipText("Specify the interval between screen updates");
        this.skipField.getField().setColumns(10);
        skipHeader.add((Component)this.skipField, "Center");
        skipHeader.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        skipListener.actionPerformed(null);
    }

    void rebuildRefreshPopup() {
        this.refreshPopup.removeAll();
        String s = "";
        switch (this.updateRule) {
            case 0: {
                s = this.stepInterval == 1L ? "Currently redrawing each model iteration" : "Currently redrawing every " + this.stepInterval + " model iterations";
                break;
            }
            case 1: {
                s = this.timeInterval == 1.0 ? "Currently redrawing each unit of model time" : "Currently redrawing every " + this.timeInterval + " units of model time";
                break;
            }
            case 2: {
                s = this.wallInterval == 1000L ? "Currently redrawing each second of real time" : "Currently redrawing every " + (double)this.wallInterval / 1000.0 + " seconds of real time";
                break;
            }
            case 3: {
                s = "Currently redrawing each model iteration";
                break;
            }
            case 4: {
                s = "Currently never redrawing except when the window is redrawn";
            }
        }
        JMenuItem m = new JMenuItem(s);
        m.setEnabled(false);
        this.refreshPopup.add(m);
        this.refreshPopup.addSeparator();
        m = new JMenuItem("Always Redraw");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 3;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Never Redraw");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 4;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 2 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 0;
                StaticDisplay2D.this.stepInterval = 2L;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 4 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 0;
                StaticDisplay2D.this.stepInterval = 4L;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 8 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 0;
                StaticDisplay2D.this.stepInterval = 8L;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 16 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 0;
                StaticDisplay2D.this.stepInterval = 16L;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        m = new JMenuItem("Redraw once every 32 iterations");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.updateRule = 0;
                StaticDisplay2D.this.stepInterval = 16L;
                StaticDisplay2D.this.rebuildSkipFrame();
            }
        });
        this.refreshPopup.addSeparator();
        m = new JMenuItem("More Options...");
        this.refreshPopup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StaticDisplay2D.this.skipFrame.setTitle(String.valueOf(StaticDisplay2D.this.getFrame().getTitle()) + " Options");
                StaticDisplay2D.this.skipFrame.setVisible(true);
            }
        });
        this.refreshPopup.revalidate();
    }

    public void setMovingWrapper(LocationWrapper arg0) {
    }

    class FieldPortrayal2DHolder {
        Rectangle2D.Double bounds;
        FieldPortrayal2D portrayal;
        String name;
        JCheckBoxMenuItem menuItem;
        boolean visible;

        public String toString() {
            return this.name;
        }

        FieldPortrayal2DHolder(FieldPortrayal2D p, String n, Rectangle2D.Double bounds, boolean visible) {
            this.bounds = bounds;
            this.portrayal = p;
            this.name = n;
            this.visible = visible;
            this.menuItem = new JCheckBoxMenuItem(this.name, visible);
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FieldPortrayal2DHolder.this.visible = FieldPortrayal2DHolder.this.menuItem.isSelected();
                    StaticDisplay2D.this.repaint();
                }
            });
        }
    }

    public class InnerDisplay2D
    extends JComponent {
        BufferedImage buffer = null;
        public double width;
        public double height;
        public double xOffset;
        public double yOffset;
        public RenderingHints unbufferedHints;
        public RenderingHints bufferedHints;
        WeakReference toolTip = new WeakReference<Object>(null);
        protected MouseEvent lastToolTipEvent = null;
        String lastToolTipText = null;
        static final int MAX_TOOLTIP_LINES = 10;
        boolean paintLock = false;
        Rectangle viewRect = new Rectangle(0, 0, 0, 0);
        final Object viewRectLock = new Object();

        public void removeListeners() {
            MouseListener[] mls = (MouseListener[])this.getListeners(MouseListener.class);
            int x = 0;
            while (x < mls.length) {
                this.removeMouseListener(mls[x]);
                ++x;
            }
            MouseMotionListener[] mmls = (MouseMotionListener[])this.getListeners(MouseMotionListener.class);
            int x2 = 0;
            while (x2 < mmls.length) {
                this.removeMouseMotionListener(mmls[x2]);
                ++x2;
            }
            KeyListener[] kls = (KeyListener[])this.getListeners(KeyListener.class);
            int x3 = 0;
            while (x3 < kls.length) {
                this.removeKeyListener(kls[x3]);
                ++x3;
            }
        }

        InnerDisplay2D(double width, double height) {
            this.width = width;
            this.height = height;
            this.setupHints(false, false, false);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)(this.width * StaticDisplay2D.this.getScale()), (int)(this.height * StaticDisplay2D.this.getScale()));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paintToMovie(Graphics g) {
            if (StaticDisplay2D.this.shouldUpdate()) {
                StaticDisplay2D.this.movieMaker.add(this.paint(g, true, false));
            } else {
                this.paint(g, false, false);
            }
        }

        public void setupHints(boolean antialias, boolean niceAlphaInterpolation, boolean niceInterpolation) {
            this.unbufferedHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.unbufferedHints.put(RenderingHints.KEY_INTERPOLATION, niceInterpolation ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.unbufferedHints.put(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.unbufferedHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.unbufferedHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, niceAlphaInterpolation ? RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY : RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.bufferedHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.bufferedHints.put(RenderingHints.KEY_INTERPOLATION, niceInterpolation ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.bufferedHints.put(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.bufferedHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.bufferedHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, niceAlphaInterpolation ? RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY : RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip tip = super.createToolTip();
            this.toolTip = new WeakReference<JToolTip>(tip);
            return tip;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (StaticDisplay2D.this.useTooltips) {
                this.lastToolTipEvent = event;
                Point point = event.getPoint();
                return this.createToolTipText(new Rectangle2D.Double(point.x, point.y, 1.0, 1.0));
            }
            return null;
        }

        public void updateToolTips() {
            String s;
            if (StaticDisplay2D.this.useTooltips && this.lastToolTipEvent != null && ((s = this.getToolTipText(this.lastToolTipEvent)) == null || !s.equals(this.lastToolTipText))) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InnerDisplay2D.this.lastToolTipText = s;
                        InnerDisplay2D.this.setToolTipText(InnerDisplay2D.this.lastToolTipText);
                        JToolTip tip = (JToolTip)InnerDisplay2D.this.toolTip.get();
                        if (tip != null && tip.getComponent() == InnerDisplay2D.this) {
                            tip.setTipText(s);
                        }
                    }
                });
            }
        }

        public String createToolTipText(Rectangle2D.Double rect) {
            String s = "<html><font face=\"" + this.getFont().getFamily() + "\" size=\"-1\">";
            Bag[] hitObjects = StaticDisplay2D.this.objectsHitBy(rect);
            int count = 0;
            int x = 0;
            while (x < hitObjects.length) {
                FieldPortrayal2DHolder p = (FieldPortrayal2DHolder)StaticDisplay2D.this.portrayals.get(x);
                int i = 0;
                while (i < hitObjects[x].numObjs) {
                    if (count > 0) {
                        s = String.valueOf(s) + "<br>";
                    }
                    if (count >= 10) {
                        return String.valueOf(s) + "...<i>etc.</i></font></html>";
                    }
                    ++count;
                    String status = p.portrayal.getStatus((LocationWrapper)hitObjects[x].objs[i]);
                    if (status != null) {
                        s = String.valueOf(s) + status;
                    }
                    ++i;
                }
                ++x;
            }
            if (count == 0) {
                return null;
            }
            s = String.valueOf(s) + "</font></html>";
            return s;
        }

        @Override
        public synchronized void paintComponent(Graphics g) {
            if (this.paintLock) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.setViewRect(StaticDisplay2D.this.port.getViewRect());
            }
            this.paintComponent(g, false);
        }

        public void paintComponent(Graphics g, boolean buffer) {
            if (StaticDisplay2D.this.movieMaker != null) {
                StaticDisplay2D.this.insideDisplay.paintToMovie(g);
            } else {
                this.paint(g, buffer, true);
            }
        }

        Rectangle2D computeClip() {
            Rectangle2D clip = this.getViewRect();
            double scale = StaticDisplay2D.this.getScale();
            int origindx = 0;
            int origindy = 0;
            if (((RectangularShape)clip).getWidth() > this.width * scale) {
                origindx = (int)((((RectangularShape)clip).getWidth() - this.width * scale) / 2.0);
            }
            if (((RectangularShape)clip).getHeight() > this.height * scale) {
                origindy = (int)((((RectangularShape)clip).getHeight() - this.height * scale) / 2.0);
            }
            if (StaticDisplay2D.this.isClipping()) {
                Dimension s = this.getPreferredSize();
                clip = ((Rectangle2D)clip).createIntersection(new Rectangle2D.Double(origindx, origindy, s.width, s.height));
            }
            return clip;
        }

        public BufferedImage paint(Graphics graphics, boolean buffered, boolean shared) {
            BufferedImage result = null;
            Rectangle2D clip = this.computeClip();
            if (!buffered) {
                this.paintUnbuffered((Graphics2D)graphics, clip);
            } else {
                result = this.paintBuffered((Graphics2D)graphics, clip);
            }
            if (!shared) {
                this.buffer = null;
            }
            if (result != null) {
                result.flush();
            }
            return result;
        }

        BufferedImage paintBuffered(Graphics2D graphics, Rectangle2D clip) {
            double ww = clip.getWidth();
            double hh = clip.getHeight();
            if (this.buffer == null || (double)this.buffer.getWidth(null) != ww || (double)this.buffer.getHeight(null) != hh) {
                this.buffer = this.getGraphicsConfiguration().createCompatibleImage((int)ww, (int)hh);
            }
            Graphics2D g = (Graphics2D)this.buffer.getGraphics();
            g.setColor(StaticDisplay2D.this.port.getBackground());
            g.fillRect(0, 0, this.buffer.getWidth(null), this.buffer.getHeight(null));
            g.translate(-((int)clip.getX()), -((int)clip.getY()));
            this.paintUnbuffered(g, clip);
            g.dispose();
            if (graphics != null) {
                graphics.setRenderingHints(this.bufferedHints);
                graphics.drawImage((Image)this.buffer, (int)clip.getX(), (int)clip.getY(), null);
            }
            return this.buffer;
        }

        void paintUnbuffered(Graphics2D g, Rectangle2D clip) {
            if (g == null) {
                return;
            }
            g.setRenderingHints(this.unbufferedHints);
            if (StaticDisplay2D.this.isClipping()) {
                g.setClip(clip);
            }
            if (clip.getWidth() != 0.0 && clip.getHeight() != 0.0) {
                if (StaticDisplay2D.this.backdrop != null) {
                    g.setPaint(StaticDisplay2D.this.backdrop);
                    g.fillRect((int)clip.getX(), (int)clip.getY(), (int)clip.getWidth(), (int)clip.getHeight());
                }
                for (FieldPortrayal2DHolder p : StaticDisplay2D.this.portrayals) {
                    if (!p.visible) continue;
                    int buf = p.portrayal.getBuffering();
                    p.portrayal.setBuffering(StaticDisplay2D.this.optionPane.buffering);
                    g.setClip(g.getClip());
                    p.portrayal.draw(p.portrayal.getField(), g, StaticDisplay2D.this.getDrawInfo2D(p, clip));
                    p.portrayal.setBuffering(buf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Rectangle getViewRect() {
            Object object = this.viewRectLock;
            synchronized (object) {
                return new Rectangle(this.viewRect);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setViewRect(Rectangle rect) {
            Object object = this.viewRectLock;
            synchronized (object) {
                this.viewRect = new Rectangle(rect);
            }
        }
    }

    public class OptionPane
    extends JFrame {
        int buffering;
        JRadioButton useNoBuffer;
        JRadioButton useBuffer;
        JRadioButton useDefault;
        ButtonGroup usageGroup;
        JCheckBox antialias;
        JCheckBox alphaInterpolation;
        JCheckBox interpolation;
        JCheckBox tooltips;
        JButton systemPreferences;
        JButton appPreferences;
        NumberTextField xOffsetField;
        NumberTextField yOffsetField;
        ActionListener listener;
        static final String DRAW_GRIDS_KEY = "Draw Grids";
        static final String X_OFFSET_KEY = "X Offset";
        static final String Y_OFFSET_KEY = "Y Offset";
        static final String ANTIALIAS_KEY = "Antialias";
        static final String BETTER_TRANSPARENCY_KEY = "Better Transparency";
        static final String INTERPOLATION_KEY = "Bilinear Interpolation";
        static final String TOOLTIPS_KEY = "Tool Tips";

        OptionPane(String title) {
            super(title);
            this.useNoBuffer = new JRadioButton("By Drawing Separate Rectangles");
            this.useBuffer = new JRadioButton("Using a Stretched Image");
            this.useDefault = new JRadioButton("Let the Program Decide How");
            this.usageGroup = new ButtonGroup();
            this.antialias = new JCheckBox("Antialias Graphics");
            this.alphaInterpolation = new JCheckBox(BETTER_TRANSPARENCY_KEY);
            this.interpolation = new JCheckBox("Bilinear Interpolation of Images");
            this.tooltips = new JCheckBox(TOOLTIPS_KEY);
            this.systemPreferences = new JButton("MASON");
            this.appPreferences = new JButton("Simulation");
            this.xOffsetField = new NumberTextField(0.0, 1.0, 50.0){

                public double newValue(double val) {
                    double scale = StaticDisplay2D.this.getScale();
                    ((OptionPane)OptionPane.this).StaticDisplay2D.this.insideDisplay.xOffset = val / scale;
                    StaticDisplay2D.this.repaint();
                    return ((OptionPane)OptionPane.this).StaticDisplay2D.this.insideDisplay.xOffset * scale;
                }
            };
            this.yOffsetField = new NumberTextField(0.0, 1.0, 50.0){

                public double newValue(double val) {
                    double scale = StaticDisplay2D.this.getScale();
                    ((OptionPane)OptionPane.this).StaticDisplay2D.this.insideDisplay.yOffset = val / scale;
                    StaticDisplay2D.this.repaint();
                    return ((OptionPane)OptionPane.this).StaticDisplay2D.this.insideDisplay.yOffset * scale;
                }
            };
            this.listener = null;
            this.useDefault.setSelected(true);
            this.useNoBuffer.setToolTipText("<html>When not using transparency on Windows/XWindows,<br>this method is often (but not always) faster</html>");
            this.usageGroup.add(this.useNoBuffer);
            this.usageGroup.add(this.useBuffer);
            this.useBuffer.setToolTipText("<html>When using transparency, <i>or</i> when on a Mac,<br>this method is usually faster, but may require more<br>memory (especially on Windows/XWindows) --<br>increasing heap size can help performance.</html>");
            this.usageGroup.add(this.useDefault);
            JPanel p2 = new JPanel();
            Box b = new Box(1);
            b.add(this.useNoBuffer);
            b.add(this.useBuffer);
            b.add(this.useDefault);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(new TitledBorder("Draw Grids of Rectangles..."));
            p.add((Component)b, "Center");
            p2.setLayout(new BorderLayout());
            p2.add((Component)p, "North");
            LabelledList l = new LabelledList("Offset in Pixels");
            l.addLabelled(X_OFFSET_KEY, (Component)this.xOffsetField);
            l.addLabelled(Y_OFFSET_KEY, (Component)this.yOffsetField);
            p2.add((Component)l, "Center");
            this.getContentPane().add((Component)p2, "North");
            b = new Box(1);
            b.add(this.antialias);
            b.add(this.interpolation);
            b.add(this.alphaInterpolation);
            b.add(this.tooltips);
            p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(new TitledBorder("Graphics Features"));
            p.add((Component)b, "Center");
            this.getContentPane().add((Component)p, "Center");
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((OptionPane)OptionPane.this).StaticDisplay2D.this.useTooltips = OptionPane.this.tooltips.isSelected();
                    OptionPane.this.buffering = OptionPane.this.useDefault.isSelected() ? 0 : (OptionPane.this.useBuffer.isSelected() ? 1 : 2);
                    ((OptionPane)OptionPane.this).StaticDisplay2D.this.insideDisplay.setupHints(OptionPane.this.antialias.isSelected(), OptionPane.this.alphaInterpolation.isSelected(), OptionPane.this.interpolation.isSelected());
                    StaticDisplay2D.this.repaint();
                }
            };
            this.useNoBuffer.addActionListener(this.listener);
            this.useBuffer.addActionListener(this.listener);
            this.useDefault.addActionListener(this.listener);
            this.antialias.addActionListener(this.listener);
            this.alphaInterpolation.addActionListener(this.listener);
            this.interpolation.addActionListener(this.listener);
            this.tooltips.addActionListener(this.listener);
            b = new Box(0);
            b.add(new JLabel(" Save as Defaults for "));
            b.add(this.appPreferences);
            b.add(this.systemPreferences);
            this.getContentPane().add((Component)b, "South");
            this.systemPreferences.putClientProperty("JComponent.sizeVariant", "mini");
            this.systemPreferences.putClientProperty("JButton.buttonType", "bevel");
            this.systemPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = StaticDisplay2D.this.getPreferencesKey();
                    OptionPane.this.savePreferences(Prefs.getGlobalPreferences((String)key));
                }
            });
            this.appPreferences.putClientProperty("JComponent.sizeVariant", "mini");
            this.appPreferences.putClientProperty("JButton.buttonType", "bevel");
            this.appPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = StaticDisplay2D.this.getPreferencesKey();
                }
            });
            this.setDefaultCloseOperation(1);
            this.setResizable(false);
            this.pack();
        }

        void savePreferences(Preferences prefs) {
            try {
                prefs.putInt(DRAW_GRIDS_KEY, this.useNoBuffer.isSelected() ? 0 : (this.useBuffer.isSelected() ? 1 : 2));
                prefs.putDouble(X_OFFSET_KEY, this.xOffsetField.getValue());
                prefs.putDouble(Y_OFFSET_KEY, this.yOffsetField.getValue());
                prefs.putBoolean(ANTIALIAS_KEY, this.antialias.isSelected());
                prefs.putBoolean(BETTER_TRANSPARENCY_KEY, this.alphaInterpolation.isSelected());
                prefs.putBoolean(INTERPOLATION_KEY, this.interpolation.isSelected());
                prefs.putBoolean(TOOLTIPS_KEY, this.tooltips.isSelected());
                if (!Prefs.save((Preferences)prefs)) {
                    Utilities.inform((String)"Preferences Cannot be Saved", (String)"Your Java system can't save preferences.  Perhaps this is an applet?", (JFrame)this);
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }

        void resetToPreferences() {
            try {
                Preferences preferences = Prefs.getGlobalPreferences((String)StaticDisplay2D.this.getPreferencesKey());
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }
}

