/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.DegreeStatistics;
import sim.field.network.stats.NetworkStatistics;
import sim.util.Bag;
import sim.util.DoubleHeap;
import sim.util.IntBag;

public class ConnectivityStatistics {
    public static boolean isStronglyConnected(Network network) {
        if (network.isDirected()) {
            Bag bag = ConnectivityStatistics.getStronglyConnectedComponents(network);
            return bag.numObjs == 1;
        }
        return false;
    }

    public static Bag getStronglyConnectedComponents(Network network) {
        int i;
        int i2;
        if (!network.isDirected()) {
            throw new RuntimeException("Connect.getStronglyConnectedComponents should be called only with directed graphs");
        }
        Bag result = new Bag();
        int N = NetworkStatistics.getNumberNodes(network);
        double[] finishingTime = new double[N];
        int[] color = new int[N];
        int time = 0;
        for (i2 = 0; i2 < N; ++i2) {
            color[i2] = 0;
        }
        for (i2 = 0; i2 < N; ++i2) {
            if (color[i2] != 0) continue;
            IntBag myStack = new IntBag();
            myStack.push(i2);
            while (!myStack.isEmpty()) {
                int j = myStack.pop();
                if (color[j] == 0) {
                    color[j] = 1;
                    myStack.push(j);
                    ++time;
                    Bag edgesOut = network.getEdgesOut(network.allNodes.objs[j]);
                    for (int k = 0; k < edgesOut.numObjs; ++k) {
                        Edge edge = (Edge)edgesOut.objs[k];
                        int toNode = network.getNodeIndex(edge.to());
                        if (color[toNode] != 0) continue;
                        myStack.push(toNode);
                    }
                    continue;
                }
                color[j] = 2;
                finishingTime[j] = -(++time);
            }
        }
        Object[] indexes = new Integer[N];
        for (int i3 = 0; i3 < N; ++i3) {
            indexes[i3] = new Integer(i3);
        }
        DoubleHeap heap = new DoubleHeap(finishingTime, indexes, N);
        for (i = 0; i < N; ++i) {
            color[i] = 0;
        }
        while (!heap.isEmpty()) {
            i = (Integer)heap.extractMin();
            if (color[i] != 0) continue;
            Bag component = new Bag();
            IntBag myStack = new IntBag();
            myStack.push(i);
            while (!myStack.isEmpty()) {
                int j = myStack.pop();
                if (color[j] != 0) continue;
                color[j] = 1;
                component.add(network.allNodes.objs[j]);
                Bag edgesOut = network.getEdgesIn(network.allNodes.objs[j]);
                for (int k = 0; k < edgesOut.numObjs; ++k) {
                    Edge edge = (Edge)edgesOut.objs[k];
                    int toNode = network.getNodeIndex(edge.from());
                    if (color[toNode] != 0) continue;
                    myStack.push(toNode);
                }
            }
            result.add((Object)component);
        }
        return result;
    }

    public static Bag getConnectedComponents(Network network) {
        return new ConnectedComponentFactory(network).getComponents();
    }

    public static boolean isConnected(Network network) {
        return new ConnectedComponentFactory(network).isConnected();
    }

    static Network createFlowNetwork(Network network) {
        Network flow = new Network(true);
        flow.allNodes = new Bag(network.allNodes);
        int N = NetworkStatistics.getNumberNodes(network);
        if (network.isDirected()) {
            for (int i = 0; i < N; ++i) {
                Object node = network.allNodes.objs[i];
                Bag edgesIn = network.getEdgesIn(node);
                for (int j = 0; j < edgesIn.numObjs; ++j) {
                    flow.addEdge(((Edge)edgesIn.objs[j]).from(), node, (Object)new FlowData(0, 1));
                }
            }
        } else {
            for (int i = 0; i < N; ++i) {
                Object node = network.allNodes.objs[i];
                Bag edges = network.getEdgesIn(node);
                for (int j = 0; j < edges.numObjs; ++j) {
                    flow.addEdge(((Edge)edges.objs[j]).getOtherNode(node), node, (Object)new FlowData(0, 1));
                }
            }
        }
        return flow;
    }

    static int maxFlow(Network network, Object startNode, Object endNode) {
        int N = NetworkStatistics.getNumberNodes(network);
        int startIndex = network.getNodeIndex(startNode);
        int endIndex = network.getNodeIndex(endNode);
        for (int i = 0; i < N; ++i) {
            Object node = network.allNodes.objs[i];
            Bag edgesOut = network.getEdgesOut(node);
            for (int j = 0; j < edgesOut.numObjs; ++j) {
                Edge edge = (Edge)edgesOut.objs[j];
                ((FlowData)edge.info).flow = 0;
            }
        }
        Edge[] parent = new Edge[N];
        IntBag stack = new IntBag();
        boolean foundPath = true;
        block2: while (foundPath) {
            foundPath = false;
            for (int i = 0; i < N; ++i) {
                parent[i] = null;
            }
            stack.clear();
            stack.push(startIndex);
            while (!stack.isEmpty()) {
                int nodeIndex = stack.pop();
                Object node = network.allNodes.objs[nodeIndex];
                if (nodeIndex == endIndex) {
                    FlowData temp;
                    int maxAmount = -1;
                    Edge edge = parent[endIndex];
                    while (edge != null) {
                        temp = (FlowData)edge.info;
                        if (temp.capacity - temp.flow > maxAmount) {
                            maxAmount = temp.capacity - temp.flow;
                        }
                        edge = parent[network.getNodeIndex(edge.from())];
                    }
                    edge = parent[endIndex];
                    while (edge != null) {
                        temp = (FlowData)edge.info;
                        temp.flow += maxAmount;
                        edge = parent[network.getNodeIndex(edge.from())];
                    }
                    foundPath = true;
                    continue block2;
                }
                Bag edgesOut = network.getEdgesOut(node);
                for (int i = 0; i < edgesOut.numObjs; ++i) {
                    Object toNode;
                    int toIndex;
                    Edge edge = (Edge)edgesOut.objs[i];
                    FlowData flowData = (FlowData)edge.info;
                    if (flowData.flow >= flowData.capacity || parent[toIndex = network.getNodeIndex(toNode = edge.to())] != null || toIndex == startIndex) continue;
                    parent[toIndex] = edge;
                    stack.push(toIndex);
                }
            }
        }
        int totalFlow = 0;
        Bag bag = network.getEdgesOut(startNode);
        for (int i = 0; i < bag.numObjs; ++i) {
            Edge e = (Edge)bag.objs[i];
            FlowData data = (FlowData)e.info;
            totalFlow += data.flow;
        }
        return totalFlow;
    }

    public static int getEdgeConnectivity(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0) {
            throw new RuntimeException("The graph has no nodes at all.");
        }
        if (N == 1) {
            return NetworkStatistics.getNumberActualEdges(network);
        }
        if (!ConnectivityStatistics.isConnected(network)) {
            return 0;
        }
        if (network.isDirected()) {
            return ConnectivityStatistics.getDigraphEdgeConnectivity(network);
        }
        return ConnectivityStatistics.getGraphEdgeConnectivity(network);
    }

    public static int getDigraphEdgeConnectivity(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        Network flowNet = ConnectivityStatistics.createFlowNetwork(network);
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < N; ++i) {
            int flow = ConnectivityStatistics.maxFlow(flowNet, network.allNodes.objs[i], network.allNodes.objs[(i + 1) % N]);
            if (min <= flow) continue;
            min = flow;
        }
        return min;
    }

    public static int getGraphEdgeConnectivity(Network network) {
        Bag D = ConnectivityStatistics.getDominatingSet(network);
        int min = Integer.MAX_VALUE;
        Network flowNet = ConnectivityStatistics.createFlowNetwork(network);
        for (int i = 1; i < D.numObjs; ++i) {
            int flow = ConnectivityStatistics.maxFlow(flowNet, D.objs[0], D.objs[i]);
            if (min <= flow) continue;
            min = flow;
        }
        int minDegree = DegreeStatistics.getMinInDegree(network);
        if (min > minDegree) {
            min = minDegree;
        }
        return min;
    }

    static Bag getDominatingSet(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        boolean[] adjacent = new boolean[N];
        Bag result = new Bag();
        for (int i = 0; i < N; ++i) {
            adjacent[i] = false;
        }
        int numAdjacent = 0;
        for (int i = 0; i < N; ++i) {
            if (adjacent[i]) continue;
            adjacent[i] = true;
            ++numAdjacent;
            Object node = network.allNodes.objs[i];
            result.add(node);
            Bag edges = network.getEdgesIn(node);
            for (int j = 0; j < edges.numObjs; ++j) {
                Edge edge = (Edge)edges.objs[j];
                int index = network.getNodeIndex(edge.getOtherNode(node));
                if (adjacent[index]) continue;
                adjacent[index] = true;
                ++numAdjacent;
            }
            if (numAdjacent == N) break;
        }
        return result;
    }

    public static int getNodeConnectivity(Network network) {
        int n1;
        int i;
        int j;
        Object node;
        int i2;
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0) {
            throw new RuntimeException("The graph has no nodes at all.");
        }
        if (N == 1) {
            return 0;
        }
        if (!ConnectivityStatistics.isConnected(network)) {
            return 0;
        }
        int result = N - 1;
        Network flow = new Network(true);
        Object[] w1s = new Object[N];
        Object[] w2s = new Object[N];
        Edge[] edgeW12 = new Edge[N];
        for (i2 = 0; i2 < N; ++i2) {
            w1s[i2] = new Object();
            flow.addNode(w1s[i2]);
            w2s[i2] = new Object();
            flow.addNode(w2s[i2]);
            edgeW12[i2] = new Edge(w1s[i2], w2s[i2], (Object)new FlowData(0, 1));
            flow.addEdge(edgeW12[i2]);
        }
        if (network.isDirected()) {
            for (i2 = 0; i2 < N; ++i2) {
                node = network.allNodes.objs[i2];
                Bag edgesIn = network.getEdgesIn(node);
                for (j = 0; j < edgesIn.numObjs; ++j) {
                    flow.addEdge(w2s[network.getNodeIndex(((Edge)edgesIn.objs[j]).from())], w1s[network.getNodeIndex(node)], (Object)new FlowData(0, 1));
                }
            }
        } else {
            for (i2 = 0; i2 < N; ++i2) {
                node = network.allNodes.objs[i2];
                Bag edges = network.getEdgesIn(node);
                for (j = 0; j < edges.numObjs; ++j) {
                    flow.addEdge(w2s[network.getNodeIndex(((Edge)edges.objs[j]).getOtherNode(node))], w1s[network.getNodeIndex(node)], (Object)new FlowData(0, 1));
                }
            }
        }
        int uIndex = 0;
        int minDegree = Integer.MAX_VALUE;
        for (int i3 = 0; i3 < N; ++i3) {
            int deg = network.getEdgesOut((Object)network.allNodes.objs[i3]).numObjs + network.getEdgesIn((Object)network.allNodes.objs[i3]).numObjs;
            if (minDegree <= deg) continue;
            uIndex = i3;
            minDegree = deg;
        }
        Object u = network.allNodes.objs[uIndex];
        Bag uIn = network.getEdgesIn(u);
        Bag uOut = network.getEdgesOut(u);
        boolean[] adjacent = new boolean[N];
        if (network.isDirected()) {
            for (i = 0; i < N; ++i) {
                adjacent[i] = false;
            }
            adjacent[uIndex] = true;
            for (i = 0; i < uOut.numObjs; ++i) {
                Object toNode = ((Edge)uOut.objs[i]).to();
                adjacent[network.getNodeIndex((Object)toNode)] = true;
            }
            for (i = 0; i < N; ++i) {
                int res;
                if (adjacent[i] || result <= (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, u, uIndex, network.allNodes.objs[i], i, w1s, w2s, edgeW12))) continue;
                result = res;
            }
            for (i = 0; i < N; ++i) {
                adjacent[i] = false;
            }
            adjacent[uIndex] = true;
            for (i = 0; i < uIn.numObjs; ++i) {
                Object toNode = ((Edge)uIn.objs[i]).from();
                adjacent[network.getNodeIndex((Object)toNode)] = true;
            }
            for (i = 0; i < N; ++i) {
                int res;
                if (adjacent[i] || result <= (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, network.allNodes.objs[i], i, u, uIndex, w1s, w2s, edgeW12))) continue;
                result = res;
            }
        } else {
            for (i = 0; i < N; ++i) {
                adjacent[i] = false;
            }
            adjacent[uIndex] = true;
            for (i = 0; i < uOut.numObjs; ++i) {
                Object toNode = ((Edge)uOut.objs[i]).getOtherNode(u);
                adjacent[network.getNodeIndex((Object)toNode)] = true;
            }
            for (i = 0; i < N; ++i) {
                int res;
                if (adjacent[i] || result <= (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, u, uIndex, network.allNodes.objs[i], i, w1s, w2s, edgeW12))) continue;
                result = res;
            }
        }
        if (network.isDirected()) {
            for (n1 = 0; n1 < uIn.numObjs + uOut.numObjs; ++n1) {
                int i4;
                Object fromNode = n1 < uIn.numObjs ? ((Edge)uIn.objs[n1]).getOtherNode(u) : ((Edge)uOut.objs[n1 - uIn.numObjs]).getOtherNode(u);
                int fromNodeIndex = network.getNodeIndex(fromNode);
                for (i4 = 0; i4 < N; ++i4) {
                    adjacent[i4] = false;
                }
                adjacent[uIndex] = true;
                adjacent[fromNodeIndex] = true;
                for (i4 = 0; i4 < uIn.numObjs + uOut.numObjs; ++i4) {
                    Object toNode = i4 < uIn.numObjs ? ((Edge)uIn.objs[i4]).getOtherNode(u) : ((Edge)uOut.objs[i4 - uIn.numObjs]).getOtherNode(u);
                    adjacent[network.getNodeIndex((Object)toNode)] = true;
                }
                for (i4 = 0; i4 < N; ++i4) {
                    int res;
                    if (adjacent[i4] || result <= (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, fromNode, fromNodeIndex, network.allNodes.objs[i4], i4, w1s, w2s, edgeW12))) continue;
                    result = res;
                }
            }
        } else {
            for (n1 = 0; n1 < uIn.numObjs; ++n1) {
                int i5;
                Object fromNode = ((Edge)uIn.objs[n1]).getOtherNode(u);
                int fromNodeIndex = network.getNodeIndex(fromNode);
                for (i5 = 0; i5 < N; ++i5) {
                    adjacent[i5] = false;
                }
                adjacent[uIndex] = true;
                adjacent[fromNodeIndex] = true;
                for (i5 = 0; i5 < uOut.numObjs; ++i5) {
                    Object toNode = ((Edge)uOut.objs[i5]).getOtherNode(u);
                    adjacent[network.getNodeIndex((Object)toNode)] = true;
                }
                for (i5 = 0; i5 < N; ++i5) {
                    int res;
                    if (adjacent[i5] || result <= (res = ConnectivityStatistics.maxFlowNodeConnectivity(flow, fromNode, fromNodeIndex, network.allNodes.objs[i5], i5, w1s, w2s, edgeW12))) continue;
                    result = res;
                }
            }
        }
        return result;
    }

    static int maxFlowNodeConnectivity(Network flow, Object source, int sourceIndex, Object sink, int sinkIndex, Object[] w1s, Object[] w2s, Edge[] edgeW12) {
        flow.removeEdge(edgeW12[sourceIndex]);
        flow.removeEdge(edgeW12[sinkIndex]);
        int result = ConnectivityStatistics.maxFlow(flow, w2s[sourceIndex], w1s[sinkIndex]);
        flow.addEdge(edgeW12[sinkIndex]);
        flow.addEdge(edgeW12[sourceIndex]);
        return result;
    }

    static class FlowData {
        public int flow;
        public int capacity;

        public FlowData(int flow, int capacity) {
            this.flow = flow;
            this.capacity = capacity;
        }

        public FlowData(FlowData md) {
            this.flow = md.flow;
            this.capacity = md.capacity;
        }
    }

    static class ConnectedComponentFactory {
        final Network network;
        final int n;
        final Bag components;
        final boolean[] visited;
        int countVisited;

        public ConnectedComponentFactory(Network network) {
            this.network = network;
            this.n = network.allNodes.numObjs;
            this.visited = new boolean[this.n];
            for (int i = 0; i < this.n; ++i) {
                this.visited[i] = false;
            }
            this.countVisited = 0;
            this.components = new Bag(this.n);
        }

        public Bag getComponents() {
            boolean directed = this.network.isDirected();
            for (int i = 0; i < this.n; ++i) {
                if (this.visited[i]) continue;
                Bag component = new Bag();
                this.components.add((Object)component);
                if (directed) {
                    this.exploreWD(this.network.allNodes.objs[i], i, component);
                    continue;
                }
                this.exploreU(this.network.allNodes.objs[i], i, component);
            }
            return this.components;
        }

        public boolean isConnected() {
            if (this.network.isDirected()) {
                this.exploreWD(this.network.allNodes.objs[0], 0, null);
            } else {
                this.exploreU(this.network.allNodes.objs[0], 0, null);
            }
            return this.countVisited == this.n;
        }

        private void exploreWD(Object nodeObj, int nodeIndex, Bag component) {
            int node2Index;
            Object node2;
            int i;
            this.visited[nodeIndex] = true;
            ++this.countVisited;
            if (component != null) {
                component.add(nodeObj);
            }
            Bag temp = this.network.getEdgesOut(nodeObj);
            for (i = 0; i < temp.numObjs; ++i) {
                node2 = ((Edge)temp.objs[i]).getOtherNode(nodeObj);
                node2Index = this.network.getNodeIndex(node2);
                if (this.visited[node2Index]) continue;
                this.exploreWD(node2, node2Index, component);
            }
            temp = this.network.getEdgesIn(nodeObj);
            for (i = 0; i < temp.numObjs; ++i) {
                node2 = ((Edge)temp.objs[i]).getOtherNode(nodeObj);
                node2Index = this.network.getNodeIndex(node2);
                if (this.visited[node2Index]) continue;
                this.exploreWD(node2, node2Index, component);
            }
        }

        private void exploreU(Object nodeObj, int nodeIndex, Bag component) {
            this.visited[nodeIndex] = true;
            ++this.countVisited;
            if (component != null) {
                component.add(nodeObj);
            }
            Bag temp = this.network.getEdgesOut(nodeObj);
            for (int i = 0; i < temp.numObjs; ++i) {
                Object node2 = ((Edge)temp.objs[i]).getOtherNode(nodeObj);
                int node2Index = this.network.getNodeIndex(node2);
                if (this.visited[node2Index]) continue;
                this.exploreU(node2, node2Index, component);
            }
        }
    }
}

