/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats;

import java.util.HashSet;
import java.util.Iterator;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.EdgeMetric;
import sim.util.Bag;
import sim.util.DoubleHeap;

public class NetworkStatistics {
    public static int getNumberNodes(Network network) {
        return network.allNodes.numObjs;
    }

    public static int getNumberPotentialEdges(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (network.isDirected()) {
            return N * (N - 1);
        }
        return N * (N - 1) / 2;
    }

    public static int getNumberActualEdges(Network network) {
        int actualTies = 0;
        int N = NetworkStatistics.getNumberNodes(network);
        for (int i = 0; i < N; ++i) {
            Bag temp = network.getEdgesOut(network.allNodes.objs[i]);
            actualTies += temp.numObjs;
        }
        if (network.isDirected()) {
            return actualTies;
        }
        return actualTies / 2;
    }

    public static double getDensity(Network network) {
        if (NetworkStatistics.getNumberNodes(network) == 0) {
            return 0.0;
        }
        return (double)NetworkStatistics.getNumberActualEdges(network) / (double)NetworkStatistics.getNumberPotentialEdges(network);
    }

    public static Bag getIsolatedNodes(Network network) {
        Bag result = new Bag();
        int N = NetworkStatistics.getNumberNodes(network);
        Iterator i = network.indexOutInHash.values().iterator();
        for (int k = 0; k < N; ++k) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)i.next();
            if (ioi.in != null && ioi.in.numObjs != 0 || ioi.out != null && ioi.out.numObjs != 0) continue;
            result.add(network.allNodes.objs[ioi.index]);
        }
        return result;
    }

    public static double getInclusiveness(Network network) {
        int N = NetworkStatistics.getNumberNodes(network);
        int count = 0;
        Iterator i = network.indexOutInHash.values().iterator();
        for (int k = 0; k < N; ++k) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)i.next();
            if (ioi.in != null && ioi.in.numObjs != 0 || ioi.out != null && ioi.out.numObjs != 0) continue;
            ++count;
        }
        return (double)(N - count) / (double)N;
    }

    public static double[] getShortestPaths(Network network, Object startNode, EdgeMetric computer) {
        double[] result = new double[network.allNodes.numObjs];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.POSITIVE_INFINITY;
        }
        DoubleHeap heap = new DoubleHeap();
        heap.add(startNode, 0.0);
        while (!heap.isEmpty()) {
            double dist = heap.getMinKey();
            Object node = heap.extractMin();
            int nodeIndex = network.getNodeIndex(node);
            if (result[nodeIndex] <= dist) continue;
            result[nodeIndex] = dist;
            Bag edgesOut = network.getEdgesOut(node);
            for (int i = 0; i < edgesOut.numObjs; ++i) {
                double newDist;
                Edge edge = (Edge)edgesOut.objs[i];
                int toNode = network.getNodeIndex(((Edge)edgesOut.objs[i]).getOtherNode(node));
                if (!(result[toNode] > (newDist = dist + computer.getWeight(edge)))) continue;
                heap.add(network.allNodes.objs[toNode], newDist);
            }
        }
        return result;
    }

    public static double getShortestPath(Network network, Object startNode, Object endNode, EdgeMetric computer) {
        if (startNode.equals(endNode)) {
            return 0.0;
        }
        double[] result = new double[network.allNodes.numObjs];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.POSITIVE_INFINITY;
        }
        DoubleHeap heap = new DoubleHeap();
        heap.add(startNode, 0.0);
        while (!heap.isEmpty()) {
            double dist = heap.getMinKey();
            Object node = heap.extractMin();
            int nodeIndex = network.getNodeIndex(node);
            if (result[nodeIndex] <= dist) continue;
            result[nodeIndex] = dist;
            if (node.equals(endNode)) {
                return dist;
            }
            Bag edgesOut = network.getEdgesOut(node);
            for (int i = 0; i < edgesOut.numObjs; ++i) {
                double newDist;
                Edge edge = (Edge)edgesOut.objs[i];
                int toNode = network.getNodeIndex(((Edge)edgesOut.objs[i]).getOtherNode(node));
                if (!(result[toNode] > (newDist = dist + computer.getWeight(edge)))) continue;
                heap.add(network.allNodes.objs[toNode], newDist);
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double getClusteringCoefficient(Network network) {
        double clusteringCoefficient = 0.0;
        int N = NetworkStatistics.getNumberNodes(network);
        boolean[] allFalse = new boolean[N];
        HashSet<Object> neighbors = new HashSet<Object>();
        for (int i = 0; i < N; ++i) {
            neighbors.clear();
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            for (int j = 0; j < edgesOut.numObjs; ++j) {
                Object toNode = ((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]);
                if (toNode.equals(network.allNodes.objs[i])) continue;
                neighbors.add(toNode);
            }
            int pairs = 0;
            Iterator iter = neighbors.iterator();
            while (iter.hasNext()) {
                Object neigh = iter.next();
                Bag edgesOutOfNeigh = network.getEdgesOut(neigh);
                for (int j = 0; j < edgesOutOfNeigh.numObjs; ++j) {
                    Object toNode = ((Edge)edgesOutOfNeigh.objs[j]).getOtherNode(neigh);
                    if (toNode.equals(network.allNodes.objs[i]) || toNode.equals(neigh) || !neighbors.contains(toNode)) continue;
                    ++pairs;
                }
            }
            if (edgesOut.numObjs < 2) continue;
            clusteringCoefficient += (double)pairs / (double)(edgesOut.numObjs * (edgesOut.numObjs - 1));
        }
        return clusteringCoefficient / (double)N;
    }

    public static boolean isMultigraphNetwork(Network network) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < network.allNodes.numObjs; ++i) {
            hashSet.clear();
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            for (int j = 0; j < edgesOut.numObjs; ++j) {
                Object toNode = ((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]);
                if (hashSet.contains(toNode)) {
                    return true;
                }
                hashSet.add(toNode);
            }
        }
        return false;
    }

    public static boolean getHasSelfLoops(Network network) {
        for (int i = 0; i < network.allNodes.numObjs; ++i) {
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            for (int j = 0; j < edgesOut.numObjs; ++j) {
                Object toNode = ((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]);
                if (!network.allNodes.objs[i].equals(((Edge)edgesOut.objs[j]).getOtherNode(network.allNodes.objs[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public static double getSymmetryCoefficient(Network network) {
        if (!network.isDirected()) {
            return 1.0;
        }
        int totalNumberEdges = 0;
        int symmetricEdges = 0;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < network.allNodes.numObjs; ++i) {
            hashSet.clear();
            Bag edgesOut = network.getEdgesOut(network.allNodes.objs[i]);
            for (int j = 0; j < edgesOut.numObjs; ++j) {
                hashSet.add(((Edge)edgesOut.objs[j]).to());
            }
            Bag edgesIn = network.getEdgesIn(network.allNodes.objs[i]);
            for (int j = 0; j < edgesIn.numObjs; ++j) {
                if (!hashSet.contains(((Edge)edgesIn.objs[j]).to())) continue;
                ++symmetricEdges;
            }
            totalNumberEdges += edgesIn.numObjs;
        }
        if (totalNumberEdges > 0) {
            return (double)symmetricEdges / (double)totalNumberEdges;
        }
        return 1.0;
    }

    public static double[][] getShortestPathsMatrix(Network network, EdgeMetric computer) {
        int numNodes = NetworkStatistics.getNumberNodes(network);
        int numEdges = NetworkStatistics.getNumberActualEdges(network);
        if ((double)numEdges > (double)numNodes * Math.sqrt(numNodes)) {
            return NetworkStatistics.floydWarshallShortestPathsMatrix(network, computer);
        }
        return NetworkStatistics.johnsonShortestPathsMatrix(network, computer);
    }

    public static double[][] floydWarshallShortestPathsMatrix(Network network, EdgeMetric computer) {
        int j;
        int i;
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        for (i = 0; i < N; ++i) {
            for (int j2 = 0; j2 < N; ++j2) {
                result[i][j2] = Double.POSITIVE_INFINITY;
            }
        }
        for (i = 0; i < N; ++i) {
            Bag bag = network.getEdgesOut(network.allNodes.objs[i]);
            for (j = 0; j < bag.numObjs; ++j) {
                Edge edge = (Edge)bag.objs[j];
                result[i][network.getNodeIndex((Object)edge.getOtherNode((Object)network.allNodes.objs[i]))] = computer.getWeight(edge);
            }
        }
        for (i = 0; i < N; ++i) {
            result[i][i] = 0.0;
        }
        for (int k = 0; k < N; ++k) {
            for (int i2 = 0; i2 < N; ++i2) {
                for (j = 0; j < N; ++j) {
                    if (!(result[i2][j] > result[i2][k] + result[k][j])) continue;
                    result[i2][j] = result[i2][k] + result[k][j];
                }
            }
        }
        return result;
    }

    public static double[][] johnsonShortestPathsMatrix(Network network, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        DoubleHeap heap = new DoubleHeap();
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < result.length; ++j) {
                result[i][j] = Double.POSITIVE_INFINITY;
            }
            heap.clear();
            heap.add(network.allNodes.objs[i], 0.0);
            while (!heap.isEmpty()) {
                double dist = heap.getMinKey();
                Object node = heap.extractMin();
                int nodeIndex = network.getNodeIndex(node);
                if (result[i][nodeIndex] > -1.0 && result[i][nodeIndex] <= dist) continue;
                result[i][nodeIndex] = dist;
                Bag edgesOut = network.getEdgesOut(node);
                for (int j = 0; j < edgesOut.numObjs; ++j) {
                    double newDist;
                    Edge edge = (Edge)edgesOut.objs[j];
                    int toNode = network.getNodeIndex(((Edge)edgesOut.objs[j]).getOtherNode(node));
                    if (!(result[i][toNode] > (newDist = dist + computer.getWeight(edge)))) continue;
                    heap.add(network.allNodes.objs[toNode], newDist);
                }
            }
            result[i][i] = 0.0;
        }
        return result;
    }

    public static double getMeanShortestPath(Network network, EdgeMetric computer) {
        try {
            double result = 0.0;
            double[][] paths = NetworkStatistics.getShortestPathsMatrix(network, computer);
            int N = paths.length;
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    if (i == j) continue;
                    result += paths[i][j];
                }
            }
            return result / (double)(N * (N - 1));
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("You ran out of memory!  getMeanShortestPath(...) has large memory requirements and may not be appropriate for big networks.  You should try getLargeNetworkMeanShortestPath(...) instead.", e);
        }
    }

    public static double getLargeNetworkMeanShortestPath(Network network, EdgeMetric computer) {
        double result = 0.0;
        Bag nodes = network.getAllNodes();
        int N = nodes.numObjs;
        if (!network.isDirected()) {
            for (int i = 0; i < N - 1; ++i) {
                Object node = nodes.get(i);
                double[] paths = NetworkStatistics.getShortestPaths(network, node, computer);
                for (int j = i + 1; j < N; ++j) {
                    result += paths[j];
                }
            }
            return result / ((double)(N * (N - 1)) / 2.0);
        }
        for (int i = 0; i < N; ++i) {
            Object node = nodes.get(i);
            double[] paths = NetworkStatistics.getShortestPaths(network, node, computer);
            for (int j = 0; j < N; ++j) {
                if (i == j) continue;
                result += paths[j];
            }
        }
        return result / (double)(N * (N - 1));
    }

    public static double getNodeEccentricity(Network network, Object node, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0) {
            return 0.0;
        }
        double[] dist = NetworkStatistics.getShortestPaths(network, node, computer);
        double max = dist[0];
        for (int i = 1; i < dist.length; ++i) {
            if (!(max < dist[i])) continue;
            max = dist[i];
        }
        return max;
    }

    public static double getRadius(Network network, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0 || N == 1) {
            return 0.0;
        }
        double min = Double.POSITIVE_INFINITY;
        for (int nn = 0; nn < N; ++nn) {
            double dist = NetworkStatistics.getNodeEccentricity(network, network.allNodes.objs[nn], computer);
            if (!(min > dist)) continue;
            min = dist;
        }
        return min;
    }

    public static double getDiameter(Network network, EdgeMetric computer) {
        int N = NetworkStatistics.getNumberNodes(network);
        if (N == 0 || N == 1) {
            return 0.0;
        }
        double max = -1.0;
        for (int nn = 0; nn < N; ++nn) {
            double dist = NetworkStatistics.getNodeEccentricity(network, network.allNodes.objs[nn], computer);
            if (!(max < dist)) continue;
            max = dist;
        }
        return max;
    }

    public static long[][] johnsonNumberShortestPathsMatrix(Network network, EdgeMetric computer, double precision) {
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        long[][] number = new long[N][N];
        DoubleHeap heap = new DoubleHeap();
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                result[i][j] = Double.POSITIVE_INFINITY;
                number[i][j] = 0L;
            }
            heap.clear();
            heap.add(new Pair(network.allNodes.objs[i], -1), 0.0);
            while (!heap.isEmpty()) {
                boolean shouldExpand = true;
                double dist = heap.getMinKey();
                Pair node = (Pair)heap.extractMin();
                int nodeIndex = network.getNodeIndex(node.object);
                if (result[i][nodeIndex] < dist - precision) continue;
                if (result[i][nodeIndex] > dist + precision) {
                    result[i][nodeIndex] = dist;
                    number[i][nodeIndex] = node.index < 0 ? 1L : number[i][node.index];
                } else {
                    if (node.index < 0) {
                        long[] lArray = number[i];
                        int n = nodeIndex;
                        lArray[n] = lArray[n] + 1L;
                    } else {
                        long[] lArray = number[i];
                        int n = nodeIndex;
                        lArray[n] = lArray[n] + number[i][node.index];
                    }
                    shouldExpand = false;
                }
                if (!shouldExpand) continue;
                Bag edgesOut = network.getEdgesOut(node.object);
                for (int j = 0; j < edgesOut.numObjs; ++j) {
                    double newDist;
                    Edge edge = (Edge)edgesOut.objs[j];
                    int toNode = network.getNodeIndex(((Edge)edgesOut.objs[j]).getOtherNode(node.object));
                    if (!(result[i][toNode] >= (newDist = dist + computer.getWeight(edge)) + precision)) continue;
                    heap.add(new Pair(network.allNodes.objs[toNode], nodeIndex), newDist);
                }
            }
            result[i][i] = 0.0;
        }
        return number;
    }

    public static long[][] floydWarshallNumberShortestPathsMatrix(Network network, EdgeMetric computer, double precision) {
        int j;
        int i;
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        long[][] number = new long[N][N];
        for (i = 0; i < N; ++i) {
            for (int j2 = 0; j2 < N; ++j2) {
                result[i][j2] = Double.POSITIVE_INFINITY;
                number[i][j2] = 0L;
            }
        }
        for (i = 0; i < N; ++i) {
            Bag bag = network.getEdgesOut(network.allNodes.objs[i]);
            for (j = 0; j < bag.numObjs; ++j) {
                Edge edge = (Edge)bag.objs[j];
                int k = network.getNodeIndex(edge.getOtherNode(network.allNodes.objs[i]));
                result[i][k] = computer.getWeight(edge);
                long[] lArray = number[i];
                int n = k;
                lArray[n] = lArray[n] + 1L;
            }
        }
        for (i = 0; i < N; ++i) {
            result[i][i] = 0.0;
        }
        for (int k = 0; k < N; ++k) {
            for (int i2 = 0; i2 < N; ++i2) {
                for (j = 0; j < N; ++j) {
                    if (result[i2][j] > result[i2][k] + result[k][j] + precision) {
                        result[i2][j] = result[i2][k] + result[k][j];
                        number[i2][j] = number[i2][k] * number[k][j];
                        continue;
                    }
                    if (!(NetworkStatistics.abs(result[i2][j] - (result[i2][k] + result[k][j])) <= precision)) continue;
                    long[] lArray = number[i2];
                    int n = j;
                    lArray[n] = lArray[n] + number[i2][k] * number[k][j];
                }
            }
        }
        return number;
    }

    public static long[][][] floydWarshallNumberShortestPathsWithIntermediatesMatrix(Network network, EdgeMetric computer, double precision) {
        int j;
        int i;
        int N = NetworkStatistics.getNumberNodes(network);
        double[][] result = new double[N][N];
        long[][] number = new long[N][N];
        for (i = 0; i < N; ++i) {
            for (int j2 = 0; j2 < N; ++j2) {
                result[i][j2] = Double.POSITIVE_INFINITY;
                number[i][j2] = 0L;
            }
        }
        for (i = 0; i < N; ++i) {
            Bag bag = network.getEdgesOut(network.allNodes.objs[i]);
            for (j = 0; j < bag.numObjs; ++j) {
                Edge edge = (Edge)bag.objs[j];
                int k = network.getNodeIndex(edge.getOtherNode(network.allNodes.objs[i]));
                result[i][k] = computer.getWeight(edge);
                long[] lArray = number[i];
                int n = k;
                lArray[n] = lArray[n] + 1L;
            }
        }
        for (i = 0; i < N; ++i) {
            result[i][i] = 0.0;
        }
        for (int k = 0; k < N; ++k) {
            for (int i2 = 0; i2 < N; ++i2) {
                for (j = 0; j < N; ++j) {
                    if (result[i2][j] > result[i2][k] + result[k][j] + precision) {
                        result[i2][j] = result[i2][k] + result[k][j];
                        number[i2][j] = number[i2][k] * number[k][j];
                        continue;
                    }
                    if (!(NetworkStatistics.abs(result[i2][j] - (result[i2][k] + result[k][j])) <= precision)) continue;
                    long[] lArray = number[i2];
                    int n = j;
                    lArray[n] = lArray[n] + number[i2][k] * number[k][j];
                }
            }
        }
        long[][][] theResult = new long[N][N][N];
        for (int i3 = 0; i3 < N; ++i3) {
            for (j = 0; j < N; ++j) {
                for (int k = 0; k < N; ++k) {
                    theResult[i3][j][k] = NetworkStatistics.abs(result[i3][j] + result[j][k] - result[i3][k]) <= precision ? number[i3][j] * number[j][k] : 0L;
                }
            }
        }
        return theResult;
    }

    public static long[][] getNumberShortestPathsMatrix(Network network, EdgeMetric computer, double precision) {
        int numNodes = NetworkStatistics.getNumberNodes(network);
        int numEdges = NetworkStatistics.getNumberActualEdges(network);
        if ((double)numEdges > (double)numNodes * Math.sqrt(numNodes)) {
            return NetworkStatistics.floydWarshallNumberShortestPathsMatrix(network, computer, precision);
        }
        return NetworkStatistics.johnsonNumberShortestPathsMatrix(network, computer, precision);
    }

    public static long[][][] getNumberShortestPathsWithIntermediatesMatrix(Network network, EdgeMetric computer, double precision) {
        return NetworkStatistics.floydWarshallNumberShortestPathsWithIntermediatesMatrix(network, computer, precision);
    }

    static final double abs(double x) {
        return x > 0.0 ? x : -x;
    }

    static class Pair {
        Object object;
        int index;

        public Pair(Object o, int i) {
            this.object = o;
            this.index = i;
        }
    }
}

