/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import sim.field.network.Network;
import sim.field.network.stats.NetworkStatistics;
import sim.field.network.stats.UnitEdgeMetric;
import sim.field.network.stats.actorcentrality.FreemanNodeIndex;

public class BetweennessCentrality
extends FreemanNodeIndex {
    final long[][][] g3;
    final long[][] g2;

    public BetweennessCentrality(Network network) {
        super(network);
        this.g3 = NetworkStatistics.getNumberShortestPathsWithIntermediatesMatrix(network, UnitEdgeMetric.defaultInstance, 0.0);
        this.g2 = NetworkStatistics.getNumberShortestPathsMatrix(network, UnitEdgeMetric.defaultInstance, 0.0);
    }

    public double getValue(Object node) {
        int index = this.network.getNodeIndex(node);
        int n = this.network.allNodes.numObjs;
        double sum = 0.0;
        if (this.network.isDirected()) {
            for (int k = 0; k < n; ++k) {
                if (k == index) continue;
                long[] g2_k = this.g2[k];
                long[] g3_ki = this.g3[k][index];
                for (int j = 0; j < n; ++j) {
                    sum += (double)g3_ki[j] / (double)g2_k[j];
                }
            }
        } else {
            for (int k = 1; k < n; ++k) {
                if (k == index) continue;
                long[] g2_k = this.g2[k];
                long[] g3_ki = this.g3[k][index];
                for (int j = 0; j < k; ++j) {
                    sum += (double)g3_ki[j] / (double)g2_k[j];
                }
            }
        }
        return sum;
    }

    public double getMaxCummulativeDifference() {
        int n = this.network.allNodes.numObjs;
        int value = (n - 1) * (n - 1) * (n - 2);
        if (this.network.isDirected()) {
            return value;
        }
        return 0.5 * (double)value;
    }

    public double getMaxValue() {
        int n = this.network.allNodes.numObjs;
        int value = (n - 1) * (n - 2);
        if (this.network.isDirected()) {
            return value;
        }
        return 0.5 * (double)value;
    }
}

